<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/fixedheader/3.1.7/css/fixedHeader.dataTables.min.css" />

<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.7/js/dataTables.fixedHeader.min.js"></script>

<style type="text/css">
    fieldset
    {
        border: 1px solid #ddd !important;
        margin: 0;
        xmin-width: 0;
        padding: 10px;
        position: relative;
        border-radius:4px;
        background-color:#f5f5f5;
        padding-left:10px!important;
    }

    legend
    {
        font-size:14px;
        font-weight:bold;
        margin-bottom: 0px;
        width: 35%;
        border: 1px solid #ddd;
        border-radius: 4px;
        padding: 5px 5px 5px 10px;
        background-color: #ffffff;
    }
</style>

<style>
    table.dataTable tbody tr.selected {
        /*background-color: #b0bed9;*/
        border: 1px solid #fcd113;
        background: #f8da4e url(images/ui-bg_glass_55_f8da4e_1x400.png) 50% 50% repeat-x;
        color: #915608;
    }
    table.dataTable thead th, table.dataTable thead td {
        /*padding: 10px 18px;
        border-bottom: 1px solid #111;*/
        font-weight: normal;
        color: rgb(255, 255, 255);
        border-width: 1px;
        border-style: solid;
        border-color: rgb(119, 213, 247);
        border-image: initial;
        background: url(images/ui-bg_glass_45_0078ae_1x400.png) 50% 50% repeat-x rgb(0, 120, 174);

    }

    .table-hover tbody tr:hover {
        border: 1px solid #448dae;
        background: #79c9ec url(images/ui-bg_glass_45_0078ae_1x400.png) 50% 50% repeat-x;
        /*background-color: rgba(0,0,0,.075);*/
        font-weight: normal;
        color: #026890;
    }

    .ui-state-highlight, .ui-widget-content .ui-state-highlight, .ui-widget-header .ui-state-highlight {
        border: 1px solid #fcd113;
        background: #f8da4e url(images/ui-bg_glass_55_f8da4e_1x400.png) 50% 50% repeat-x;
        color: #915608;
    }
    .ui-state-default, .ui-widget-content .ui-state-default, .ui-widget-header .ui-state-default, .ui-button, html .ui-button.ui-state-disabled:hover, html .ui-button.ui-state-disabled:active {
        font-weight: normal;
        color: rgb(255, 255, 255);
        border-width: 1px;
        border-style: solid;
        border-color: rgb(119, 213, 247);
        border-image: initial;
        background: url(images/ui-bg_glass_45_0078ae_1x400.png) 50% 50% repeat-x rgb(0, 120, 174);
    }
</style>

<div id="content_alert" style=""></div>

<form class="was-validated" name="form1" id="form1" method="POST" action="" onsubmit="return realizarProceso();">
    <input type="hidden" name="Control" value="1">
    <input type="hidden" id="ProductoNuevo" name="ProductoNuevo" value="0">

    <fieldset class="">
        <legend class="w-auto">Producto Principal</legend>
        <div class="card">
            <div class="form-row mx-0">
                <div class="col-md-2 mb-1">
                    <label class="col-form-label" for="">Codigo</label>
                    <input type="text" class="form-control text-center" name="" id="" value="<?=$o_ALM_ItemMastBN->getIdItem()?>" autocomplete="off" disabled>
                </div>
                <div class="col-md-4 mb-1">
                    <label class="col-form-label" for="">Descripci&oacute;n</label>
                    <input type="text" class="form-control" name="" id="" autocomplete="off" value="<?=$o_ALM_ItemMastBN->getDescripcionCompleta()?>" disabled>
                </div>
                <div class="col-md-1 mb-1">
                    <label class="col-form-label" for="ProductoPadreCantidad">Cantidad</label>
                    <input type="text" class="form-control text-center" name="ProductoPadreCantidad" id="ProductoPadreCantidad" value="1" autocomplete="off" onfocus="this.select();" required>
                </div>
                <div class="col-md-2 mb-1">
                    <label class="col-form-label" for="">Unidad</label>
                    <input type="text" class="form-control text-center" name="" id="" value="<?=$o_ALM_ItemMastBN->getUnidadVentaDesc()?>" autocomplete="off" disabled>
                </div>
                <div class="col-md-2 mb-1">
                    <label class="col-form-label" for="">Precio Uni IGV</label>
                    <input type="text" class="form-control text-center" name="" id="" value="<?=MST_ListaPrecioDetalleFN::buscarPorCostoGeneral( $o_ALM_ItemMastBN->getIdItem() )->getPrecioVentaIGV()?>" autocomplete="off" disabled>
                </div>
                <div class="col-md-1 mb-1">
                    <label class="col-form-label" for="">Stock</label>
                    <input type="text" class="form-control text-center" name="" id="" value="<?=ALM_ItemAlmacenStockFN::getStockFisicoTotal( $o_ALM_ItemMastBN->getIdItem() )?>" autocomplete="off" disabled>
                </div>
            </div>
        </div>
    </fieldset>

    <div class="dropdown-divider"></div>

    <fieldset class="" id="content_prod_final">
        <legend class="w-auto">Producto Final</legend>
        <div class="card">
            <div class="form-row mx-0">
                <div class="col-md-2 mb-1">
                    <label class="col-form-label" for="ProductoHijoCod">Codigo</label>
                    <input type="text" class="form-control text-center" name="ProductoHijoCod" id="ProductoHijoCod" readonly autocomplete="off">
                </div>
                <div class="col-md-4 mb-1">
                    <label class="col-form-label" for="ProductoHijoDesc">Descripci&oacute;n</label>
                    <input type="text" class="form-control" name="ProductoHijoDesc" id="ProductoHijoDesc" autocomplete="off" required>
                </div>
                <div class="col-md-1 mb-1">
                    <label class="col-form-label" for="ProductoHijoCantidad">Cantidad</label>
                    <input type="text" class="form-control text-center" name="ProductoHijoCantidad" id="ProductoHijoCantidad" autocomplete="off" onfocus="this.select();" required>
                </div>
                <div class="col-md-2 mb-1">
                    <label class="col-form-label" for="ProductoHijoIdUnidad">Unidad</label>
                    <select class="form-control" name="ProductoHijoIdUnidad" id="ProductoHijoIdUnidad" >
                        <?php foreach ( MST_UnidadMastFN::selectActivos() as $o_MST_UnidadMastBN ){ ?>
                            <option value="<?=$o_MST_UnidadMastBN->getIdUnidad()?>"  > <?=$o_MST_UnidadMastBN->getDescripcionCorta()?> </option>
                        <?php } ?>
                    </select>
                </div>
                <div class="col-md-2 mb-1">
                    <label class="col-form-label" for="ProductoHijoPrecio">Precio Uni IGV</label>
                    <input type="text" class="form-control text-center" name="ProductoHijoPrecio" id="ProductoHijoPrecio" autocomplete="off" onfocus="this.select();" required>
                </div>
                <div class="col-md-1 mb-1">
                    <button style="margin-top: 5px;" type="button" class="btn btn-danger btn-sm btn-block" onclick="limpiarProductoAjuste();" id="btn_limpiar" disabled>LIMPIAR</button>
                    <button style="" type="submit" class="btn btn-primary btn-sm btn-block" onclick="" >GUARDAR</button>
                </div>
            </div>
        </div>
    </fieldset>

    <div class="dropdown-divider"></div>

    <fieldset class="" id="content_filtro_prod">
        <legend class="w-auto">Filtro</legend>
        <div class="card">
            <div class="form-row mx-0">
                <div class="col-md-3 mb-1 mt-1">
                    <div class="form-row mx-0">
                        <div class="col-md-2 mb-1 mt-1">
                            <label class="col-form-label" for="ProductoHijoPrecio">Descrip</label>
                        </div>
                        <div class="col-md-10 mb-1 mt-1">
                            <input type="text" class="form-control text-center" name="DescripcionCompleta" id="DescripcionCompleta" value="" placeholder="" autocomplete="off" >
                        </div>
                    </div>
                </div>
                <div class="col-md-3 mb-1 mt-1">
                    <input type="text" class="form-control text-center" name="" id="" value="Marca: <?=$o_ALM_ItemMastBN->getDescripcionMarca()?>" autocomplete="off" disabled>
                </div>
                <div class="col-md-3 mb-1 mt-1">
                    <input type="text" class="form-control text-center" name="" id="" value="Linea: <?=$o_ALM_ItemMastBN->getDescripcionLinea()?>" autocomplete="off" disabled>
                </div>
                <div class="col-md-3 mb-1 mt-1">
                    <input type="text" class="form-control text-center" name="" id="" value="Familia: <?=$o_ALM_ItemMastBN->getDescripcionFamilia()?>" autocomplete="off" disabled>
                </div>
            </div>
        </div>
    </fieldset>

    <div class="dropdown-divider"></div>

    <script>
        $( "#DescripcionCompleta" ).keyup
        (
            function( e )
            {
                actualizarListProductos();
            }
        );
        actualizarListProductos = function(  )
        {
            var s_Param = $( '#content_filtro_prod :input' ).serialize();
            s_Param += "&IdMarca=<?=$o_ALM_ItemMastBN->getIdMarca()?>&IdLinea=<?=$o_ALM_ItemMastBN->getIdLinea()?>&IdFamilia=<?=$o_ALM_ItemMastBN->getIdFamilia()?>&IdItemRef=<?=$o_ALM_ItemMastBN->getIdItem()?>";
            executeAjaxUpdater
            (
                "content_list_prod",
                "<?php echo buildUrl( 'item/gridPorAjuste' ) ?>",
                s_Param,
                function( response )
                {

                }
            );
        }
    </script>

    <fieldset class="">
        <legend class="w-auto">Productos Relacionados</legend>
            <!--<table class="table table-bordered table-hover" id="example">-->
        <div id="content_list_prod">
            <table id="example" class="table table-striped table-bordered" border="1" style="width:100%">
                <thead>
                <tr class="table-primary">
                    <th scope="col" class="text-center">Nro</th>
                    <th scope="col" class="text-center">Codigo</th>
                    <th scope="col" class="text-left">Descripci&oacute;n</th>
                    <th scope="col" class="text-center">Marca</th>
                    <th scope="col" class="text-center">Unidad</th>
                    <th scope="col" class="text-center">Stock</th>
                    <th scope="col" class="text-center">Precio</th>
                </tr>
                </thead>
                <tbody>
                <?php $i_Key = 0 ?>
                <?php foreach ( $a_ALM_ItemMast as $o_TMP_ALM_ItemMastBN ) { ?>
                    <?php
                    if( $o_TMP_ALM_ItemMastBN->getIdItem() == $o_ALM_ItemMastBN->getIdItem() )
                    {
                        continue;
                    }
                    $i_Key++;
                    ?>
                <tr>
                    <td class="text-center"><?=$i_Key?></td>
                    <td class="text-center"><?=$o_TMP_ALM_ItemMastBN->getIdItem()?></td>
                    <td class="text-left"><?=$o_TMP_ALM_ItemMastBN->getDescripcionCompleta()?></td>
                    <td class="text-center"><?=$o_TMP_ALM_ItemMastBN->getDescripcionMarca()?></td>
                    <td class="text-center"><?=$o_TMP_ALM_ItemMastBN->getUnidadVentaDesc()?></td>
                    <td class="text-center"><?=ALM_ItemAlmacenStockFN::getStockFisicoTotal( $o_TMP_ALM_ItemMastBN->getIdItem() )?></td>
                    <td class="text-center"><?=MST_ListaPrecioDetalleFN::buscarPorCostoGeneral( $o_TMP_ALM_ItemMastBN->getIdItem() )->getPrecioVentaIGV()?></td>
                <?php } ?>
                </tbody>
            </table>
        </div>
    </fieldset>
</form>

<script>
    realizarProceso = function()
    {
        x = confirm( "Esta seguro de continuar?" );
        if( x )
        {
            blockContent( 'form1' );
            return true;
        }
        return false;
    }

    buscarProductoAjuste = function( IdItem )
    {
        blockContent( 'content_prod_final' );
        executeAjaxJson
        (
            "<?php echo buildUrl( 'item/request', "TipoProc=info_item&IdItem=" ) ?>" + IdItem,
            "",
            function( o_json )
            {
                pr( o_json );
                unBlockContent( 'content_prod_final' );
                if( o_json.error )
                {
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }

                $( "#ProductoHijoCod" ).val( o_json.IdItem );
                $( "#ProductoHijoDesc" ).val( o_json.DescripcionCompleta );
                $( "#ProductoHijoIdUnidad" ).val( o_json.UnidadVenta );
                $( "#ProductoHijoCantidad" ).val( "" );
                $( "#ProductoHijoPrecio" ).val( o_json.PrecioConIGV );

                $( 'html, body' ).animate( { scrollTop : 0 }, 800 );
                $( "#ProductoNuevo" ).val( "1" );
                $( "#ProductoHijoCantidad" ).focus();
            }
        );
        $( "#btn_limpiar" ).prop( 'disabled', false );
    }

    limpiarProductoAjuste = function(  )
    {
        table.$( 'tr.selected' ).removeClass( 'selected' ); //elimina lo seleccionado en cualquier tr
        $( "#btn_limpiar" ).prop( 'disabled', true );

        $( "#ProductoHijoCod" ).val( "" );
        $( "#ProductoHijoDesc" ).val( "" );
        $( "#ProductoHijoCantidad" ).val( "" );
        $( "#ProductoHijoIdUnidad" ).val( "" );
        $( "#ProductoHijoPrecio" ).val( "" );

        $( "#ProductoNuevo" ).val( "0" );
    }
</script>

<script>
    var table = $('#example').DataTable(
        {
             language: { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
             //responsive: { details: true },
            responsive:     false,
             searching: false,
             info:     false,
             lengthChange: false,
             paging:   false,
             dom: 'lrtip',
             fixedHeader:
                 {
                     header: true,
                     footer: true
                 }
         }
     );

    $( '#example tbody' ).on(
        'click', 'tr', function ()
        {
            pr( this );
            var currentRow = $( this ).closest( "tr" );
            pr( currentRow.find("td:eq(1)").text() );
            if ( $( this ).hasClass( 'selected' ) )
            {
                $( this ).removeClass( 'selected' );
            }
            else
            {
                table.$( 'tr.selected' ).removeClass( 'selected' ); //elimina lo seleccionado en cualquier tr
                $( this ).addClass( 'selected' );
            }

            buscarProductoAjuste( currentRow.find("td:eq(1)").text() );
        }
    );

    $('#button').click(
        function ()
        {
            table.row( '.selected' ).remove().draw( false );
        }
    );
</script>

<script>
<?php if( $b_Control ){ ?>
window.open( '<?=buildUrlComplet( 'rep.php/rep/consultaKardex', 'IdOrdenCab='.$i_IdOrdenCab )?>', '_BLANK' );
<?php } ?>
<?php if( $s_Mensaje != "" ){ ?>
showAlertBootStrap( 'content_alert', 'alert-danger', "<?=$s_Mensaje?>" );
<?php } ?>
</script>