<?php
class PrdPorAjusteAction extends wtActions
{
    public function execute()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->b_Control = $this->getRequestParameter( "Control" );
        $this->s_Mensaje = "";
        $this->i_IdOrdenCab = 0;

        $o_ALM_ItemMastBN = ALM_ItemMastFN::buscarItemxId( $this->getRequestParameter( "id_item" ) );
        $this->o_ALM_ItemMastBN = $o_ALM_ItemMastBN;

        $i_IdUniMedVenta = $o_ALM_ItemMastBN->getIdUniMedVenta();
        $o_MST_UnidadConversionMastFN = new MST_UnidadConversionMastFN();
        $o_MST_UnidadConversionMastFN->setIdUnidad( $i_IdUniMedVenta );
        $a_MST_UnidadConversionMast = $o_MST_UnidadConversionMastFN->select();
        $a_IdUniEq                  = array();
        foreach( $a_MST_UnidadConversionMast as $o_MST_UnidadConversionMastBN )
        {
            $a_IdUniEq[] = $o_MST_UnidadConversionMastBN->getIdUnidadEquivalente();
        }

        if( $this->b_Control )
        {
            $con = Conexion::getConexion();
            $con->begin();
            try
            {
                $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPorCostoGeneral( $this->o_ALM_ItemMastBN->getIdItem() );
                $f_PadrePrecioCosto = $o_MST_ListaPrecioDetalleBN->getPrecioCosto();
                $f_PadrePrecioCostoIGV = $o_MST_ListaPrecioDetalleBN->getPrecioCostoIGV();

                $i_ProductoNuevo = intval( $this->getRequestParameter( "ProductoNuevo" ) );

                $f_ProductoPadreCantidad = floatval( $this->getRequestParameter( "ProductoPadreCantidad" ) );

                $s_IdItemHijo           = trim( $this->getRequestParameter( "ProductoHijoCod" ) );
                $s_DetalleDescripcion   = trim( $this->getRequestParameter( "ProductoHijoDesc" ) );
                $f_ProductoHijoCantidad = floatval( $this->getRequestParameter( "ProductoHijoCantidad" ) );
                $s_ProductoHijoIdUnidad = $this->getRequestParameter( "ProductoHijoIdUnidad" );
                $f_ProductoHijoPrecio   = floatval( $this->getRequestParameter( "ProductoHijoPrecio" ) );

                if( !$i_ProductoNuevo )
                {
                    if( !$s_DetalleDescripcion )
                    {
                        throw new Exception( "Debe de ingresar la descripcion del producto." );
                    }
                    if( !$f_ProductoHijoPrecio )
                    {
                        throw new Exception( "Debe de ingresar el precio del producto." );
                    }
                    if( !$f_ProductoHijoCantidad )
                    {
                        throw new Exception( "Debe de ingresar la cantidad del producto." );
                    }

                    //PRODUTO NUEVO
                    $o_TMP_ALM_ItemMastBN = clone $this->o_ALM_ItemMastBN;

                    $s_IdItemHijo    = ALM_ItemMastFN::recuperarId();
                    $s_CodigoInterno = ALM_ItemMastDP::recuperarCodigoInterno();

                    $o_TMP_ALM_ItemMastBN->setIdItem( $s_IdItemHijo );
                    $o_TMP_ALM_ItemMastBN->setCodigoInterno( ( string ) $s_CodigoInterno );
                    $o_TMP_ALM_ItemMastBN->setDescripcionCompleta( $s_DetalleDescripcion );
                    $o_TMP_ALM_ItemMastBN->setUnidadCompra( $s_ProductoHijoIdUnidad ); //unidad
                    $o_TMP_ALM_ItemMastBN->setUnidadVenta( $s_ProductoHijoIdUnidad );  //unidad
                    $o_TMP_ALM_ItemMastBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_TMP_ALM_ItemMastBN->setUsuarioCreacion( myUser::getUser()->getUserId() );

                    $o_ALM_ItemMastDP = new ALM_ItemMastDP( $o_TMP_ALM_ItemMastBN );
                    $o_ALM_ItemMastDP->save();
                }
                else
                {
                    if( !$s_IdItemHijo )
                    {
                        throw new Exception( "Se necesita un producto seleccionado." );
                    }

                    $o_TMP_ALM_ItemMastBN = ALM_ItemMastFN::buscarItemxId( $s_IdItemHijo );
                }

                //$f_UltimoCosto = round( $f_PadrePrecioCosto / $f_ProductoHijoCantidad, 2 );

                ////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //AHORA EL PROCEDIMIENTO DE ESTABLECER EL PRECIO PARA EL PRODUCTO HIJO
                $i_IdRangoSelect  = 1; //POR AHORA ES POR DEFECTO
                $i_IdRangoDetalle = 1;
                $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                $o_MST_ListaPrecioDetalleFN->setIdCompania( 1 );
                $o_MST_ListaPrecioDetalleFN->setIdSucursal( 1 );
                $o_MST_ListaPrecioDetalleFN->setIdItem( $s_IdItemHijo );
                $o_MST_ListaPrecioDetalleFN->setIdTipoLista( 1 ); //POR DEFECTO
                $o_MST_ListaPrecioDetalleFN->setIdRango( $i_IdRangoSelect );
                $o_MST_ListaPrecioDetalleFN->setIdRangoDetalle( $i_IdRangoDetalle );
                $a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select();

                //////////////////////////////////////////////////////////////////////////////////////////
                //SE RECUPERA VALOR DE IGV ACTUAL
                $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
                $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18
                //////////////////////////////////////////////////////////////////////////////////////////

                $f_MontoCostoIGV = round( $f_PadrePrecioCostoIGV / $f_ProductoHijoCantidad, 2 );
                $f_MontoCosto    = round( $f_MontoCostoIGV / $f_ValorIGVMasUno, 2 );
                $f_UltimoCosto   = $f_MontoCosto;

                $f_PrecioVenta    = round( ( $f_ProductoHijoPrecio / $f_ValorIGVMasUno ), 2 );
                $f_PrecioVentaIGV = $f_ProductoHijoPrecio;
                $f_TotalIGV       = round( $f_PrecioVentaIGV - $f_PrecioVenta, 2 );

                $o_DefaultDP = new MST_ListaPrecioDetalleDP();
                $o_DefaultDP->setIdCompania( 1 );
                $o_DefaultDP->setIdSucursal( 1 );
                $o_DefaultDP->setIdListaPreciCab( 1 );
                $o_DefaultDP->setIdItem( $o_TMP_ALM_ItemMastBN->getIdItem() );
                $o_DefaultDP->setIdTipoLista( 1 );
                $o_DefaultDP->setIdRango( $i_IdRangoSelect );
                $o_DefaultDP->setIdRangoDetalle( $i_IdRangoDetalle );
                $o_DefaultDP->setIdTipoPrecio( "1" ); //por defecto
                $o_DefaultDP->setPrecioCosto( $f_MontoCosto );
                $o_DefaultDP->setPrecioCostoIGV( $f_MontoCostoIGV );
                $o_DefaultDP->setPrecioVenta( $f_PrecioVenta );
                $o_DefaultDP->setMontoIGV( $f_TotalIGV );
                $o_DefaultDP->setPrecioVentaIGV( $f_PrecioVentaIGV );
                $o_DefaultDP->setMontoDescuento( 0 );
                $o_DefaultDP->setPorcentajeDescuento( 0 );
                $o_DefaultDP->setDescuentoFlag( "N" );
                $o_DefaultDP->setEstado( "A" );

                if( $a_MST_ListaPrecioDetalle )
                {
                    //update
                    $i_IdDet = $a_MST_ListaPrecioDetalle[0]->getIdListaPreciDet();
                    $o_DefaultDP->setIdListaPreciDet( $i_IdDet );

                    $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_DefaultDP->update();
                }
                else
                {
                    //insert
                    $i_IdDet = MST_ListaPrecioDetalleDP::recuperarId();

                    $o_DefaultDP->setIdListaPreciDet( $i_IdDet );

                    $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_DefaultDP->save();
                }
                ////////////////////////////////////////////////////////////////////////////////////////////////////////////

                ////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //SE CONTINUA CON EL PROCESO, AHORA SE CREA EN LAS TABLAS DE PRODUCCION
                $i_IdOrdenCab = PRD_OrdenCabDP::recuperarId();
                $this->i_IdOrdenCab = $i_IdOrdenCab;

                $s_PrdIdAlmacen = myUser::getUser()->getObjectSucursal()->getIdAlmacen();

                $o_PRD_OrdenCabDP = new PRD_OrdenCabDP();
                $o_PRD_OrdenCabDP->setIdOrdenCab( $i_IdOrdenCab );
                $o_PRD_OrdenCabDP->setIdCompania( myUser::getUser()->getIdCompania() );
                $o_PRD_OrdenCabDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_PRD_OrdenCabDP->setFechaOrden( date( "Y-m-d" ) );
                $o_PRD_OrdenCabDP->setTipoOrden( PRD_OrdenCabBN::TIPO_ORDEN_PROD_NORMAL );
                $o_PRD_OrdenCabDP->setIdAlmacen( $s_PrdIdAlmacen );    //se tiene que elegir, pero por defecto ahora es el almacen de origen | 2021-11-11
                //$o_PRD_OrdenCabDP->setProFinalId( ( int ) $this->s_ProFinalId );
                //$o_PRD_OrdenCabDP->setIdDocRef( ( int ) $this->s_IdDocRef ); //id cotizacion
                //$o_PRD_OrdenCabDP->setDocNumRef(  ); //numero cotizacion
                $o_PRD_OrdenCabDP->setIdAlmacenRef( $s_PrdIdAlmacen ); //almacen de destino
                $o_PRD_OrdenCabDP->setComentario( "AJUSTE ITEM" );
                $o_PRD_OrdenCabDP->setEstado( PRD_OrdenCabBN::ESTADO_RESERVADO ); //P endiente  |  C ompletado  |  A nulado   | R eservado
                $o_PRD_OrdenCabDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_PRD_OrdenCabDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_PRD_OrdenCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_PRD_OrdenCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_PRD_OrdenCabDP->save();

                //PRODUCTO HIJO - RESULTADO, FINAL
                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                $i_IdOrdenDet = PRD_OrdenDetDP::recuperarId();
                $o_PRD_OrdenDetDP = new PRD_OrdenDetDP();
                $o_PRD_OrdenDetDP->setIdOrdenCab( $i_IdOrdenCab );
                $o_PRD_OrdenDetDP->setIdOrdenDet( $i_IdOrdenDet );
                $o_PRD_OrdenDetDP->setIdItem( $s_IdItemHijo );
                $o_PRD_OrdenDetDP->setItemTipo( "PF" );
                $o_PRD_OrdenDetDP->setDescripcionItem( $o_TMP_ALM_ItemMastBN->getDescripcionCompleta() );
                $o_PRD_OrdenDetDP->setIdUnidad( ( int ) $o_TMP_ALM_ItemMastBN->getUnidadCompra() );
                $o_PRD_OrdenDetDP->setCantidadPedida( $f_ProductoHijoCantidad );
                $o_PRD_OrdenDetDP->setCantidadRecibida( 0 );
                $o_PRD_OrdenDetDP->setPrecioCostoUnit( $f_UltimoCosto );
                $o_PRD_OrdenDetDP->setPrecioCostoTotal( round( $f_ProductoHijoCantidad * $f_UltimoCosto, 2 ) );
                $o_PRD_OrdenDetDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_PRD_OrdenDetDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_PRD_OrdenDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_PRD_OrdenDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_PRD_OrdenDetDP->save();
                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                //PRODUCTO PADRE, MATERIALES
                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //$f_UltimoCosto = $f_PadrePrecioCosto;
                $i_IdOrdenDet = PRD_OrdenDetDP::recuperarId();
                $o_PRD_OrdenDetDP = new PRD_OrdenDetDP();
                $o_PRD_OrdenDetDP->setIdOrdenCab( $i_IdOrdenCab );
                $o_PRD_OrdenDetDP->setIdOrdenDet( $i_IdOrdenDet );
                $o_PRD_OrdenDetDP->setIdItem( $this->o_ALM_ItemMastBN->getIdItem() );
                $o_PRD_OrdenDetDP->setItemTipo( "PR" );
                $o_PRD_OrdenDetDP->setDescripcionItem( $this->o_ALM_ItemMastBN->getDescripcionCompleta() );
                $o_PRD_OrdenDetDP->setIdUnidad( ( int ) $this->o_ALM_ItemMastBN->getUnidadCompra() );
                $o_PRD_OrdenDetDP->setCantidadPedida( $f_ProductoPadreCantidad );
                $o_PRD_OrdenDetDP->setCantidadRecibida( 0 );
                $o_PRD_OrdenDetDP->setPrecioCostoUnit( $f_PadrePrecioCosto );
                $o_PRD_OrdenDetDP->setPrecioCostoTotal( round( $f_ProductoPadreCantidad * $f_PadrePrecioCosto, 2 ) );
                $o_PRD_OrdenDetDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_PRD_OrdenDetDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_PRD_OrdenDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_PRD_OrdenDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_PRD_OrdenDetDP->save();
                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                //AHORA EJECUTAMOS EL PROCESO PARA REALIZAR EL AJUSTE DE INVENTARIO

                ParameterWR::getInstance()->setVar( "TipoProc", "CerrarOrdenPrd" );
                ParameterWR::getInstance()->setVar( "IdOrdenCab", ( string ) $i_IdOrdenCab );

                ob_start();
                $o_RequestPrdOrdenAction = new RequestPrdOrdenAction();
                $o_RequestPrdOrdenAction->execute();
                $s_Json = ob_get_contents();
                ob_end_clean();

                $a_Json = json_decode( $s_Json, true );
                if( $a_Json['error'] )
                {
                    throw new Exception( $a_Json['mensaje_error'] );
                }

                $con->commit();
            }
            catch( Exception $o_Exception )
            {
                $con->rollback();
                $this->s_Mensaje = $o_Exception->getMessage();
                //pr( $o_Exception->getMessage() );
            }
        }

        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastFN->setIdMarca( $o_ALM_ItemMastBN->getIdMarca() );
        //$o_ALM_ItemMastFN->setIdLinea( $o_ALM_ItemMastBN->getIdLinea() );
        //$o_ALM_ItemMastFN->setIdFamilia( $o_ALM_ItemMastBN->getIdFamilia() );
        $o_ALM_ItemMastFN->addCondition( ALM_ItemMastFN::UnidadVenta, "IN", "( ".implode( ",", $a_IdUniEq )." )", false );
        $o_ALM_ItemMastFN->addOrderBy( ALM_ItemMastFN::DescripcionCompleta );
        $a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
        $this->a_ALM_ItemMast = $a_ALM_ItemMast;
    }
}