<?php
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
class ImportPrdMasivoAction extends wtActions
{
    public function execute()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->b_Control      = $this->getRequestParameter( "Control" );
        $this->s_MensajeError = "";
        $this->s_Mensaje      = "";
        $this->a_DataError    = array();

        if( $this->b_Control )
        {
            $con = Conexion::getConexion();
            $con->begin();
            try
            {
                myUser::getUser()->validar_session();

                //pr( $_FILES );

                //$s_NombreCompleto = $_FILES['customFile']['name'];
                $s_TipoCompleto   = $_FILES['customFile']['type'];
                //$i_TamanioFile    = intval( $_FILES['customFile']['size'] );
                $fileTmpPath      = $_FILES['customFile']['tmp_name'];

                $phpFileUploadErrors = array
                (
                    0 => 'There is no error, the file uploaded with success',
                    1 => 'El fichero subido excede la directiva upload_max_filesize de php.ini.',
                    2 => 'El fichero subido excede la directiva MAX_FILE_SIZE especificada en el formulario HTML.',
                    3 => 'El fichero fue sólo parcialmente subido.',
                    4 => 'No se subió ningún fichero.',
                    6 => 'Falta la carpeta temporal.',
                    7 => 'No se pudo escribir el fichero en el disco.',
                    8 => 'Una extensión de PHP detuvo la subida de ficheros. PHP no proporciona una forma de determinar la extensión que causó la parada de la subida de ficheros; el examen de la lista de extensiones cargadas con phpinfo() puede ayudar.',
                    9 => 'Solo se permite archivos Excel.'
                );

                if( !$_FILES['customFile']['error'] )
                {
                    if( $s_TipoCompleto != "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" )
                    {
                        $_FILES['customFile']['error'] = 9;
                    }
                }

                if ( $_FILES['customFile']['error'] )
                {
                    throw new Exception( $phpFileUploadErrors[$_FILES['customFile']['error']] );
                }

                require_once( SF_ROOT_DIR.DIRECTORY_SEPARATOR.'plugins'.DIRECTORY_SEPARATOR.'vendor_excel'.DIRECTORY_SEPARATOR.'autoload.php' );

                # Create a new Xls Reader
                $reader = new Xlsx();

                // Tell the reader to only read the data. Ignore formatting etc.
                $reader->setReadDataOnly( true );

                // Read the spreadsheet file.
                $spreadsheet = $reader->load( $fileTmpPath );

                $sheet      = $spreadsheet->getSheet( $spreadsheet->getFirstSheetIndex() );
                $highestRow = $sheet->getHighestRow();

                $control_lote = null;
                $precio_prod2 = null;
                $precio_prod3 = null;
                $a_DataItem   = array();

                $i     = 1;
                $i_Ini = 2;
                for( $row = $i_Ini; $row <= $highestRow; $row++ )
                {
                    if( trim( $sheet->getCell( "E".$row )->getValue() ) )
                    {
                        $s_IdItemCustom   = ( utilString::eliminar_espacios( $sheet->getCell( "A".$row )->getValue() ) ); //strtoupper
                        $s_CodigoInterno  = ( utilString::eliminar_espacios( $sheet->getCell( "B".$row )->getValue() ) ); //strtoupper
                        $s_CodigoInterno2 = ( utilString::eliminar_espacios( $sheet->getCell( "C".$row )->getValue() ) ); //strtoupper
                        $s_CodigoInterno3 = ( utilString::eliminar_espacios( $sheet->getCell( "D".$row )->getValue() ) ); //strtoupper
                        $s_ProductoDesc   = ( trim( $sheet->getCell( "E".$row )->getValue() ) ); //strtoupper
                        $s_UnidadVenta    = utilString::eliminar_espacios( $sheet->getCell( "F".$row )->getValue() ); //strtoupper
                        $s_UnidadCompra   = $s_UnidadVenta;
                        //$tipo_igv         = utilString::eliminar_espacios( $sheet->getCell( "G".$row )->getValue() );
                        $s_MarcaDesc      = ( trim( $sheet->getCell( "G".$row )->getValue() ) ); //strtoupper
                        $s_LineaDesc      = ( trim( $sheet->getCell( "H".$row )->getValue() ) ); //strtoupper
                        $s_FamiliaDesc    = ( trim( $sheet->getCell( "I".$row )->getValue() ) ); //strtoupper
                        $s_SubFamiliaDesc = ( trim( $sheet->getCell( "J".$row )->getValue() ) ); //strtoupper
                        $s_PartNumber     = utilString::eliminar_espacios( $sheet->getCell( "K".$row )->getValue() );
                        $s_SunatCodigo    = utilString::eliminar_espacios( $sheet->getCell( "L".$row )->getValue() );
                        $s_CodigoBarras   = utilString::eliminar_espacios( $sheet->getCell( "M".$row )->getValue() );
                        $f_ProductoPeso   = floatval( utilString::eliminar_espacios( $sheet->getCell( "N".$row )->getValue() ) );
                        $f_CostoProd      = round( floatval( utilString::eliminar_espacios( $sheet->getCell( "O".$row )->getValue() ) ), 2 );      //SE ASUME QUE EL COSTO ESTA INCLUIDO EL IGV
                        $f_PrecioProd     = round( floatval( utilString::eliminar_espacios( $sheet->getCell( "P".$row )->getValue() ) ), 2 );      //SE ASUME QUE EL PRECIO ESTA INCLUIDO EL IGV
                        //$precio_prod2   = round( floatval( trim( $sheet->getCell( "U".$row )->getValue() ) ), 2 );      //SE ASUME QUE EL PRECIO ESTA INCLUIDO EL IGV
                        //$precio_prod3   = round( floatval( trim( $sheet->getCell( "V".$row )->getValue() ) ), 2 );      //SE ASUME QUE EL PRECIO ESTA INCLUIDO EL IGV
                        //$control_lote   = intval( trim( $sheet->getCell( "O".$row )->getValue() ) );
                        //$compania_cod     = utilString::eliminar_espacios( $sheet->getCell( "R".$row )->getValue() );

                        //SE PREGUNTA SI YA EXISTE EL PRODUCTO
                        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                        $s_CodigoExiste   = "NO";
                        $o_ALM_ItemMastBN = new ALM_ItemMastBN();
                        if( empty( $s_IdItemCustom ) )
                        {
                            if( $s_CodigoInterno != "" )
                            {
                                $o_ALM_ItemMastFN->setCodigoInterno( $s_CodigoInterno );
                                $a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
                                if( count( $a_ALM_ItemMast ) == 1 )
                                {
                                    $s_CodigoExiste   = "SI";
                                    $o_ALM_ItemMastBN = $a_ALM_ItemMast[0];
                                }
                            }
                            if( $s_CodigoInterno2 != "" )
                            {
                                $o_ALM_ItemMastFN->setCodigoInterno2( $s_CodigoInterno2 );
                                $a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
                                if( count( $a_ALM_ItemMast ) == 1 )
                                {
                                    $s_CodigoExiste   = "SI";
                                    $o_ALM_ItemMastBN = $a_ALM_ItemMast[0];
                                }
                            }
                            if( $s_CodigoInterno3 != "" )
                            {
                                $o_ALM_ItemMastFN->setCodigoBarras2( $s_CodigoInterno3 );
                                $a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
                                if( count( $a_ALM_ItemMast ) == 1 )
                                {
                                    $s_CodigoExiste   = "SI";
                                    $o_ALM_ItemMastBN = $a_ALM_ItemMast[0];
                                }
                            }
                        }
                        else
                        {
                            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_IdItemCustom );
                            if( !$o_ALM_ItemMastBN )
                            {
                                throw new Exception( "El Id del Producto [$s_IdItemCustom] no se encuentra registrado." );
                            }
                            $s_CodigoExiste = "SI";
                        }
                        //$a_Contenido[$i_Key]['IDITEM'] = $o_ALM_ItemMastBN->getIdItem();
                        //$a_Contenido[$i_Key]['EXISTE'] = $s_CodigoExiste;
                        //$a_Contenido[$i_Key]['ALM_ItemMastBN'] = $o_ALM_ItemMastBN;

                        if( $s_CodigoExiste == "SI" )
                        {
                            //$o_ALM_ItemMastBN = $o_ALM_ItemMastBN;
                            $o_ALM_ItemMastBN->setDescripcionCompleta( $s_ProductoDesc );
                            $o_ALM_ItemMastBN->setMarcaDescripcion( $s_MarcaDesc );
                            $o_ALM_ItemMastBN->setLineaDescripcion( $s_LineaDesc );
                            $o_ALM_ItemMastBN->setFamiliaDescripcion( $s_FamiliaDesc );
                            $o_ALM_ItemMastBN->setSubFamiliaDescripcion( $s_SubFamiliaDesc );
                            $o_ALM_ItemMastBN->setNumeroDeParte( $s_PartNumber );
                            $o_ALM_ItemMastBN->setCodigoSunat( $s_SunatCodigo );
                            $o_ALM_ItemMastBN->setCodigoBarrasFabricante( $s_CodigoBarras );
                            $o_ALM_ItemMastBN->setPesoGramos( $f_ProductoPeso );
                            $o_ALM_ItemMastBN->setPrecioCosto( $f_CostoProd );
                            $o_ALM_ItemMastBN->setPrecioVenta1( $f_PrecioProd );
                            $o_ALM_ItemMastBN->setControlPrecios( true );
                        }
                        else
                        {
                            $o_ALM_ItemMastBN = new ALM_ItemMastBN();
                            $o_ALM_ItemMastBN->setCodigoInterno( $s_CodigoInterno );
                            $o_ALM_ItemMastBN->setCodigoInterno2( $s_CodigoInterno2 );
                            $o_ALM_ItemMastBN->setCodigoBarras2( $s_CodigoInterno3 );
                            $o_ALM_ItemMastBN->setDescripcionCompleta( $s_ProductoDesc );
                            $o_ALM_ItemMastBN->setNumeroDeParte( $s_PartNumber );
                            $o_ALM_ItemMastBN->setIdItemTipo( "01" ); //MERCADERIA
                            $o_ALM_ItemMastBN->setMarcaDescripcion( $s_MarcaDesc );
                            $o_ALM_ItemMastBN->setLineaDescripcion( $s_LineaDesc );
                            $o_ALM_ItemMastBN->setFamiliaDescripcion( $s_FamiliaDesc );
                            $o_ALM_ItemMastBN->setSubFamiliaDescripcion( $s_SubFamiliaDesc );
                            $o_ALM_ItemMastBN->setUnidadMedidaVentaDesc( $s_UnidadVenta );
                            $o_ALM_ItemMastBN->setCodigoSunat( $s_SunatCodigo );
                            $o_ALM_ItemMastBN->setManejoxLoteFlag( "N" );
                            $o_ALM_ItemMastBN->setManejoxSerieFlag( "N" );
                            $o_ALM_ItemMastBN->setNoAfectoImpuestoVentasFlag( "N" );
                            $o_ALM_ItemMastBN->setEstado( "A" );
                            $o_ALM_ItemMastBN->setIdProcedencia( "LOC" );
                            $o_ALM_ItemMastBN->setTipoGarantiaId( "18" );
                            $o_ALM_ItemMastBN->setIdTipoOperatividad( "NVO" );
                            $o_ALM_ItemMastBN->setPesoGramos( $f_ProductoPeso );
                            $o_ALM_ItemMastBN->setAfectoPercepcionIGVFlag( "N" );
                            $o_ALM_ItemMastBN->setAfectoDetraccionFlag( "NO" );
                            $o_ALM_ItemMastBN->setIdDetraccion( 0 );
                            $o_ALM_ItemMastBN->setIdPersona( 0 );
                            $o_ALM_ItemMastBN->setDescripcionLarga( "" );
                            $o_ALM_ItemMastBN->setEsInventariableFlag( "S" );
                            $o_ALM_ItemMastBN->setFusionarLoteFlag( "N" );
                            $o_ALM_ItemMastBN->setUsarDisponibleStock( "S" );
                            $o_ALM_ItemMastBN->setUsarResevableStock( "S" );
                            $o_ALM_ItemMastBN->setCodigoBarrasFabricante( $s_CodigoBarras );
                            //POR DEFECTO SE LE ENVIA AL RANGO 1 DE PRECIO DE VENTAS
                            $o_ALM_ItemMastBN->setEsParaVenta( "SI" );
                            $o_ALM_ItemMastBN->setIdRangoVenta( 1 );         //DESCRIBE QUE RANGO PERTENECE EN LA LISTA DE PRECIOS
                            $o_ALM_ItemMastBN->setPrecioCosto( $f_CostoProd );            //ESTA INCLUIDO IGV
                            $o_ALM_ItemMastBN->setPrecioVenta1( $f_PrecioProd );
                            //$o_ALM_ItemMastBN->setPrecioVenta2( $precio_prod2 );
                            //$o_ALM_ItemMastBN->setPrecioVenta3( $precio_prod3 );
                            $o_ALM_ItemMastBN->setControlPrecios( true );
                            $o_ALM_ItemMastBN->setEsParaAlquiler( "NO" );
                            $o_ALM_ItemMastBN->setIdRangoAlquiler( 0 );
                        }

                        $a_DataItem[] = $o_ALM_ItemMastBN;
                    }
                }

                $o_InventarioBL = new InventarioBL();
                $o_InventarioBL->importarProductosDesdeWS( $a_DataItem );

                if( !$this->a_DataError )
                {
                    $this->s_Mensaje = "Se registro el listado de Precios satisfactoriamente.";
                }

                $con->commit();
            }
            catch ( Exception $o_Exception )
            {
                //pr( $o_Exception );
                $con->rollback();
                $this->a_DataError[] = $o_Exception->getMessage();
            }
        }
    }
}