<?php
class carteraActions extends wtActions
{
    public function executeIndex()
    {
    }

    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo   = "Listado Cartera";
    }

    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );

        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_CarteraFN() );

        //$o_GridAction->addAssignFilter( "IdCompania" );
        //$o_GridAction->addAssignFilter( "IdProveedor" );
        $o_GridAction->addAssignFilter( "Estado" );
        //$o_GridAction->addConditionFilter( "Codigo", MST_ColorFN::Codigo, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "Nombre", MST_CarteraFN::Nombre, "LIKE", "%%s%" );

        $o_GridAction->addOrderDefault( MST_CarteraFN::IdCartera, true );

        $o_GridAction->addRowsToShow( "IdCartera", "Nombre", "FlagRango", "Estado", "EstadoDesc" );

        $o_GridAction->setNumberRecordsShow( 100 );

        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }

    public function executeAdd()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo   = "Nuevo Cartera";
        $this->s_TipoProc = "nvo";
    }

    public function executeEdit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo = "Editar Cartera";
        $this->i_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = "edit";

        $o_DefaultFN = new MST_CarteraFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        if( !$this->o_DefaultBN )
        {
            $this->o_DefaultBN = new MST_CarteraBN();
        }
    }

    public function executeSaveAddEdit()
    {
        $s_TipoProc    = $this->getRequestParameter( 'tipoProc' );

        $s_Descripcion = $this->getRequestParameter( 'Nombre' );
        $s_FlagRango   = $this->getRequestParameter( 'FlagRango' );
        $s_Estado      = $this->getRequestParameter( 'Estado' );

        $i_IdCompania  = intval( myUser::getUser()->getIdCompania() );
        $i_IdSucursal  = intval( myUser::getUser()->getIdSucursal() );

        try
        {
            $o_DefaultDP = new MST_CarteraDP();

            $o_DefaultDP->setNombre( $s_Descripcion );
            $o_DefaultDP->setFlagRango( intval( $s_FlagRango ) );
            $o_DefaultDP->setEstado( $s_Estado );

            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $i_Id = MST_CarteraDP::recuperarId();
                $o_DefaultDP->setIdCartera( $i_Id );
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->save();
            }
            else
            {
                //UPDATE
                $i_Id = intval( $this->getRequestParameter( 'id' ) );
                $o_DefaultDP->setIdCartera( $i_Id );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->update();
            }

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }

    public function executeView()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo   = "Mostrar Cartera";
        $this->i_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = $this->getRequestParameter( 'tipoProc' );

        $o_DefaultFN = new MST_CarteraFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        if( !$this->o_DefaultBN )
        {
            $this->o_DefaultBN = new MST_CarteraBN();
        }
    }
}