<?php
class userActions extends wtActions
{
    //REFERENCIAS
    //https://www.w3schools.com/bootstrap4/default.asp  --> Manual de Bootstrap
    //https://bootsnipp.com/snippets/vl4R7
    //https://getbootstrap.com/docs/3.4/examples/navbar-fixed-top/
    //https://colorlib.com/polygon/kiaalap/edit-library-assets.html#
    
    public function executeRequest()
    {
        $s_TipoRequest = $this->getRequestParameter( 'tiporeq' );
        $a_lst = array( "Result" => false );

        try
        {
            switch ( $s_TipoRequest )
            {
                case "LoadSucursal":
                    //MOSTRAR COMPANIAS
                    $s_IdCompania = $this->getRequestParameter( 'IdCompania' );
                    
                    $o_GSS_SucursalFN = new GSS_SucursalFN();
                    $o_GSS_SucursalFN->setIdCompania( $s_IdCompania );
                    $a_Result  = $o_GSS_SucursalFN->select();
                    $s_NameId  = "getIdSucursal";
                    $s_NameDes = "getDescripcion";
                    $a_lst = array();
                    foreach ( $a_Result as $i_Key => $o_ObjectBN )
                    {
                        $a_lst[$o_ObjectBN->$s_NameId()] = $o_ObjectBN->$s_NameDes();
                    }
                    ////////////////////////////////////////////////////////////////
                break;
                case "validar_session":
                    //pr( myUser::getUser()->validar_session() );
                    $o_SEG_UsuarioSesionBN = myUser::getUser()->validar_session();
                    //pr( $o_SEG_UsuarioSesionBN );
                    if( $o_SEG_UsuarioSesionBN )
                    {
                        $a_lst['IdUsuario'] = $o_SEG_UsuarioSesionBN->getIdUsuario();
                        $a_lst['IdRol'] = $o_SEG_UsuarioSesionBN->getIdRol();
                    }
                    else
                    {
                        throw new Exception( "Por favor, es necesario iniciar Sesion." );
                    }
                break;
                case "re_ingresar_session":

                    $i_Metodo = intval( $this->getRequestParameter( 'metodo' ) );
                    if( $i_Metodo )
                    {
                        $o_SEG_UsuarioFN = new SEG_UsuarioFN();
                        $o_SEG_UsuarioBN = $o_SEG_UsuarioFN->selectByPK( $_REQUEST['nickname'] );
                        $_REQUEST['password'] = $o_SEG_UsuarioBN->getUsuarioContrasenia();
                        
                        //se cambio el procedimiento, ahora se guarda la sesion en una tabla, y se fija por la ip - 2020-02-10
                        
                        /*$o_SEG_UsuarioSesionBN = SEG_UsuarioSesionFN::buscarPorIP( myUser::getUser()->getRoleId() );
                        if( $o_SEG_UsuarioSesionBN )
                        {
                            $_REQUEST['nickname'] = $o_SEG_UsuarioSesionBN->getIdUsuario();
                            $_REQUEST['password'] = $o_SEG_UsuarioSesionBN->getUsuarioContrasenia();
                        }*/
                        
                    }

                    $o_MyLoginValidator = new myLoginValidator();
                    $preLogin = $o_MyLoginValidator->execute ( $_REQUEST['nickname'], $_REQUEST['password'] );
                    if ( $preLogin === true )
                    {
                        //se logueo exitosamente
                        //pero si viene los parametros de compania y sucursal, se registra en la credenciales
                        if( isset( $_REQUEST['IdCompania'] ) )
                        {
                            $o_businessAdapter = new businessAdapter();
                            $o_businessAdapter->setIdUsuario( $_REQUEST['nickname'] );
                            $o_businessAdapter->setContrasenia( $_REQUEST['password'] );
                            $o_businessAdapter->setIdCompania( $_REQUEST['IdCompania'] );
                            if( isset( $_REQUEST['IdSucursal'] ) )
                            {
                                $o_businessAdapter->setIdSucursal( $_REQUEST['IdSucursal'] );
                            }
                            $o_businessAdapter->signInWithBusiness();
                        }
                    }
                    elseif ( $preLogin == "1" )
                    {
                        //el id del usuario no existe
                        throw new Exception( "El Id de Usuario no se encuentra registrado." );
                    }
                    elseif ( $preLogin == "2" )
                    {
                        //la contraseña esta errada
                        throw new Exception( "La Contrase&ntilde;a esta errada." );
                    }

                break;
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_lst['error']         = true;
            $a_lst['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }

    public function executeFindMenu()
    {
        $taskId = $this->getRequestParameter( 'taskId' );

        $ob_sfUser    = myUser::getUser();
        //ob_start();
        $ob_SubMenu = new menu_class;
        $ob_SubMenu->getInit( $ob_sfUser->getRoleId() );
        $menu_2nd = $ob_SubMenu->getMenu( $taskId );
        //ob_end_clean();
        foreach ( $menu_2nd as $key => $val )
        {
            $menu_3nd = $ob_SubMenu->getMenu( $val['TaskId'] );

            if( sizeof( $menu_3nd ) > 0)
            {
                foreach ( $menu_3nd as $key1 => $val2 )
                {
                    //if( !$val2['MenuEstado'] ){ continue; }
                    $pila            = $ob_SubMenu->getTask( $val2['TaskId'] );
                    $pila            = array( 'tasks'=>$pila );
                    $menu_3nd[$key1] = array_merge( $menu_3nd[$key1], $pila );
                }
                $pila = array( 'submenu' => $menu_3nd );
                $menu_2nd[$key] = array_merge( $menu_2nd[$key], $pila );
            }
            else
            {
                $pila = array( 'submenu' => array() );
                $menu_2nd[$key] = array_merge( $menu_2nd[$key], $pila );
            }
        }

        $this->menu_2nd = $menu_2nd;

        //return ViewResponse::NONE;
        ViewResponse::getInstance()->setMethodAjax();
    }

    public function executeFindCompany()
    {
        $s_Nickname = $this->getRequestParameter( 'nickname' );

        $this->a_Compania            = array();
        $this->a_SEG_SucursalUsuario = array();

        try
        {
            if( empty( $s_Nickname ) || !preg_match( '/^[a-zA-ZáéíóúÁÉÍÓÚñÑ0-9]+$/', $s_Nickname ) ) //permite letras, numeros, y acentos
            {
                throw new Exception( "Error en el campo del Usuario, es permitido caracteres Alfanumericos." );
            }

            $this->a_Compania = SEG_UsuarioFN::buscarEmpresaporUsuarioId( $s_Nickname );
            $i_IdCompaniaRef  = null;
            if( $this->a_Compania )
            {
                $i_IdCompaniaRef = $this->a_Compania[0]->getIdCompania();
            }

            if( $i_IdCompaniaRef )
            {
                $o_SEG_SucursalUsuarioFN = new SEG_SucursalUsuarioFN();
                $o_SEG_SucursalUsuarioFN->setIdUsuario( $s_Nickname );
                $o_SEG_SucursalUsuarioFN->setIdCompania( $i_IdCompaniaRef );
                $this->a_SEG_SucursalUsuario = $o_SEG_SucursalUsuarioFN->select();
                if( !$this->a_SEG_SucursalUsuario )
                {
                    $this->a_SEG_SucursalUsuario = array();
                }
            }
        }
        catch( Exception $o_Exception )
        {
            echo "<strong>Advertencia!</strong> ".$o_Exception->getMessage();
        }

        ViewResponse::getInstance()->setMethodAjax();
    }

    public function executeLogin()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        if ( myUser::getUser()->isAuthenticated() )
        {
            LayoutTemplate::getInstance()->setIsLoginAccess();
        }

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( 1 );

        $this->message_error = "";

        try
        {
            if( $this->getRequestParameter( 'Control' ) )
            {
                $o_MyLoginValidator = new myLoginValidator();
                $preLogin           = $o_MyLoginValidator->execute( $_POST['nickname'], $_POST['password'] );

                if( $preLogin === true )
                {
                    //se logueo exitosamente
                    //pero si viene los parametros de compania y sucursal, se registra en la credenciales
                    if( isset( $_POST['IdCompania'] ) )
                    {

                        ob_start();
                        $o_businessAdapter = new businessAdapter();
                        $o_businessAdapter->setIdUsuario( $_POST ['nickname'] );
                        $o_businessAdapter->setContrasenia( $_POST ['password'] );
                        $o_businessAdapter->setIdCompania( $_POST['IdCompania'] );
                        if( isset( $_POST['IdSucursal'] ) )
                        {
                            $o_businessAdapter->setIdSucursal( $_POST['IdSucursal'] );
                        }
                        //borramos sesiones anteriores
                        SEG_UsuarioSesionDP::borrarSesion( $o_businessAdapter->getIdRol() );
                        //////////////////////////////////////////////
                        $o_businessAdapter->signInWithBusiness();
                        ob_end_clean();

                        //redirect
                        $s_Dir = Constantes::ROOT_DIR_APP;
                        header( "Location:{$s_Dir}" );
                    }
                }
                elseif( $preLogin == "1" )
                {
                    //el id del usuario no existe
                    $this->message_error = "<strong>Advertencia!</strong> El Id de Usuario no se encuentra registrado.";
                }
                elseif( $preLogin == "2" )
                {
                    //la contraseña esta errada
                    $this->message_error = "<strong>Advertencia!</strong> La Contrase&ntilde;a esta errada.";
                }
                elseif( $preLogin == "3" )
                {
                    //la contraseña esta errada
                    $this->message_error = "<strong>Advertencia!</strong> El Usuario se encuentra bloqueado.";
                }
            }
        }
        catch( Exception $o_Exception )
        {
            $this->message_error = "<strong>Advertencia!</strong> ".$o_Exception->getMessage();
        }
    }

    public function executeLogout()
    {
        myUser::getUser()->signOut();
        $s_Dir = Constantes::ROOT_DIR_APP;
        header( "Location:{$s_Dir}" );
    }

    public function executeCustom()
    {
        
    }

    public function executeSummary()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        LayoutTemplate::getInstance()->setUseChartJS();

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //recuperamos el array de los vendedores 
        //Primer y Segundo Grafico
        $s_PeriodoActual   = date( "Ym" );
        $s_PeriodoAnterior = date( "Y" ).str_pad( ( intval( date( "m" ) ) - 1 ), 2, "0", STR_PAD_LEFT);
        

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Se recupera data para top ventas por familia
        //frafico 3
        $f_Midcro1 = microtime( true );
        $a_DataFamilia = VTA_DocumentoFN::getArrayVentasPorItem( $s_PeriodoActual );

        $a_DataSoles = array();
        $a_DataLabel = array();
        $f_MontoTota = 0.00;
        $i = 1;
        foreach ( $a_DataFamilia as $i_Key => $a_Value ) 
        {
            if( $i > 6 )
            {
                // solo se permite 5 vendedores para el reporte
                break;
            }
            $a_DataSoles[] = $a_Value['MontoTotal'];
            $a_DataLabel[] = $a_Value['Descripcion'].": S/ ".number_format( $a_Value['MontoTotal'], 2 );
            $f_MontoTota = $f_MontoTota + floatval( $a_Value['MontoTotal'] );

            $i++;
        }

        $this->s_DataSoles = implode( ",", $a_DataSoles );
        $this->s_DataLabel = "'".implode( "','", $a_DataLabel )."'";
        $this->f_MontoTota = $f_MontoTota;

        $f_Midcro2 = microtime( true );
        if( SF_DEBUG ){ pr( "[".( round( $f_Midcro2 - $f_Midcro1, 2 ) )."] executeSummary | getArrayVentasPorFamilia" ); }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Operaciones por mes barras canvas9
        $f_Midcro1 = microtime( true );
		
		//echo date( "Y-m" );
		//echo " ---- ";
		//echo date("Y-m", strtotime('-5 months'));
        //$this->s_PeriodoDesde = !$this->getRequestParameter( 'PeriodoDesde' ) ? date( "Y-m" ) : $this->getRequestParameter( 'PeriodoDesde' );
        $this->s_PeriodoDesde = !$this->getRequestParameter( 'PeriodoDesde' ) ? date("Y-m", strtotime('-5 months')) : $this->getRequestParameter( 'PeriodoDesde' );
        $this->s_PeriodoHasta = !$this->getRequestParameter( 'PeriodoHasta' ) ? date( "Y-m" ) : $this->getRequestParameter( 'PeriodoHasta' );
        /*echo "Fecha_Desde:";
		echo "<br>";
		echo $this->s_PeriodoDesde;
		echo "<br>";
		echo "Fecha_Hasta";
		echo "<br>";
		echo $this->s_PeriodoHasta;*/
        $a_Parametros9 = array( "PeriodoIni" =>  str_replace( "-", "", $this->s_PeriodoDesde ), "PeriodoFin" => str_replace( "-", "", $this->s_PeriodoHasta ) );
        
        $a_DataMeses = VTA_DocumentoFN::getArrayVentasPorMes( $a_Parametros9 );
        //pr( $a_DataMeses );
        $a_DataMes    = array();
        $a_DataMontos = array();
        $a_DataLabels = array();
        foreach ( $a_DataMeses as $i_Key => $a_Value ) 
        {
            $a_DataMes[]    = strtoupper( Constantes::$a_meses[$a_Value['Mes']] );
            $a_DataMontos[] = $a_Value['MontoTotal'];
            $a_DataLabels[] = Constantes::$a_meses[$a_Value['Mes']].": S/ ".number_format( $a_Value['MontoTotal'], 2 );
        }
        //if( $a_Value['MonedaDocumento'] == "EX" ){ $a_DataMontos[] = $a_Value['MontoTotal'] * $a_Value['TipodeCambio']; }else { $a_DataMontos[] = $a_Value['MontoTotal']; }
        //pr( $a_DataMes );
        //pr( $a_DataMontos );
		$this->i_cantMes = count($a_DataMes);
        $this->s_DataMes    = "'".implode( "','", $a_DataMes )."'";
        $this->s_DataMontos = implode( ",", $a_DataMontos );
        $this->s_DataLabels = "'".implode( "','", $a_DataLabels )."'";

        $f_Midcro2 = microtime( true );
        if( SF_DEBUG ){ pr( "[".( round( $f_Midcro2 - $f_Midcro1, 2 ) )."] executeSummary | getArrayVentasPorMes" ); }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Operaciones por dia barras canvas10   
        $f_Midcro1 = microtime( true );

        $this->i_FechaOperacion1 = !$this->getRequestParameter( 'FechaOperacion1' ) ? date( "Y-m-d", strtotime('-7 days') ) : $this->getRequestParameter( 'FechaOperacion1' );
        $this->i_FechaOperacion2 = !$this->getRequestParameter( 'FechaOperacion2' ) ? date( "Y-m-d" ) : $this->getRequestParameter( 'FechaOperacion2' );
        
        $a_Parametros10 = array( "PeriodoIni" => $this->i_FechaOperacion1 , "PeriodoFin" => $this->i_FechaOperacion2 );
        
		//echo "Prueba 0";
        //pr ($a_Parametros10);
        
        $a_DataDias = VTA_DocumentoFN::getArrayVentasPorDia( $a_Parametros10 );
        //echo "Prueba 1";
		//pr($a_DataDias);
        $a_DataFecha    = array();
        $a_DataMontoDia = array();
        $a_DataLabels10 = array();
        
        foreach ( $a_DataDias as $i_Key => $a_Value )
        {
            $a_DataFecha[]  = $a_Value['FechaDoc'];
            $a_DataMontoDia[] = $a_Value['MontoTotal'];
            $a_DataLabels10[] = $a_Value['FechaDoc'] .": S/ ".number_format( $a_Value['MontoTotal'], 2 );
        }
		//echo "Prueba 2";
		//pr($a_DataFecha);
        $this->s_DataFecha    = "'".implode( "','", $a_DataFecha )."'";
		//echo "Prueba 3";
		//pr($this->s_DataFecha);
        $this->s_DataMontoDia = implode( ",", $a_DataMontoDia );
		//echo "Prueba 4";
		//pr($this->s_DataMontoDia);

        $f_Midcro2 = microtime( true );
        if( SF_DEBUG ){ pr( "[".( round( $f_Midcro2 - $f_Midcro1, 2 ) )."] executeSummary | getArrayVentasPorDia" ); }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //recuperamos el array de los vendedores 
        //Primer y Segundo Grafico
        $s_PeriodoActual   = date( "Ym" );
        $s_PeriodoAnterior = date( "Y" ).str_pad( ( intval( date( "m" ) ) - 1 ), 2, "0", STR_PAD_LEFT);
        
        $this->a_DataVendedor = VTA_DocumentoFN::getArrayTopVendedoresPorDosPeriodos( $s_PeriodoActual, $s_PeriodoAnterior );
        
        $a_Usuario          = array();
        $a_PeriodoActual    = array();
        $a_PeriodoAnterior  = array();
        $i = 1;
        foreach ( $this->a_DataVendedor as $s_Key => $a_Value ) 
        {
            if( $i > 5 )
            {
                // solo se permite 5 vendedores para el reporte
                break;
            }
            $a_Usuario[]         = $s_Key;
            $a_PeriodoActual[]   = $a_Value['PeriodoUno'];
            $a_PeriodoAnterior[] = $a_Value['PeriodoDos'];
            
            $i++;
        }
        $this->s_Vendedores      = "'".implode( "','", $a_Usuario )."'";
        $this->s_PeriodoActual   = implode( ",", $a_PeriodoActual );
        $this->s_PeriodoAnterior = implode( ",", $a_PeriodoAnterior );
		//pr($this->s_PeriodoActual);
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////

        
        //Ventas del Mes
        $f_Midcro1 = microtime( true );

        $this->s_Anio    = date( "Y" );
        $this->s_Periodo = date( "m" );
        if( $this->getRequestParameter( "Control" ) )
        {
            $this->s_Anio    = $this->getRequestParameter( "Anio" );
            $this->s_Periodo = $this->getRequestParameter( "Periodo" );
        }

        //$DataVentasMes = VTA_DocumentoFN::getVentasdeMes();
        $s_ConcatPeriodo = $this->s_Anio.$this->s_Periodo;
        $this->a_VentasTotales = VTA_DocumentoFN::getDataIngresosNetos( $s_ConcatPeriodo );

        $f_Midcro2 = microtime( true );
        if( SF_DEBUG ){ pr( "[".( round( $f_Midcro2 - $f_Midcro1, 2 ) )."] executeSummary | getDataVentaMargen" ); }

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Ventas del Mes
        $f_Midcro1 = microtime( true );
        $this->s_Anio2    = date( "Y" );
        $this->s_Periodo2 = date( "m" );
        if( $this->getRequestParameter( "Control" ) )
        {
            $this->s_Anio2    = $this->getRequestParameter( "Anio2" );
            $this->s_Periodo2 = $this->getRequestParameter( "Periodo2" );
        }

        $s_ConcatPeriodo2 = $this->s_Anio2.$this->s_Periodo2;
        //pr( $s_ConcatPeriodo2 );
        //$this->a_controlGastosCobranzas = VTA_DocumentoFN::getDataControlGastosCobranzas( $s_ConcatPeriodo2 );
        $f_Midcro2 = microtime( true );
        if( SF_DEBUG ){ pr( "[".( round( $f_Midcro2 - $f_Midcro1, 2 ) )."] executeSummary | getDataControlGastosCobranzas" ); }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Producto mas vendido - canvas 11
        $f_Midcro1 = microtime( true );

        $this->a_DataPMV = VTA_DocumentoDetalleFN::Grafica_producto_mas_vendido( $this->getRequestParameterAll() );
        //pr ($this->a_DataPMV);
        
        $a_DescripcionPMV = array();
        $a_MontoFinalPMV = array();
        
        foreach ( $this->a_DataPMV as $i_Key => $a_Value )
        {
            $a_DescripcionPMV[]    = $a_Value['DescripcionCompleta'];
            $a_MontoFinalPMV[] = $a_Value['SumMontoFinal'];
        }
        
        //pr($a_DescripcionPMV);
        //pr($a_MontoFinalPMV);
        
        $this->s_DescripcionPMV = "'".implode( "','", $a_DescripcionPMV )."'";
        $this->s_MontoFinalPMV  = implode( ",", $a_MontoFinalPMV );
		//pr($this->s_MontoFinalPMV);
        $this->o_GSS_CompaniaBN = myUser::getUser()->getObjectCompania();
        $f_Midcro2 = microtime( true );
        if( SF_DEBUG ){ pr( "[".( round( $f_Midcro2 - $f_Midcro1, 2 ) )."] executeSummary | Grafica_producto_mas_vendido" ); }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /// AHORA SE BUSCA TOTALES PARA EDAD DE INVENTARIO
        //$o_TMP_sfUser = myUser::getUser();
        //$o_TMP_sfUser->getPerm( "mnu.rep.bi.edadinventario" );
        /*if( SEG_MenuFN::estaHabilitadoMenuPorIdtarea( "mnu.rep.bi.edadinventario" ) )
        {
            $f_Midcro1                = microtime( true );
            $a_Data                   = ALM_TransParaRepInvFN::ResumenEdadInventarioTotales( 0, 15 );
            $this->EdadInv_015        = $a_Data['COSTO_TOTAL'];
            $a_Data                   = ALM_TransParaRepInvFN::ResumenEdadInventarioTotales( 16, 30 );
            $this->EdadInv_1630       = $a_Data['COSTO_TOTAL'];
            $a_Data                   = ALM_TransParaRepInvFN::ResumenEdadInventarioTotales( 31, 45 );
            $this->EdadInv_3145       = $a_Data['COSTO_TOTAL'];
            $a_Data                   = ALM_TransParaRepInvFN::ResumenEdadInventarioTotales( 46, 60 );
            $this->EdadInv_4660       = $a_Data['COSTO_TOTAL'];
            $a_Data                   = ALM_TransParaRepInvFN::ResumenEdadInventarioTotales( 61, 75 );
            $this->EdadInv_6175       = $a_Data['COSTO_TOTAL'];
            $a_Data                   = ALM_TransParaRepInvFN::ResumenEdadInventarioTotales( 76, 90 );
            $this->EdadInv_7690       = $a_Data['COSTO_TOTAL'];
            $a_Data                   = ALM_TransParaRepInvFN::ResumenEdadInventarioTotales( 91, 99999 );
            $this->EdadInv_91MAS      = $a_Data['COSTO_TOTAL'];
            $this->EdadInv_SUMA_TOTAL = $this->EdadInv_015 + $this->EdadInv_1630 + $this->EdadInv_3145 + $this->EdadInv_4660 + $this->EdadInv_6175 + $this->EdadInv_7690 + $this->EdadInv_91MAS;

            $f_Midcro2 = microtime( true );
            if( SF_DEBUG )
            {
                pr( "[".( round( $f_Midcro2 - $f_Midcro1, 2 ) )."] executeSummary | Edad Inventario" );
            }
        }*/
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    }
}
