<?php
class tipocambioActions extends wtActions
{
    public function executeIndex()
    {
        
    }
    
    public function executeRequestTipoCambio()
    {
        $o_iVentas = new iVentas();
        $o_iVentas->registrarTipoCambio();
        
        return ViewResponse::NONE;
    }
    
    public function executeList()
    {
    	$this->block = $this->getRequestParameter( 'block' );
    	
    	$o_GSS_CompaniaFN = new GSS_CompaniaFN();
    	$o_GSS_CompaniaFN->addOrderBy(GSS_CompaniaFN::DescripcionCorta );
    	$o_GSS_CompaniaFN->setEstado('A');
    	
        $this->a_GSS_Compania= $o_GSS_CompaniaFN->select();
        
    	
    }
    
    public function executeGrid()
    {
       
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        $FechaInicio  = $this->getRequestParameter( 'FechaInicio' );
        $FechaFin  = $this->getRequestParameter( 'FechaFin' );
		$IdCompania     	= $this->getRequestParameter( 'IdCompania' );
		if(!$IdCompania) $IdCompania =  myUser::getUser()->getIdBusiness() ; 
		if(!$FechaInicio) $FechaInicio =  date("Y-m-d") ; 
		if(!$FechaFin) $FechaFin =  date("Y-m-d") ; 
		
		
		ParameterWR::getInstance()->setVar( "IdCompania", $IdCompania );		
		ParameterWR::getInstance()->setVar( "FechaFin", $FechaFin );		
		ParameterWR::getInstance()->setVar( "FechaInicio", $FechaInicio );		
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new GSS_TipoCambioFN() );
        
        $o_GridAction->addConditionFilter( "FechaInicio", GSS_TipoCambioFN::IdFechaCambio, ">=" );
        $o_GridAction->addConditionFilter( "FechaFin", GSS_TipoCambioFN::IdFechaCambio, "<=" );
		$o_GridAction->addConditionFilter( "IdCompania", GSS_TipoCambioFN::IdCompania, "=");
        
        $o_GridAction->addOrder( "FechaCambio", GSS_TipoCambioFN::IdFechaCambio,false);
        
        $o_GridAction->addOrder( "SunatCompra", GSS_TipoCambioFN::SunatCompra);
        
        $o_GridAction->addOrder( "SunatVenta", GSS_TipoCambioFN::SunatVenta);
        
        $o_GridAction->addOrder( "TipoCambioCobranza", GSS_TipoCambioFN::TipoCambioCobranza);
        
        $o_GridAction->addOrder( "Estado", GSS_TipoCambioFN::Estado );
        
        $o_GridAction->addOrderDefault( GSS_TipoCambioFN::IdFechaCambio , false );
        
        //$o_GridAction->addRowsToShow( "IdMonedaCambio", "FechaCambio","SunatCompra","SunatVenta","TipoCambioCobranza", "Estado" );
         $o_GridAction->setControlArray( false );
         
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        
        $a_ResultSelect    = $o_GridAction->getResultSelect();
        $a_Rs = array();
        
        foreach ( $a_ResultSelect as $iKey => $o_ObjClassBN )
        {
            $o_GSS_CompaniaFN = new GSS_CompaniaFN();
            $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $o_ObjClassBN->getIdCompania() );
            
            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_TipoCambioBN_O = $o_GSS_MonedaMastFN->selectByPk($o_ObjClassBN->getIdMoneda());

            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_TipoCambioBN_D = $o_GSS_MonedaMastFN->selectByPk($o_ObjClassBN->getIdMonedaCambio());
		   
        
           
            if(!is_object($o_GSS_CompaniaBN)) $o_GSS_CompaniaBN = new GSS_CompaniaBN();
            
            $a_Rs[] = array(  
                                "IdTipoCambio"   => 		utf8_encode( $o_ObjClassBN->getIdCompania()."_".$o_ObjClassBN->getIdMoneda()."_".$o_ObjClassBN->getIdMonedaCambio()."_".$o_ObjClassBN->getIdFechaCambio()),
                                "IdMoneda"   => 		utf8_encode( $o_GSS_TipoCambioBN_O->getDescripcion()),
            					"IdMonedaCambio"   => 		utf8_encode( $o_GSS_TipoCambioBN_D->getDescripcion()),
            					"FechaCambio"   => 		utf8_encode( $o_ObjClassBN->getIdFechaCambio()),
            					"SunatCompra"   => 		utf8_encode( $o_ObjClassBN->getSunatCompra()),
            					"SunatVenta"   => 		utf8_encode( $o_ObjClassBN->getSunatVenta()),
            					"TipoCambioCobranza"   => 		utf8_encode( $o_ObjClassBN->getTipoCambioCobranza()),
                                
                                
                               // "Descripcion"      => utf8_encode( $o_ObjClassBN->getDescripcion() ),
                                "Estado"     => $o_ObjClassBN->getEstado()
                           );
        }
        $a_ResultJson['rows'] = $a_Rs;
          
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;   
    }
    
    
   
    public function executeAddedit()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
       
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaFN->addOrderBy(GSS_CompaniaFN::DescripcionCorta );
        $o_GSS_CompaniaFN->setEstado('A');
        $this->a_GSS_Compania= $o_GSS_CompaniaFN->select();
        
        $this->s_Titulo = "Nuevo Tipo de Cambio (T/C)";
        
         /************/
        $o_GSS_TipoCambioBN = new GSS_TipoCambioBN();
        $o_GSS_TipoCambioBN->setEstado('A');
        $this->o_GSS_TipoCambioBN = $o_GSS_TipoCambioBN;
        $this->o_GSS_TipoCambioBN->setIdFechaCambio( date( "Y-m-d" ) );
        /*************/
        //$this->o_ALM_MarcaBN = new ALM_MarcaBN();
        if( $this->s_TipoProc == "upd" )
        {
            $a_Ids = explode( "_", $this->i_Id );
            $i_IdCompania       = $a_Ids[0];
            $i_IdMoneda         = $a_Ids[1];
            $i_IdMonedaCambio   = $a_Ids[2];
            $d_FechaCambio      = $a_Ids[3];

            $this->s_Titulo = "Editar Tipo de Cambio";
            $o_GSS_TipoCambioFN = new GSS_TipoCambioFN();
            $this->o_GSS_TipoCambioBN = $o_GSS_TipoCambioFN->selectByPK( $i_IdMoneda, $i_IdMonedaCambio, $d_FechaCambio, $i_IdCompania );
        }
    }
   
    public function executeSaveAddEdit()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        
        $IdMoneda           = $this->getRequestParameter( 'IdMoneda' );
        $IdCompania         = $this->getRequestParameter( 'IdCompania' );
        $IdMonedaCambio     = $this->getRequestParameter( 'IdMonedaCambio' );
        $FechaCambio        = trim( $this->getRequestParameter( 'FechaCambio' ) );
        $SunatCompra        = trim( $this->getRequestParameter( 'SunatCompra' ) );
        $SunatVenta         = trim( $this->getRequestParameter( 'SunatVenta' ) );
        $TipoCambioCobranza = trim( $this->getRequestParameter( 'TipoCambioCobranza' ) );
        $Estado             = $this->getRequestParameter( 'Estado' );
        
        $TipoCambioCobranza = $TipoCambioCobranza=="" ? $SunatVenta : $TipoCambioCobranza;
        
        try
        {
            $o_GSS_TipoCambioDP = new GSS_TipoCambioDP();            
            $o_GSS_TipoCambioDP->setIdCompania((int)$IdCompania);
            $o_GSS_TipoCambioDP->setIdFechaCambio($FechaCambio);
            $o_GSS_TipoCambioDP->setSunatCompra((float)$SunatCompra);
            $o_GSS_TipoCambioDP->setSunatVenta((float)$SunatVenta);
            $o_GSS_TipoCambioDP->setTipoCambioCobranza((float)$TipoCambioCobranza);
            $o_GSS_TipoCambioDP->setEstado( $Estado );
            
            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $o_GSS_TipoCambioDP->setIdMoneda( $IdMoneda );
                $o_GSS_TipoCambioDP->setIdMonedaCambio( $IdMonedaCambio );
                $o_GSS_TipoCambioDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_GSS_TipoCambioDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
              
                $b_Result = $o_GSS_TipoCambioDP->save();
                $i_Id = $IdMonedaCambio;
            }
            else 
            {
                //UPDATE
				
                $a_Ids = explode( "_", $i_Id );
	            $i_IdCompania       = $a_Ids[0];
	            $i_IdMoneda         = $a_Ids[1];
	            $i_IdMonedaCambio 	= $a_Ids[2];
	            $d_FechaCambio      = $a_Ids[3];
	            
            	$o_GSS_TipoCambioDP->setIdMoneda($i_IdMoneda);
            	$o_GSS_TipoCambioDP->setIdCompania((int)$i_IdCompania);
            	$o_GSS_TipoCambioDP->setIdMonedaCambio($i_IdMonedaCambio);
            	$o_GSS_TipoCambioDP->setIdFechaCambio($d_FechaCambio);
	             
                $o_GSS_TipoCambioDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_GSS_TipoCambioDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_GSS_TipoCambioDP->update();
            }
            
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $block          = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );
        
        $a_Ids = explode( "_", $i_Id );
        $i_IdCompania       = $a_Ids[0];
        $i_IdMoneda         = $a_Ids[1];
        $i_IdMonedaCambio 	= $a_Ids[2];
        $d_FechaCambio      = $a_Ids[3];
        
        $this->s_Topico = "Tipo de Cambio";
        $o_GSS_TipoCambioFN = new GSS_TipoCambioFN();
        $this->o_ObjectBN = $o_GSS_TipoCambioFN->selectByPK( $i_IdMoneda, $i_IdMonedaCambio, $d_FechaCambio, $i_IdCompania );
    }
    
    public function executeViewdel()
    {
    	$o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaFN->addOrderBy(GSS_CompaniaFN::DescripcionCorta );
        $o_GSS_CompaniaFN->setEstado('A');
        $this->a_GSS_Compania= $o_GSS_CompaniaFN->select();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
               
        $a_Ids = explode( "_", $this->i_Id  );
        $i_IdCompania       = $a_Ids[0];
        $i_IdMoneda         = $a_Ids[1];
        $i_IdMonedaCambio   = $a_Ids[2];
        $d_FechaCambio      = $a_Ids[3];
        
        $this->s_Topico = "Tipo Cambio";
        $o_GSS_TipoCambioFN = new GSS_TipoCambioFN();
        $this->o_GSS_TipoCambioBN = $o_GSS_TipoCambioFN->selectByPK( $i_IdMoneda, $i_IdMonedaCambio, $d_FechaCambio, $i_IdCompania );
    }
    
    /* public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        try 
        {
            $o_MST_UnidadMastDP = new MST_UnidadMastDP();
            $o_MST_UnidadMastDP->setIdUnidad( $i_Id );
            $o_MST_UnidadMastDP->delete();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }*/
    
    
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        try 
        {
        	
            $a_Ids = explode( "_", $i_Id );
            $i_IdCompania         = $a_Ids[0];
            $i_IdMoneda         = $a_Ids[1];
            $i_IdMonedaCambio 	= $a_Ids[2];
            $d_FechaCambio      = $a_Ids[3];
            $o_GSS_TipoCambioDP = new GSS_TipoCambioDP();
        	$o_GSS_TipoCambioDP->setIdCompania((int)$i_IdCompania);
        	$o_GSS_TipoCambioDP->setIdMoneda($i_IdMoneda);
        	$o_GSS_TipoCambioDP->setIdMonedaCambio($i_IdMonedaCambio);
        	$o_GSS_TipoCambioDP->setIdFechaCambio($d_FechaCambio);
            $o_GSS_TipoCambioDP->delete();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}