<?php
class ptovtaActions extends wtActions
{
    public function executeIndex()
    {
    }
    
    public function executeRequest()
    {
        set_header_utf8();
        $block        	= $this->getRequestParameter( 'block' );
        $TipoProc     	= $this->getRequestParameter( 'TipoProc' );
        
        $IdCompania 	= $this->getRequestParameter( 'IdCompania' );
        $IdSucursal    	= $this->getRequestParameter( 'IdSucursal' );
        $IdLinea       	= $this->getRequestParameter( 'IdLinea' );
         
        switch ( $TipoProc )
        {
            case "GetSucursal":
                $o_GSS_SucursalFN = new GSS_SucursalFN();
                $o_GSS_SucursalFN->setIdCompania( $IdCompania );
                $a_Result = $o_GSS_SucursalFN->select();
                
                $s_NameId  = "getIdSucursal";
                $s_NameDes = "getDescripcion";
            break;
            case "GetInfoTicket":
                $o_GSS_TicketeraFN = new GSS_TicketeraFN();
                $o_GSS_TicketeraFN->setIdSucursal( $IdSucursal );
                $a_Result = $o_GSS_TicketeraFN->select();
                if( $a_Result )
                {
                    $o_GSS_TicketeraBN = $a_Result[0];
                    $a_Request['AutorizacionSunat'] = $o_GSS_TicketeraBN->getAutorizacionSunat();
                    $a_Request['SerieTicket'] = $o_GSS_TicketeraBN->getSerieTicket();
                    echo json_encode( $a_Request );
                    
                }
                exit;
            break;
            case "actualizarSerieActual":
                $s_NumeroActual        = $this->getRequestParameter( 'NumeroActual' );
                $s_IdSucursalDocumento = $this->getRequestParameter( 'Id' );
                $a_Request             = array( "error" => false );
                try
                {
                    $o_GSS_SucursalDocumentoDP = new GSS_SucursalDocumentoDP();
                    $o_GSS_SucursalDocumentoDP->setIdSucursalDocumento( ( int ) $s_IdSucursalDocumento );
                    $o_GSS_SucursalDocumentoDP->setNumeroActual( ( int ) $s_NumeroActual );
                    $o_GSS_SucursalDocumentoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_GSS_SucursalDocumentoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_GSS_SucursalDocumentoDP->update();
                }
                catch( Exception $o_Exception )
                {
                    $a_Request['error'] = true;
                    $a_Request['mensaje_error'] = $o_Exception->getMessage();
                }
                
                echo json_encode( $a_Request );
                
                exit;
            break;
        }
        foreach ( $a_Result as $i_Key => $o_ObjectBN )
        {
            $a_lst[$o_ObjectBN->$s_NameId()] = utf8_encode( $o_ObjectBN->$s_NameDes() );
        }
        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    } 
    
    public function executeList()
    {
    	$this->block = $this->getRequestParameter( 'block' );
    	
    	$o_GSS_CompaniaFN = new GSS_CompaniaFN();
    	$o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::IdCompania );
    	$this->a_GSS_Compania = $o_GSS_CompaniaFN->select();
    }
    
    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new GSS_SucursalDocumentoFN() );
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdSucursal" );
        $o_GridAction->addAssignFilter( "Estado" );
        //$o_GridAction->addConditionFilter( "Descripcion", GSS_ImpuestoFN::Descripcion, "LIKE", "%%s%" );
        
        if( $this->getRequestParameter( 'FormatoDocumento' ) )
        {
            switch ( $this->getRequestParameter( 'FormatoDocumento' ) )
            {
                case "T":
                    $s_Parametro = "DocumentoTicketFlag";
                    ParameterWR::getInstance()->setVar( $s_Parametro, "S" );
                break;
                case "D":
                    $s_Parametro = "DocumentoFormatoFlag";
                    ParameterWR::getInstance()->setVar( $s_Parametro, "S" );
                break;
            }
            $o_GridAction->addAssignFilter( $s_Parametro );
        }
        
        
        //$o_GridAction->addOrder( "Descripcion", GSS_ImpuestoFN::Descripcion );
        //$o_GridAction->addOrder( "Codigo", GSS_ImpuestoFN::Codigo );
        
        $o_GridAction->addOrderDefault( GSS_SucursalDocumentoFN::IdSucursalDocumento, true );
        
        $o_GridAction->addRowsToShow( "IdSucursalDocumento","CompaniaDesc", "SucursalDesc", "TipoDocumentoDesc", "DocumentoTicketFlag", "SerieFormato", "RangoDesdeFormato", 'RangoHastaFormato', "NumeroActual", "Estado" );
              
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;   
    }
    
    public function executeAddedit()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nuevo Punto de Venta";
        
        /************/
        
        $o_DefaultBN = new GSS_SucursalDocumentoFN();
        $o_DefaultBN->setEstado( 'A' );
        $this->o_DefaultBN = $o_DefaultBN;
        
        /*************/
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::IdCompania, true );
        $this->a_GSS_Compania = $o_GSS_CompaniaFN->select();
        
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoFN->setEstado( "A" );
        $o_VTA_TipoDocumentoFN->addCondition( VTA_TipoDocumentoFN::CodigoFiscal, "<>", "''", false );
        $o_VTA_TipoDocumentoFN->addCondition( VTA_TipoDocumentoFN::DescripcionIngles, "=", "PVTA" );
        $o_VTA_TipoDocumentoFN->addOrderBy( VTA_TipoDocumentoFN::DescripcionLocal );
        $this->a_VTA_TipoDocumento = $o_VTA_TipoDocumentoFN->select();
        
        $this->a_GSS_Sucursal = array();
        
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Punto de Venta";
            
            $o_DefaultFN = new GSS_SucursalDocumentoFN();
            $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
            
            $o_GSS_SucursalFN = new GSS_SucursalFN();
            $o_GSS_SucursalFN->setIdCompania( $this->o_DefaultBN->getIdCompania() );
            $this->a_GSS_Sucursal = $o_GSS_SucursalFN->select();
        }
    }
    
    public function executeSaveAddEdit()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );

        $IdCompania      = ( int ) $this->getRequestParameter( 'IdCompania' );
        $IdSucursal      = ( int ) $this->getRequestParameter( 'IdSucursal' );
        $IdTipoDocumento = $this->getRequestParameter( 'IdTipoDocumento' );

        $Estado = $this->getRequestParameter( 'Estado' );

        $DocumentoTicketFlag  = $this->getRequestParameter( 'DocumentoTicketFlag' ) ? "S" : "N";
        $DocumentoFormatoFlag = $this->getRequestParameter( 'DocumentoFormatoFlag' ) ? "S" : "N";

        $RUCImprimioFormato          = $this->getRequestParameter( 'RUCImprimioFormato' );
        $EmpresaImprimioFormato      = $this->getRequestParameter( 'EmpresaImprimioFormato' );
        $FechaInicioFormato          = $this->getRequestParameter( 'FechaInicioFormato' );
        $FechaFinFormato             = $this->getRequestParameter( 'FechaFinFormato' );
        $SerieFormato                = $this->getRequestParameter( 'SerieFormato' );
        $AutorizacionImprimioFormato = $this->getRequestParameter( 'AutorizacionImprimioFormato' );
        $RangoDesdeFormato           = ( int ) $this->getRequestParameter( 'RangoDesdeFormato' );
        $RangoHastaFormato           = ( int ) $this->getRequestParameter( 'RangoHastaFormato' );

        $AutorizacionSunatTicket = $this->getRequestParameter( 'AutorizacionSunatTicket' );
        $SerieTicket             = $this->getRequestParameter( 'SerieTicket' );
        
        try 
        {
            $o_DefaultDP = new GSS_SucursalDocumentoDP();
            $o_DefaultDP->setIdCompania( $IdCompania );
            $o_DefaultDP->setIdSucursal( $IdSucursal );
            $o_DefaultDP->setIdTipoDocumento( $IdTipoDocumento );

            $o_DefaultDP->setEstado( $Estado );
            
            $o_DefaultDP->setDocumentoTicketFlag( $DocumentoTicketFlag );
            $o_DefaultDP->setDocumentoFormatoFlag( $DocumentoFormatoFlag );
            
            $o_DefaultDP->setFechaInicioFormato( $FechaInicioFormato );
            $o_DefaultDP->setFechaFinFormato( $FechaFinFormato );
            $o_DefaultDP->setSerieFormato( $SerieFormato );
            $o_DefaultDP->setRangoDesdeFormato( $RangoDesdeFormato );
            $o_DefaultDP->setRangoHastaFormato( $RangoHastaFormato );
            
            if ( $DocumentoFormatoFlag == "S" )
            {
                $o_DefaultDP->setRUCImprimioFormato( $RUCImprimioFormato );
                $o_DefaultDP->setEmpresaImprimioFormato( $EmpresaImprimioFormato );
                $o_DefaultDP->setAutorizacionImprimioFormato( $AutorizacionImprimioFormato );
                
                $o_DefaultDP->setAutorizacionSunatTicket( "" );
                $o_DefaultDP->setSerieTicket( "" );
            }
            if ( $DocumentoTicketFlag == "S" )
            {
                $o_DefaultDP->setRUCImprimioFormato( "" );
                $o_DefaultDP->setEmpresaImprimioFormato( "" );
                $o_DefaultDP->setAutorizacionImprimioFormato( "" );
                
                $o_DefaultDP->setAutorizacionSunatTicket( $AutorizacionSunatTicket );
                $o_DefaultDP->setSerieTicket( $SerieTicket );
            }
            
            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $IdDefault = GSS_SucursalDocumentoFN::recuperarId();
                
                $o_DefaultDP->setNumeroActual( $RangoDesdeFormato );
                
                $o_DefaultDP->setIdSucursalDocumento( $IdDefault );
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->save();
                $i_Id = $IdDefault;
            }
            else 
            {
                //UPDATE
                $o_DefaultDP->setIdSucursalDocumento( ( int ) $i_Id );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->update();
            }
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $block          = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );
        $this->s_Topico = "Impuesto";
        $o_DefaultFN = new GSS_ImpuestoFN();
        $this->o_ObjectBN = $o_DefaultFN->selectByPK( $i_Id );
    }
    
    public function executeViewdel()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );

        $o_DefaultFN = new GSS_SucursalDocumentoFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::DescripcionCorta );
        $this->a_GSS_Compania = $o_GSS_CompaniaFN->select();
        
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoFN->addOrderBy( VTA_TipoDocumentoFN::DescripcionLocal );
        $this->a_VTA_TipoDocumento = $o_VTA_TipoDocumentoFN->select();
        
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalFN->setIdCompania( $this->o_DefaultBN->getIdCompania() );
        $this->a_GSS_Sucursal = $o_GSS_SucursalFN->select();
    }
    
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        try 
        {
            $o_DefaultDP = new GSS_SucursalDocumentoDP();
            $o_DefaultDP->setIdSucursalDocumento( ( int ) $i_Id );
            $o_DefaultDP->delete();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}