<?php
class addempActions extends wtActions
{
    public function executeIndex()
    {
        
    }

    public function executeAddCaja()
    {
        $this->block = $this->getRequestParameter( 'block' );
        $this->i_Id  = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc  = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Editar Usuario";
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->i_Id );
        
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalFN->setIdCompania( $this->i_Id );
        $this->a_GSS_Sucursal = $o_GSS_SucursalFN->select();

        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //para filtros
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->a_GSS_CompaniaFiltro = $o_GSS_CompaniaFN->select();
        $this->s_CompaniaFiltro = $this->getRequestParameter( 'cboEmpresa' );

        $o_SEG_UsuarioFN = new SEG_UsuarioFN();
        $this->a_SEG_UsuarioFiltro = $o_SEG_UsuarioFN->select();
        $this->s_UsuarioFiltro = $this->getRequestParameter( 'cboUsuario' );

        $o_FCO_CajaFN = new FCO_CajaFN();
        //$o_FCO_CajaFN->setEstado( "A" );
        $o_FCO_CajaFN->addOrderBy( FCO_CajaFN::Descripcion );
        $this->a_FCO_Caja = $o_FCO_CajaFN->select();
        $this->s_CajaFiltro = $this->getRequestParameter( 'cboCaja' );
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $o_SEG_UsuarioFN = new SEG_UsuarioFN();
        if( $this->getRequestParameter( 'cboUsuario' ) )
        {
            $o_SEG_UsuarioFN->setIdusuario( $this->getRequestParameter( 'cboUsuario' ) );
        }
        $o_SEG_UsuarioFN->addOrderBy( SEG_UsuarioFN::IdUsuario );
        $this->a_SEG_Usuario = $o_SEG_UsuarioFN->select();

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaFN->setEstado( 'A' );
        if( $this->getRequestParameter( 'cboEmpresa' ) )
        {
            $o_GSS_CompaniaFN->setIdCompania( $this->getRequestParameter( 'cboEmpresa' ) );
        }
        $o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::IdCompania, true );
        $this->a_GSS_Compania = $o_GSS_CompaniaFN->select();

        $o_GSS_SucursalFN = new GSS_SucursalFN();
        //$o_GSS_SucursalFN->setIdCompania( $this->o_UsuarioBN->getIdCompania() );
        $o_GSS_SucursalFN->addOrderBy( GSS_SucursalFN::IdSucursal );
        $a_GSS_Sucursal = $o_GSS_SucursalFN->select();
        $this->a_LstSucursal = array();
        foreach ( $a_GSS_Sucursal as $o_GSS_SucursalBN )
        {
            $this->a_LstSucursal[$o_GSS_SucursalBN->getIdCompania()][$o_GSS_SucursalBN->getIdSucursal()] = $o_GSS_SucursalBN;
        }

        //ahora el array principal
        $o_FCO_CajaFN = new FCO_CajaFN();
        //$o_FCO_CajaFN->setEstado( "A" );
        $o_FCO_CajaFN->addOrderBy( FCO_CajaFN::Descripcion );
        $a_FCO_Caja = $o_FCO_CajaFN->select();
        foreach ( $a_FCO_Caja as $o_FCO_CajaBN )
        {
            $this->a_LstCaja[$o_FCO_CajaBN->getIdCompania()][$o_FCO_CajaBN->getIdSucursal()][] = $o_FCO_CajaBN;
        }
    }

    public function executeRequest()
    {
        $s_TipoProc  = $this->getRequestParameter( 'tipo_proc' );

        $a_lst = array( "error" => false );

        try
        {
            switch ( $s_TipoProc )
            {
                case "actualizar_doc":
                    $s_Tipo = $this->getRequestParameter( 'tipo' );
                    $s_Value = $this->getRequestParameter( 'value' );
                    $a_Value = explode( "|@|", $s_Value );
                    list( $Idusuario, $IdCompania, $IdTipoDocumento, $IdSucursalDocumento, $SerieFormato ) = $a_Value;

                    $o_GSS_UsuarioSucuDocumentoFN = new GSS_UsuarioSucuDocumentoFN();
                    $o_GSS_UsuarioSucuDocumentoFN->setIdusuario( $Idusuario );
                    $o_GSS_UsuarioSucuDocumentoFN->setIdCompania( $IdCompania );
                    $o_GSS_UsuarioSucuDocumentoFN->setIdTipoDocumento( $IdTipoDocumento );
                    $o_GSS_UsuarioSucuDocumentoFN->setIdSucursalDocumento( $IdSucursalDocumento );
                    $a_GSS_UsuarioSucuDocumento = $o_GSS_UsuarioSucuDocumentoFN->select();

                    if( $s_Tipo == "save" )
                    {
                        if( !$a_GSS_UsuarioSucuDocumento )
                        {
                            $s_Id = GSS_UsuarioSucuDocumentoDP::recuperarId();
                            $o_GSS_UsuarioSucuDocumentoDP = new GSS_UsuarioSucuDocumentoDP();
                            $o_GSS_UsuarioSucuDocumentoDP->setIdSucuDoc( $s_Id );
                            $o_GSS_UsuarioSucuDocumentoDP->setIdusuario( $Idusuario );
                            $o_GSS_UsuarioSucuDocumentoDP->setIdCompania( intval( $IdCompania ) );
                            $o_GSS_UsuarioSucuDocumentoDP->setIdTipoDocumento( $IdTipoDocumento );
                            $o_GSS_UsuarioSucuDocumentoDP->setIdSucursalDocumento( intval( $IdSucursalDocumento ) );
                            $o_GSS_UsuarioSucuDocumentoDP->setSerieDocumento( $SerieFormato );
                            $o_GSS_UsuarioSucuDocumentoDP->save();
                        }
                    }
                    if( $s_Tipo == "del" )
                    {
                        if( $a_GSS_UsuarioSucuDocumento )
                        {
                            $o_GSS_UsuarioSucuDocumentoBN = $a_GSS_UsuarioSucuDocumento[0];

                            $o_GSS_UsuarioSucuDocumentoDP = new GSS_UsuarioSucuDocumentoDP();
                            $o_GSS_UsuarioSucuDocumentoDP->setIdSucuDoc( $o_GSS_UsuarioSucuDocumentoBN->getIdSucuDoc() );
                            $o_GSS_UsuarioSucuDocumentoDP->delete();
                        }
                    }
                break;
                case "actualizar_doc_caja":
                    $s_Tipo = $this->getRequestParameter( 'tipo' );
                    $s_Value = $this->getRequestParameter( 'value' );
                    $a_Value = explode( "|@|", $s_Value );
                    list( $Idusuario, $IdCompania, $IdCaja, $IdSucursal ) = $a_Value;
                    $IdCaja = intval( $IdCaja );

                    $o_FCO_CajaUsuarioFN = new FCO_CajaUsuarioFN();
                    $o_FCO_CajaUsuarioFN->setIdCaja( $IdCaja );
                    $o_FCO_CajaUsuarioFN->setIdUsuario( $Idusuario );
                    $o_FCO_CajaUsuarioFN->setIdCompania( intval( $IdCompania ) );
                    $o_FCO_CajaUsuarioFN->setIdSucursal( intval( $IdSucursal ) );
                    $a_FCO_CajaUsuario = $o_FCO_CajaUsuarioFN->select();

                    if( $s_Tipo == "save" )
                    {
                        if( !$a_FCO_CajaUsuario )
                        {
                            $o_FCO_CajaUsuarioDP = new FCO_CajaUsuarioDP();
                            $o_FCO_CajaUsuarioDP->setIdCaja( $IdCaja );
                            $o_FCO_CajaUsuarioDP->setIdUsuario( $Idusuario );
                            $o_FCO_CajaUsuarioDP->setIdCompania( intval( $IdCompania ) );
                            $o_FCO_CajaUsuarioDP->setIdSucursal( intval( $IdSucursal ) );
                            $o_FCO_CajaUsuarioDP->setEnUsoFlag( 0 );
                            $o_FCO_CajaUsuarioDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                            $o_FCO_CajaUsuarioDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                            $o_FCO_CajaUsuarioDP->save();
                        }
                    }

                    if( $s_Tipo == "del" )
                    {
                        if( $a_FCO_CajaUsuario )
                        {
                            $o_FCO_CajaUsuarioDP = new FCO_CajaUsuarioDP();
                            $o_FCO_CajaUsuarioDP->setIdCaja( $IdCaja );
                            $o_FCO_CajaUsuarioDP->setIdUsuario( $Idusuario );
                            $o_FCO_CajaUsuarioDP->setIdCompania( intval( $IdCompania ) );
                            $o_FCO_CajaUsuarioDP->setIdSucursal( intval( $IdSucursal ) );
                            $o_FCO_CajaUsuarioDP->delete();
                        }
                    }

                break;

                case "actualizar_operacion_caja":

                    $s_IdCompania = intval( $this->getRequestParameter( 'IdCompania' ) );
                    $i_OpeCaja    = intval( $this->getRequestParameter( 'EstadoOperacionCaja' ) );

                    $o_GSS_CompaniaDP = new GSS_CompaniaDP();
                    $o_GSS_CompaniaDP->setIdCompania( $s_IdCompania );
                    $o_GSS_CompaniaDP->setOpeCierreCaja( $i_OpeCaja );
                    $o_GSS_CompaniaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_GSS_CompaniaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_GSS_CompaniaDP->update();

                break;
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_lst['error']         = true;
            $a_lst['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }

    public function executeDetPtoVta()
    {
        $this->block = $this->getRequestParameter( 'block' );
        $this->i_Id  = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc  = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Editar Usuario";
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->i_Id );
        
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalFN->setIdCompania( $this->i_Id );
        $this->a_GSS_Sucursal = $o_GSS_SucursalFN->select();

        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //para filtros
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->a_GSS_CompaniaFiltro = $o_GSS_CompaniaFN->select();
        $this->s_CompaniaFiltro = $this->getRequestParameter( 'cboEmpresa' );

        $o_SEG_UsuarioFN = new SEG_UsuarioFN();
        $this->a_SEG_UsuarioFiltro = $o_SEG_UsuarioFN->select();
        $this->s_UsuarioFiltro = $this->getRequestParameter( 'cboUsuario' );

        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoFN->setEstado( "A" );
        $o_VTA_TipoDocumentoFN->addCondition( VTA_TipoDocumentoFN::CodigoFiscal, "<>", "''", false );
        $o_VTA_TipoDocumentoFN->addOrderBy( VTA_TipoDocumentoFN::DescripcionLocal );
        $this->a_VTA_TipoDocumentoFiltro = $o_VTA_TipoDocumentoFN->select();
        $this->s_TipoDocumentoFiltro = $this->getRequestParameter( 'cboTipoDocumento' );
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $o_SEG_UsuarioFN = new SEG_UsuarioFN();
        if( $this->getRequestParameter( 'cboUsuario' ) )
        {
            $o_SEG_UsuarioFN->setIdusuario( $this->getRequestParameter( 'cboUsuario' ) );
        }
        $o_SEG_UsuarioFN->addOrderBy( SEG_UsuarioFN::IdUsuario );
        $this->a_SEG_Usuario = $o_SEG_UsuarioFN->select();

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaFN->setEstado( 'A' );
        if( $this->getRequestParameter( 'cboEmpresa' ) )
        {
            $o_GSS_CompaniaFN->setIdCompania( $this->getRequestParameter( 'cboEmpresa' ) );
        }
        $o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::IdCompania, true );
        $this->a_GSS_Compania = $o_GSS_CompaniaFN->select();
        
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        //$o_GSS_SucursalFN->setIdCompania( $this->o_UsuarioBN->getIdCompania() );
        $o_GSS_SucursalFN->addOrderBy( GSS_SucursalFN::IdSucursal );
        $a_GSS_Sucursal = $o_GSS_SucursalFN->select();
        $this->a_LstSucursal = array();
        foreach ( $a_GSS_Sucursal as $o_GSS_SucursalBN )
        {
            $this->a_LstSucursal[$o_GSS_SucursalBN->getIdCompania()][$o_GSS_SucursalBN->getIdSucursal()] = $o_GSS_SucursalBN;
        }

        $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
        if( $this->getRequestParameter( 'cboTipoDocumento' ) )
        {
            $o_GSS_SucursalDocumentoFN->setIdTipoDocumento( $this->getRequestParameter( 'cboTipoDocumento' ) );
        }
        //$o_GSS_SucursalDocumentoFN->addOrderBy( GSS_SucursalDocumentoFN::IdCompania );
        //$o_GSS_SucursalDocumentoFN->addOrderBy( GSS_SucursalDocumentoFN::IdSucursal );
        $o_GSS_SucursalDocumentoFN->addOrderBy( GSS_SucursalDocumentoFN::IdTipoDocumento );
        $o_GSS_SucursalDocumentoFN->addOrderBy( GSS_SucursalDocumentoFN::SerieFormato );
        $a_GSS_SucursalDocumento = $o_GSS_SucursalDocumentoFN->select();
        foreach ( $a_GSS_SucursalDocumento as $o_GSS_SucursalDocumentoBN )
        {
            $this->a_LstSucursalDocumento[$o_GSS_SucursalDocumentoBN->getIdCompania()][$o_GSS_SucursalDocumentoBN->getIdSucursal()][] = $o_GSS_SucursalDocumentoBN;
        }
        
        /*
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        if( $this->getRequestParameter( 'cboTipoDocumento' ) )
        {
            $o_VTA_TipoDocumentoFN->setIdTipoDocumento( $this->getRequestParameter( 'cboTipoDocumento' ) );
        }
        $o_VTA_TipoDocumentoFN->setEstado( "A" );
        $o_VTA_TipoDocumentoFN->addCondition( VTA_TipoDocumentoFN::CodigoFiscal, "<>", "''", false );
        $o_VTA_TipoDocumentoFN->addOrderBy( VTA_TipoDocumentoFN::DescripcionLocal );
        $this->a_VTA_TipoDocumento = $o_VTA_TipoDocumentoFN->select();
        */
    }
    
    public function executeList()
    {
        $this->block = $this->getRequestParameter( 'block' );
        
        //$this->redirect( 'addemp/grid', 'block='.$this->block );
    }
    
    public function executeGrid()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new GSS_CompaniaFN() );
        
        $o_GridAction->addMethodDefault( "Eliminado", -1 );
        //$o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        //$o_GridAction->addAssignFilter( "RUC" );
        
        $o_GridAction->addConditionFilter( "RUC", GSS_CompaniaFN::Ruc, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "Nombre", GSS_CompaniaFN::DescripcionCorta, "LIKE", "%%s%" );
		
        //$o_GridAction->addConditionFilter( "FechaInicio", TWD_PracticanteFN::FechaInicio,    ">=", "d-m-Y" );
        //$o_GridAction->addConditionFilter( "FechaFin",    TWD_PracticanteFN::FechaInicio,    "<=", "d-m-Y" );
        
        $o_GridAction->addOrder( "Codigo",           GSS_CompaniaFN::Codigo );
        $o_GridAction->addOrder( "DescripcionCorta", GSS_CompaniaFN::DescripcionCorta );
        $o_GridAction->addOrder( "Ruc",              GSS_CompaniaFN::Ruc );
        
        $o_GridAction->addOrderDefault( GSS_CompaniaFN::IdCompania, true );
        
        $o_GridAction->addRowsToShow( "IdCompania", "Codigo", "DescripcionCorta", "Ruc", "Telefono1", "PaginaWeb", "Estado" );
        
        //$o_GridAction->addInnerJoin( new MC_GupNivelFN(), "IdGupNivel", "DescCorto" );
        
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeVerPlano()
    {
        $this->block = $this->getRequestParameter( 'block' );
        $i_Id = $this->getRequestParameter( 'i_Id' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $i_Id );
    }
    
    public function executeAdd()
    {
        //set_header_iso_8859_1();
        
        $this->block = $this->getRequestParameter( 'block' );
        
        $this->o_GSS_CompaniaBN = new GSS_CompaniaBN();
    }
    
    public function executeEdit()
    {
        //set_header_iso_8859_1();
        
        $this->block = $this->getRequestParameter( 'block' );
        $this->i_Id = $this->getRequestParameter( 'i_Id' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->i_Id );
    }
    
    public function executeView()
    {
        
        $this->block = $this->getRequestParameter( 'block' );
        $i_Id = $this->getRequestParameter( 'i_Id' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $i_Id );
    }
    
    public function executeDelete()
    {
        $noEliminar = 0;
        $this->b_Result = false;
        $this->block = $this->getRequestParameter( 'block' );
        $this->i_Id = $this->getRequestParameter( 'i_Id' );
        $this->b_Control = $this->getRequestParameter( 'b_Control' );
        $b_Result = false;
        if( $this->b_Control )
        {
            try 
            {
                $o_GSS_CompaniaDP = new GSS_CompaniaDP();
                $o_GSS_CompaniaDP->setIdCompania( ( int ) $this->i_Id );
                if( $noEliminar == 0 )
                {
                    $b_Result = $o_GSS_CompaniaDP->delete();
                }
                if( $b_Result )
                {
                    $this->b_Result = $b_Result;
                }
            }
            catch ( Exception $o_Exception )
            {
                $this->b_Result = false;
                $this->s_MensajeError = "No se pudo eliminar el registro.";
            }
        }
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->i_Id );
    }
    
    public function executeAddCrianza()
    {
        $this->block = $this->getRequestParameter( 'block' );
        $this->i_Id  = $this->getRequestParameter( 'i_Id' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->i_Id );
        //pr( $this->o_GSS_CompaniaBN );
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalFN->setIdCompania( $this->i_Id );
        $this->a_GSS_Sucursal = $o_GSS_SucursalFN->select();
    }

    public function executeSaveImgBackCompania()
    {
        $i_Id = ( int ) $this->getRequestParameter( 'i_Id' );

        //$s_LogoBackFileAncho = $this->getRequestParameter( 'LogoBackFileAncho' );
        //$s_LogoBackFileAlto  = $this->getRequestParameter( 'LogoBackFileAlto' );

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $i_Id );

        $PATH_UPLOAD_IMAGES_ROUTE = $_SERVER['DOCUMENT_ROOT'].Constantes::ROOT_DIR_IMG."logo/";
        $uploadFileDir            = $PATH_UPLOAD_IMAGES_ROUTE;

        if( $o_GSS_CompaniaBN )
        {
            if( $this->getRequestParameter( 'TypeSubForm3' ) == "file_to_upload" )
            {

                $phpFileUploadErrors = array
                (
                    0 => 'There is no error, the file uploaded with success',
                    1 => 'El fichero subido excede la directiva upload_max_filesize de php.ini.',
                    2 => 'El fichero subido excede la directiva MAX_FILE_SIZE especificada en el formulario HTML.',
                    3 => 'El fichero fue sólo parcialmente subido.',
                    4 => 'No se subió ningún fichero.',
                    6 => 'Falta la carpeta temporal.',
                    7 => 'No se pudo escribir el fichero en el disco.',
                    8 => 'Una extensión de PHP detuvo la subida de ficheros. PHP no proporciona una forma de determinar la extensión que causó la parada de la subida de ficheros; el examen de la lista de extensiones cargadas con phpinfo() puede ayudar.',
                );

                if ( isset( $_FILES['file_upload'] ) )
                {
                    if ( $_FILES['file_upload']['error'] )
                    {
                        pr( $phpFileUploadErrors[$_FILES['file_upload']['error']] );
                        exit;
                    }

                    $fileTmpPath   = $_FILES['file_upload']['tmp_name'];
                    $fileName      = $_FILES['file_upload']['name'];
                    $fileSize      = $_FILES['file_upload']['size'];
                    $fileType      = $_FILES['file_upload']['type'];
                    $fileNameCmps  = explode( ".", $fileName );
                    $fileExtension = strtolower( end( $fileNameCmps ) );

                    //$newFileName   = $o_GSS_CompaniaBN->getRuc().".".$fileExtension;
                    $newFileName   = $fileName;
                    $dest_path     = $uploadFileDir . $newFileName;
                    $s_DestinoUrl  = Constantes::ROOT_DIR_IMG."logo/".$newFileName;

                    //if( move_uploaded_file( $fileTmpPath, $dest_path ) )
                    if ( copy( $fileTmpPath, $dest_path ) )
                    {
                        //$message ='File is successfully uploaded.';
                        //aqui se atualiza la url de la imagen
                        $o_GSS_CompaniaDP = new GSS_CompaniaDP();
                        $o_GSS_CompaniaDP->setIdCompania( $i_Id );
                        //$o_GSS_CompaniaDP->setIdAlmacen( 1 );
                        $o_GSS_CompaniaDP->setLogoBackFileWeb( $s_DestinoUrl );
                        $o_GSS_CompaniaDP->setLogoBackFileDir( $dest_path );
                        //$o_GSS_CompaniaDP->setLogoBackFileAncho( $s_LogoBackFileAncho );
                        //$o_GSS_CompaniaDP->setLogoBackFileAlto( $s_LogoBackFileAlto );
                        $o_GSS_CompaniaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_GSS_CompaniaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $b_Result = $o_GSS_CompaniaDP->update();
                    }
                    else
                    {
                    }
                }
            }
            elseif ( $this->getRequestParameter( 'TypeSubForm3' ) == "file_to_upload_del" )
            {
                $dest_path    = $uploadFileDir . "no_disponible.png";
                $s_DestinoUrl = Constantes::ROOT_DIR_IMG."no_disponible.png";

                $o_GSS_CompaniaDP = new GSS_CompaniaDP();
                $o_GSS_CompaniaDP->setIdCompania( $i_Id );
                //$o_GSS_CompaniaDP->setIdAlmacen( 1 );
                $o_GSS_CompaniaDP->setLogoBackFileDir( $dest_path );
                $o_GSS_CompaniaDP->setLogoBackFileWeb( $s_DestinoUrl );
                $o_GSS_CompaniaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_GSS_CompaniaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_GSS_CompaniaDP->update();
            }
        }

        //redirect
        $s_Dir = Constantes::ROOT_DIR_APP;
        header( "Location:".$s_Dir."cof.php/addemp/edit/block/001/i_Id/".$i_Id );
    }

    public function executeSaveImgCompania()
    {
        $i_Id = ( int ) $this->getRequestParameter( 'i_Id' );

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $i_Id );

        $PATH_UPLOAD_IMAGES_ROUTE = $_SERVER['DOCUMENT_ROOT'].Constantes::ROOT_DIR_IMG."logo/";
        $uploadFileDir            = $PATH_UPLOAD_IMAGES_ROUTE;

        if( $o_GSS_CompaniaBN )
        {
            if( $this->getRequestParameter( 'TypeSubForm2' ) == "file_to_upload" )
            {
                
                $phpFileUploadErrors = array
                (
                        0 => 'There is no error, the file uploaded with success',
                        1 => 'El fichero subido excede la directiva upload_max_filesize de php.ini.',
                        2 => 'El fichero subido excede la directiva MAX_FILE_SIZE especificada en el formulario HTML.',
                        3 => 'El fichero fue sólo parcialmente subido.',
                        4 => 'No se subió ningún fichero.',
                        6 => 'Falta la carpeta temporal.',
                        7 => 'No se pudo escribir el fichero en el disco.',
                        8 => 'Una extensión de PHP detuvo la subida de ficheros. PHP no proporciona una forma de determinar la extensión que causó la parada de la subida de ficheros; el examen de la lista de extensiones cargadas con phpinfo() puede ayudar.',
                );

                if ( isset( $_FILES['file_upload'] ) ) 
                {
                    if ( $_FILES['file_upload']['error'] )
                    {
                        pr( $phpFileUploadErrors[$_FILES['file_upload']['error']] );
                        exit;
                    }
                    


                    $fileTmpPath   = $_FILES['file_upload']['tmp_name'];
                    $fileName      = $_FILES['file_upload']['name'];
                    $fileSize      = $_FILES['file_upload']['size'];
                    $fileType      = $_FILES['file_upload']['type'];
                    $fileNameCmps  = explode( ".", $fileName );
                    $fileExtension = strtolower( end( $fileNameCmps ) );

                    $newFileName   = $o_GSS_CompaniaBN->getRuc().".".$fileExtension;
                    $dest_path     = $uploadFileDir . $newFileName;
                    $s_DestinoUrl  = Constantes::ROOT_DIR_IMG."logo/".$newFileName;
                     
                    //if( move_uploaded_file( $fileTmpPath, $dest_path ) )
                    if ( copy( $fileTmpPath, $dest_path ) ) 
                    {
                        //$message ='File is successfully uploaded.';
                        //aqui se atualiza la url de la imagen
                        $o_GSS_CompaniaDP = new GSS_CompaniaDP();
                        $o_GSS_CompaniaDP->setIdCompania( $i_Id );
                        //$o_GSS_CompaniaDP->setIdAlmacen( 1 );
                        $o_GSS_CompaniaDP->setLogoFile( $s_DestinoUrl );
                        $o_GSS_CompaniaDP->setLogoFileDir( $dest_path );
                        $o_GSS_CompaniaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_GSS_CompaniaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $b_Result = $o_GSS_CompaniaDP->update();
                    }
                    else
                    {
                    }
                }
            }
            elseif ( $this->getRequestParameter( 'TypeSubForm2' ) == "file_to_upload_del" ) 
            {
                $dest_path    = $uploadFileDir . "no_disponible.png";
                $s_DestinoUrl = Constantes::ROOT_DIR_IMG."no_disponible.png";

                $o_GSS_CompaniaDP = new GSS_CompaniaDP();
                $o_GSS_CompaniaDP->setIdCompania( $i_Id );
                //$o_GSS_CompaniaDP->setIdAlmacen( 1 );
                $o_GSS_CompaniaDP->setLogoFileDir( $dest_path );
                $o_GSS_CompaniaDP->setLogoFile( $s_DestinoUrl );
                $o_GSS_CompaniaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_GSS_CompaniaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_GSS_CompaniaDP->update();
            }
        }
        //redirect
        $s_Dir = Constantes::ROOT_DIR_APP;
        header( "Location:".$s_Dir."cof.php/addemp/edit/block/001/i_Id/".$i_Id );
    }

    public function executeSaveCompania()
    {
        $block              = $this->getRequestParameter( 'block' );
        $TypeSub            = ( boolean ) $this->getRequestParameter( 'TypeSub' );
        $TypeProc           = ( boolean ) $this->getRequestParameter( 'TypeProc' );
        
        $i_Id = $this->getRequestParameter( 'i_Id' );
        
        $Ruc                = $this->getRequestParameter( 'Ruc' );
        $DescripcionCorta   = $this->getRequestParameter( 'DescripcionCorta' );
        $DescripcionLarga   = $this->getRequestParameter( 'DescripcionLarga' );
        $Codigo             = $this->getRequestParameter( 'Codigo' );
        $Telefono1          = $this->getRequestParameter( 'Telefono1' );
        //$PlanoUnidadCrianza = $this->getRequestParameter( 'PlanoUnidadCrianza' );
        $PaginaWeb          = $this->getRequestParameter( 'PaginaWeb' );
        $RepresentanteLegal          = $this->getRequestParameter( 'RepresentanteLegal' );
        $DireccionComun     = $this->getRequestParameter( 'DireccionComun' );
        $DireccionAdicional = $this->getRequestParameter( 'DireccionAdicional' );

        $NotasdeVenta = $this->getRequestParameter( 'NotasdeVenta' );
        $NotasdeAlquiler = $this->getRequestParameter( 'NotasdeAlquiler' );

        $PorTipoCambio          = floatval( $this->getRequestParameter( 'PorTipoCambio' ) );
        $DeshabilitarTipoCambio = intval( $this->getRequestParameter( "DeshabilitarTipoCambio" ) );

        $AfectoIGVFlag           = is_null( $this->getRequestParameter( 'AfectoIGVFlag' ) ) ? "N" : "Y";
        $AfectoRetencionIGVFlag  = is_null( $this->getRequestParameter( 'AfectoRetencionIGVFlag' ) ) ? "N" : "Y";
        $AfectoPercepcionIGVFlag = is_null( $this->getRequestParameter( 'AfectoPercepcionIGVFlag' ) ) ? "N" : "Y";

        $EnviarProveedorAutoFlag  = intval( $this->getRequestParameter( 'EnviarProveedorAutoFlag' ) );
        $DirParaBuscarComprobante = $this->getRequestParameter( 'DirParaBuscarComprobante' );

        $MostrarNumeroLote       = is_null( $this->getRequestParameter( 'MostrarNumeroLote' ) ) ? 0 : 1;
        $OpeDsctoStockEnGuiaR    = is_null( $this->getRequestParameter( 'OpeDsctoStockEnGuiaR' ) ) ? 0 : 1;
        $UsarCreditoConCuotas    = is_null( $this->getRequestParameter( 'UsarCreditoConCuotas' ) ) ? 0 : 1;
        $CarteraClienteFlag      = intval( $this->getRequestParameter( 'CarteraClienteFlag' ) );
        $MostrarMargenVenta      = intval( $this->getRequestParameter( 'MostrarMargenVenta' ) );
        $AprobacionParaImpGuias  = intval( $this->getRequestParameter( 'AprobacionParaImpGuias' ) );
        $TrabajarModoAlquiler    = intval( $this->getRequestParameter( 'AprobacionParaImpGuias' ) );
        $EnviarCompDirectoSunatFlag  = intval( $this->getRequestParameter( 'EnviarCompDirectoSunatFlag' ) );
        $ModoEntorno             = intval( $this->getRequestParameter( 'ModoEntorno' ) );
        $UsuSecundarioProdUser   = $this->getRequestParameter( 'UsuSecundarioProdUser' );
        $UsuSecundarioProdPass   = $this->getRequestParameter( 'UsuSecundarioProdPass' );
        $UsuSecundarioPruebaUser = $this->getRequestParameter( 'UsuSecundarioPruebaUser' );
        $UsuSecundarioPruebaPass = $this->getRequestParameter( 'UsuSecundarioPruebaPass' );

        $IdClientePorDef        = $this->getRequestParameter( 'IdClientePorDef' ) ? intval( $this->getRequestParameter( 'IdClientePorDef' ) ) : 'null';
        $IdUsuarioAdmin        = $this->getRequestParameter( 'IdUsuarioAdmin' ) ? intval( $this->getRequestParameter( 'IdUsuarioAdmin' ) ) : 'null';
        $EmailEmpresa           = $this->getRequestParameter( 'EmailEmpresa' );
        $FacturaNotasFormatoPDF = $this->getRequestParameter( 'FacturaNotasFormatoPDF' );
        $BoletaNotasFormatoPDF  = $this->getRequestParameter( 'BoletaNotasFormatoPDF' );
        
        $PaisId       = $this->getRequestParameter( 'PaisId' );
        $Departamento = $this->getRequestParameter( 'Departamento' );
        $Provincia    = $this->getRequestParameter( 'Provincia' );
        $Distrito     = $this->getRequestParameter( 'Distrito' );
        
        $LogoFileAncho     = trim( $this->getRequestParameter( 'LogoFileAncho' ) )=="" ? "200" : $this->getRequestParameter( 'LogoFileAncho' );
        $LogoFileAlto      = trim( $this->getRequestParameter( 'LogoFileAlto' ) )==""? "70" : $this->getRequestParameter( 'LogoFileAlto' );
        $LogoBackFileAncho = trim( $this->getRequestParameter( 'LogoBackFileAncho' ) )=="" ? "200" : $this->getRequestParameter( 'LogoBackFileAncho' );
        $LogoBackFileAlto  = trim( $this->getRequestParameter( 'LogoBackFileAlto' ) )==""? "70" : $this->getRequestParameter( 'LogoBackFileAlto' );

        $LogoBackgroundColor    = $this->getRequestParameter( 'LogoBackgroundColor' );
        $NavbarBackgroundColor  = $this->getRequestParameter( 'NavbarBackgroundColor' );
        $SidebarBackgroundColor = $this->getRequestParameter( 'SidebarBackgroundColor' );

        try 
        {
            $o_GSS_CompaniaDP = new GSS_CompaniaDP();
            
            $o_GSS_CompaniaDP->setPaisId( $PaisId );
            $o_GSS_CompaniaDP->setDepartamento( $Departamento );
            $o_GSS_CompaniaDP->setProvincia( $Provincia );
            $o_GSS_CompaniaDP->setDistrito( $Distrito );
            $o_GSS_CompaniaDP->setRuc( $Ruc );
            $o_GSS_CompaniaDP->setDescripcionCorta( $DescripcionCorta );
            $o_GSS_CompaniaDP->setDescripcionLarga( $DescripcionLarga );
            $o_GSS_CompaniaDP->setTelefono1( $Telefono1 );
            //$o_GSS_CompaniaDP->setPlanoUnidadCrianza( $PlanoUnidadCrianza );
            $o_GSS_CompaniaDP->setPaginaWeb( $PaginaWeb );
            $o_GSS_CompaniaDP->setRepresentanteLegal( $RepresentanteLegal );
            $o_GSS_CompaniaDP->setDireccionComun( $DireccionComun );
            $o_GSS_CompaniaDP->setDireccionAdicional( $DireccionAdicional );
            $o_GSS_CompaniaDP->setNotasdeVenta( $NotasdeVenta );
            $o_GSS_CompaniaDP->setNotasdeAlquiler( $NotasdeAlquiler );
            $o_GSS_CompaniaDP->setAfectoIGVFlag( $AfectoIGVFlag );
            $o_GSS_CompaniaDP->setMostrarNumeroLote( $MostrarNumeroLote );
            $o_GSS_CompaniaDP->setOpeDsctoStockEnGuiaR( $OpeDsctoStockEnGuiaR );
            $o_GSS_CompaniaDP->setUsarCreditoConCuotas( $UsarCreditoConCuotas );
            $o_GSS_CompaniaDP->setCarteraClienteFlag( $CarteraClienteFlag );
            $o_GSS_CompaniaDP->setMostrarMargenVenta( $MostrarMargenVenta );
            $o_GSS_CompaniaDP->setAprobacionParaImpGuias( $AprobacionParaImpGuias );
            $o_GSS_CompaniaDP->setTrabajarModoAlquiler( $TrabajarModoAlquiler );
            $o_GSS_CompaniaDP->setEnviarCompDirectoSunatFlag( $EnviarCompDirectoSunatFlag );
            $o_GSS_CompaniaDP->setModoEntorno( $ModoEntorno );
            $o_GSS_CompaniaDP->setUsuSecundarioProdUser( $UsuSecundarioProdUser );
            $o_GSS_CompaniaDP->setUsuSecundarioProdPass( $UsuSecundarioProdPass );
            $o_GSS_CompaniaDP->setUsuSecundarioPruebaUser( $UsuSecundarioPruebaUser );
            $o_GSS_CompaniaDP->setUsuSecundarioPruebaPass( $UsuSecundarioPruebaPass );

            $o_GSS_CompaniaDP->setPorTipoCambio( $PorTipoCambio );
            $o_GSS_CompaniaDP->setDeshabilitarTipoCambio( $DeshabilitarTipoCambio );

            $o_GSS_CompaniaDP->setAfectoRetencionIGVFlag( $AfectoRetencionIGVFlag );
            $o_GSS_CompaniaDP->setAfectoPercepcionIGVFlag( $AfectoPercepcionIGVFlag );
            $o_GSS_CompaniaDP->setEnviarProveedorAutoFlag( ( string ) $EnviarProveedorAutoFlag );
            $o_GSS_CompaniaDP->setDirParaBuscarComprobante( $DirParaBuscarComprobante );

            $o_GSS_CompaniaDP->setIdClientePorDef( $IdClientePorDef );
            $o_GSS_CompaniaDP->setIdUsuarioAdmin( $IdUsuarioAdmin );
            $o_GSS_CompaniaDP->setEmailEmpresa( $EmailEmpresa );
            $o_GSS_CompaniaDP->setFacturaNotasFormatoPDF( $FacturaNotasFormatoPDF );
            $o_GSS_CompaniaDP->setBoletaNotasFormatoPDF( $BoletaNotasFormatoPDF );
            
            $o_GSS_CompaniaDP->setLogoFileAncho( $LogoFileAncho );
            $o_GSS_CompaniaDP->setLogoFileAlto( $LogoFileAlto );
            $o_GSS_CompaniaDP->setLogoBackFileAncho( $LogoBackFileAncho );
            $o_GSS_CompaniaDP->setLogoBackFileAlto( $LogoBackFileAlto );

            $o_GSS_CompaniaDP->setLogoBackgroundColor( $LogoBackgroundColor );
            $o_GSS_CompaniaDP->setNavbarBackgroundColor( $NavbarBackgroundColor );
            $o_GSS_CompaniaDP->setSidebarBackgroundColor( $SidebarBackgroundColor );
            
            //$o_GSS_CompaniaDP->setIdAlmacen( 1 );

            if( !$i_Id )
            {
                $i_Id = GSS_CompaniaFN::recuperarId();
                $s_Codigo = "EMP".str_pad( $i_Id, 2, "0", STR_PAD_LEFT );
                $o_GSS_CompaniaDP->setIdCompania( $i_Id );
                $o_GSS_CompaniaDP->setCodigo( $s_Codigo );
                $o_GSS_CompaniaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_GSS_CompaniaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_GSS_CompaniaDP->setEliminado( -1 );
                $o_GSS_CompaniaDP->setEstado( "A" ); //por defecto
                //$o_GSS_CompaniaDP->setIdAlmacen( 1 );  //por defecto
                $b_Result = $o_GSS_CompaniaDP->save();
            }
            else 
            {
                $o_GSS_CompaniaDP->setIdCompania( ( int ) $i_Id );
                $o_GSS_CompaniaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_GSS_CompaniaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_GSS_CompaniaDP->update();
            }
            if( $b_Result )
            {
                if( isset( $_FILES['filexplorer'] ) )
                {
                    if( $_FILES['filexplorer']['tmp_name'] != "" )
                    {
                        $PATH_UPLOAD_IMAGES_ROUTE    = $_SERVER['DOCUMENT_ROOT']."/images/uploadFiles/";
                        
                        $size_file  = $_FILES['filexplorer']['size']; //: tamano en bytes del archivo recibido
                        $type_file  = $_FILES['filexplorer']['type']; //: tipo mime del archivo, por ejemplo image/gif
                        $name_file  = utilString::eliminar_acento( $_FILES['filexplorer']['name'] ); //: nombre original del archivo
                        $tmp_name   = $_FILES['filexplorer']['tmp_name']; //: nombre del archivo temporal que se utiliza para almacenar en 
                        
                        $s_ext = substr( $name_file, -3 );
                        $name_file = "FILE_ID_".$i_Id.".".$s_ext;
                        
                        $s_DestinoDir = $PATH_UPLOAD_IMAGES_ROUTE.$name_file;
                        $s_DestinoUrl = Constantes::PATH_UPLOAD_FILES_ROUTE.$name_file;
                        if ( copy( $tmp_name, $s_DestinoDir ) ) 
                        {
                            $b_Result = GSS_CompaniaDP::guardarDireccionImagen( $i_Id, $s_DestinoUrl, $s_DestinoDir );
                        }
                    }
                }
            }
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeGridCria()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_AlmacenMastFN() );
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdSucursal" );

        //$o_GridAction->addOrderDefault( GSS_SucursalFN::IdSucursal, true );
        
        $o_GridAction->addRowsToShow( "IdAlmacen", "DescripcionLocal", "IdSucursal", "DescripcionSucursal", "Estado" );
        
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();

        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeAddProd()
    {
        $this->block = $this->getRequestParameter( 'block' );
        $this->i_Id = $this->getRequestParameter( 'i_Id' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->i_Id );
    }
    
    public function executeNvoUniProd()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
            
        $this->block   = $this->getRequestParameter( 'block' );
        $this->i_Id    = $this->getRequestParameter( 'i_Id' );
        $this->i_IdDet = $this->getRequestParameter( 'i_IdDet' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->i_Id );
        
        $o_DefaultBN = new GSS_SucursalBN();
		$o_DefaultBN->setEstado('A');
		$this->o_DefaultBN = $o_DefaultBN;
        
		$this->a_ALM_AlmacenMast = array();
		
        if( $this->s_TipoProc == "upd" )
        {
            $o_DefaultFN = new GSS_SucursalFN();
            $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_IdDet );
            
            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastFN->setIdSucursal( $this->o_DefaultBN->getIdSucursal() );
            $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        }
        //pr( $this->o_DefaultBN );
    }
    
    public function executeSaveUniProd()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $i_IdDet    = $this->getRequestParameter( 'i_IdDet' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $Descripcion           = $this->getRequestParameter( 'Descripcion' );
        $CuentaContableDefecto = $this->getRequestParameter( 'CuentaContableDefecto' );
        $IdAlmacen             = $this->getRequestParameter( 'IdAlmacen' );
        $Telefono              = $this->getRequestParameter( 'Telefono' );
        $Longitud              = $this->getRequestParameter( 'Longitud' );
        $Latitud               = $this->getRequestParameter( 'Latitud' );
        $Estado                = $this->getRequestParameter( 'Estado' );
        $Direccion             = $this->getRequestParameter( 'Direccion' );

        $PaisId                = $this->getRequestParameter( 'PaisId' );
        $Departamento          = $this->getRequestParameter( 'Departamento' );
        $Provincia             = $this->getRequestParameter( 'Provincia' );
        $Distrito              = $this->getRequestParameter( 'Distrito' );

        $EstaExoneradoIGV      = $this->getRequestParameter( 'EstaExoneradoIGV' );

        $RutaProveedorExt      = $this->getRequestParameter( 'RutaProveedorExt' );
        $TokenProveedorExt     = $this->getRequestParameter( 'TokenProveedorExt' );

        try 
        {
            $o_DefaultDP = new GSS_SucursalDP();
            $o_DefaultDP->setIdCompania( ( int ) $i_Id );
            $o_DefaultDP->setDescripcion( $Descripcion );
            $o_DefaultDP->setCuentaContableDefecto( $CuentaContableDefecto );
            $o_DefaultDP->setTelefono( $Telefono );
            $o_DefaultDP->setLongitud( $Longitud );
            $o_DefaultDP->setLatitud( $Latitud );
            $o_DefaultDP->setEstado( $Estado );
            $o_DefaultDP->setDireccion( $Direccion );
            $o_DefaultDP->setIdAlmacen( $IdAlmacen );
            $o_DefaultDP->setPaisId( $PaisId );
            $o_DefaultDP->setDepartamento( $Departamento );
            $o_DefaultDP->setProvincia( $Provincia );
            $o_DefaultDP->setDistrito( $Distrito );
            $o_DefaultDP->setEstaExoneradoIGV( intval( $EstaExoneradoIGV ) );
            $o_DefaultDP->setRutaProveedorExt( $RutaProveedorExt );
            $o_DefaultDP->setTokenProveedorExt( $TokenProveedorExt );
            if( $s_TipoProc == "nvo" )
            {
                //INSERT
                $i_IdGen = GSS_SucursalFN::recuperarId( $i_Id );
                $o_DefaultDP->setIdSucursal( ( int ) $i_IdGen );
                $o_DefaultDP->setIp( $_SERVER['REMOTE_ADDR'] );
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->save();
                $i_IdDet = $i_IdGen;
            }
            else 
            {
                //UPDATE
                $o_DefaultDP->setIdSucursal( ( int ) $i_IdDet );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->update();
            }
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception );
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se realizo ningun cambio.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeGridProd()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new GSS_SucursalFN() );
        
        $o_GridAction->addAssignFilter( "IdCompania" );

        $o_GridAction->addOrderDefault( GSS_SucursalFN::CuentaContableDefecto, true );
        
        $o_GridAction->addRowsToShow( "IdSucursal", "Descripcion", "Telefono", "CuentaContableDefecto", "Estado", "CantAlmacen", "ExoneradorIGVDesc" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();

        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeShowUniProd()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block   = $this->getRequestParameter( 'block' );
        $this->i_Id    = $this->getRequestParameter( 'i_Id' );
        $this->i_IdDet = $this->getRequestParameter( 'i_IdDet' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->i_Id );
        
        $o_DefaultFN = new GSS_SucursalFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_IdDet );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdSucursal( $this->o_DefaultBN->getIdSucursal() );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
    }
    
    public function executeDeleteUniProd()
    {
        $noEliminar = 0;
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $i_IdDet    = $this->getRequestParameter( 'i_IdDet' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        try 
        {
            $o_DefaultDP = new GSS_SucursalDP();
            $o_DefaultDP->setIdSucursal( ( int ) $i_IdDet );
            $o_DefaultDP->setEstado( "I" );
            $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_DefaultDP->update();

			/*
		    $i_CantidadAlmacen =  ALM_AlmacenMastFN::recuperarCantidadAlmacen( $i_Id, $i_IdDet );
			if( $i_CantidadAlmacen > 0 )
			{
				$this->b_Result       = false;
				$noEliminar           = 1;
				throw new Exception( "No debe tener Almacenes asociados en estado activo." );
			}
			if( $noEliminar == 0 )
			{
				$b_Result = $o_DefaultDP->delete();
			}
            */
			$a_Rs['error']   = false;
		}
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $i_Id );
    }

    public function executeAddeditCaja()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $s_IdCompania = $this->getRequestParameter( 'IdCompania' );
        $s_IdSucursal = $this->getRequestParameter( 'IdSucursal' );
        $s_Caja = $this->getRequestParameter( 'IdCaja' );

        $this->s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        $this->s_Control = $this->getRequestParameter( 'Control' );

        $o_GSS_CompaniaBN = GSS_CompaniaFN::buscarCompania( $s_IdCompania );
        $o_GSS_SucursalBN = GSS_SucursalFN::selectOne( $s_IdSucursal );

        $this->s_DescripcionCorta = $o_GSS_CompaniaBN->getDescripcionCorta();
        $this->s_DescripcionSucu  = $o_GSS_SucursalBN->getDescripcion();

        $i_IdCaja = FCO_CajaDP::recuperarId();
        $this->s_DescripcionNuevoCaja = "CAJA ".$i_IdCaja;

        $this->s_Titulo = "NUEVO CAJA";

        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "EDITAR CAJA";

            $o_FCO_CajaFN = new FCO_CajaFN();
            $o_FCO_CajaBN = $o_FCO_CajaFN->selectByPK( $s_Caja );

            $this->s_DescripcionNuevoCaja = $o_FCO_CajaBN->getDescripcion();
        }

        if( $this->getRequestParameter( 'Control' ) )
        {
            $s_Estado = $this->getRequestParameter( 'Estado' );

            $o_FCO_CajaDP = new FCO_CajaDP();
            $o_FCO_CajaDP->setIdCompania( ( int ) $s_IdCompania );
            $o_FCO_CajaDP->setIdSucursal( ( int ) $s_IdSucursal );

            $o_FCO_CajaDP->setEstado( $s_Estado );

            $s_Descripcion = $this->getRequestParameter( 'Descripcion' );

            $o_FCO_CajaDP->setDescripcion( $s_Descripcion );

            if( $this->s_TipoProc == "nvo" )
            {
                $o_FCO_CajaDP->setIdCaja( $i_IdCaja );
                $o_FCO_CajaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_FCO_CajaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_FCO_CajaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_FCO_CajaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_FCO_CajaDP->save();
            }
            else
            {
                $o_FCO_CajaDP->setIdCaja( ( int ) $s_Caja );
                $o_FCO_CajaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_FCO_CajaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_FCO_CajaDP->update();
            }

        }
    }

    public function executeBuscarHistorial()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->i_Id = $this->getRequestParameter( 'i_Id' );

        /*
        $i_OrdId  = intval( $this->getRequestParameter( 'ord_id' ) );
        $s_OrdNum = $this->getRequestParameter( 'ord_num' );

        $this->VTA_OrdenBN = VTA_OrdenFN::findOrdenByNum( $s_OrdNum );
        */

        $o_RegistroHistorialFN = new RegistroHistorialFN();
        $o_RegistroHistorialFN->setIdCompania( $this->i_Id );
        //$o_RegistroHistorialFN->setIdDocumento( $i_OrdId );
        $o_RegistroHistorialFN->addOrderBy( RegistroHistorialFN::FechaCreacion, false );
        //$o_RegistroHistorialFN->setModulo( "COTIZACION_DET" );
        $this->a_RegistroHistorial = $o_RegistroHistorialFN->select( 100 );
    }
}