<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<?php /** @var VTA_DocumentoDetalleBN[] $a_VTA_DocumentoDetalle */ ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/fixedheader/3.1.7/css/fixedHeader.dataTables.min.css" />

<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.7/js/dataTables.fixedHeader.min.js"></script>

<style type="text/css">
    .ui-dialog .ui-dialog-titlebar-close
    {
        position: absolute;
        right: .3em;
        top: 50%;
        width: 20px;
        margin: -10px 0 0 0;
        padding: 1px;
        height: 20px;
        background-position: -96px -128px;
        /*background-image: url("images/ui-icons_056b93_256x240.png");*/
        background-image: url("<?=Constantes::ROOT_DIR_APP?>web/css/jquery/themes/start_1.12.1/images/ui-icons_056b93_256x240.png");
    }
</style>

<style type="text/css">
/*
#example_wrapper .row
{
    margin-right: 0;
    margin-left: 0;
}
table.dataTable tbody tr:hover 
{
   background-color: #DAE6FE !important;;
}
*/
.table td, .table th 
{
    /*padding: 8px;*/
    font-size: 13px;
    vertical-align: middle;
}
th { white-space: nowrap; }
</style>

<style type="text/css">
.buttonpr.micro 
{
    margin: 0 0 0.5rem 0;
    padding: 0.25em 0.25rem;
    font-size: 0.6rem;
    font-weight: bold;
    line-height: 1;
    color: #ffffff; 
}

.buttonpr.success 
{
    background-color: #619518;
    /*color: #0a0a0a;*/
}

.buttonpr.alert 
{
    background-color: #BE3047;
    /*color: #fefefe;*/
}

.buttonpr 
{
    display: inherit;
    vertical-align: middle;
    margin: 0 0 1rem 0;
    font-family: inherit;
    padding: 0.85em 1em;
    -webkit-appearance: none;
    border: 1px solid transparent;
    border-radius: 14px;
    transition: background-color 0.25s ease-out, color 0.25s ease-out;
    font-size: 0.9rem;
    line-height: 1;
    text-align: center;
    cursor: pointer;
    background-color: #0078EB;
    color: #fefefe;
}
</style>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0">LISTA GUIA DE REMISION</h4>
        </div>
    </div>
</div>

<div class="marco">
    <div class="table-responsive">
        <table class="table table-borderless" style="margin-bottom: 0px; line-height: 0.5; padding: .50rem; ">
            <tbody>
                <tr>
                    <th class="text-nowrap" scope="row">Nro Documento:</th>
                    <td class="text-nowrap" style="color: #fc6d00;"><?=$o_VTA_DocumentoBN->getDocumentoTipoSerieNumero()  ?></td>
                    <th class="text-nowrap" scope="row">Fecha:</th>
                    <td class="text-nowrap"><?=str_pad( $o_VTA_DocumentoBN->getFechaDocumento(), 10, "0", STR_PAD_LEFT )?></td>
                    <th class="text-nowrap" scope="row">Cliente:</th>
                    <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getClienteNombre();?></td>
                    <th class="text-nowrap" scope="row">Cliente Documento:</th>
                    <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getClienteTipoDoc();?> <?=$o_VTA_DocumentoBN->getClienteRUC();?></td> 
                </tr>
                <tr>
                    <th class="text-nowrap" scope="row">Cotizaci&oacute;n:</th>
                    <td class="text-nowrap" style="color: #fc6d00;" ><?=$o_VTA_OrdenBN->getOrdenNum();?></td>
                    <th class="text-nowrap" scope="row">Tipo Comp:</th>
                    <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getTipoOrdenComercialDesc()?> - <?=$o_VTA_OrdenBN->getTipoClasificacionDesc()?></td>
                    <th class="text-nowrap" scope="row">Almacen Despacho:</th>
                    <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getObjectAlmacenDespacho()->getDescripcionLocal()?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<div class="dropdown-divider"></div>

<div id="content_alert" style=""></div>

<form id="form1" name="form1" method="POST" onsubmit=""  enctype="multipart/form-data">
    <input type="hidden" name="Control" id="Control" value="1"/>
    <input type="hidden" name="TipoProceso" id="TipoProceso" value="list"/>
    <input type="hidden" name="IdMovimientoSerie" id="IdMovimientoSerie" value="<?=$s_IdMovimientoSerie?>"/>
    <input type="hidden" name="GuiaRemisionId" id="GuiaRemisionId" value=""/>

    <?php $f_CantidadControl = 0; ?>
    <?php if( !$b_ControlProdFinal ){ ?>

        <div class="table-responsive">
            <table class="table table-sm table-bordered table-hover" id="example">
                <thead id="">
                <tr class="table-primary">
                    <!--<th width="1%"  align="center" ><b>No</b></th>-->
                    <th width="8%" style="text-align: center;" ><b>C&oacute;digo</b></th>
                    <th width="35%" align="left"><b>Descripci&oacute;n</b></th>
                    <th width="8%" style="text-align: center;" ><b>Stock</b></th>
                    <!--<th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Peso Unit</b></th>
                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Peso Total</b></th>-->
                    <th width="15%" style="text-align: center;" ><b>Cant Pedida</b></th>
                    <th width="15%" style="text-align: center;" ><b>Cant Entregada</b></th>
                    <th width="15%" style="text-align: center;" ><b>Cant x Entregar</b></th>
                </tr>
                </thead>

                <tbody id="content_all_row">
                <?php $f_MontoTotal = 0.00 ?>
                <?php foreach ( $a_VTA_DocumentoDetalle as $i_Key => $o_VTA_DocumentoDetalleBN ){ ?>
                    <?php
                    if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() != VTA_DocumentoDetalleBN::TIPO_DETALLE )
                    {
                        continue;
                    }
                    $s_IdItem = $o_VTA_DocumentoDetalleBN->getItemCodigo();
                    $s_InputId = "input_".$i_Key;
                    $f_CantidadControl = $f_CantidadControl + ( $o_VTA_DocumentoDetalleBN->getCantidadPedida() - $o_VTA_DocumentoDetalleBN->getCantidadRecibida() );
                    $f_PesoUnitario = $o_VTA_DocumentoDetalleBN->getObjectItem()->getPesoGramos();
                    $f_StockFisico = $o_VTA_DocumentoDetalleBN->getStockFisico();
                    ?>
                    <tr class="content_row">
                        <!--<td align="center"><?/*=( $i_Key + 1 )*/?></td>-->
                        <td align="center"><?=$s_IdItem?></td>
                        <td align="left"><?=$o_VTA_DocumentoDetalleBN->getDescripcion()?></td>
                        <td align="center" <?php if( !$f_StockFisico ){ ?> style="color: red;"<?php } ?> ><b><?=$f_StockFisico?></b></td>
                        <!--<td align="center"><?/*= number_format( $f_PesoUnitario, 2 )*/?></td>-->
                        <!--<td align="center"><?/*=number_format( $f_PesoUnitario * $o_VTA_DocumentoDetalleBN->getCantidadPedida(), 2 )*/?></td>-->
                        <td align="center"><?=$o_VTA_DocumentoDetalleBN->getCantidadPedida()?></td>
                        <td align="center"><?=intval( $o_VTA_DocumentoDetalleBN->getCantidadRecibida() )?></td>
                        <td align="center"><?=($o_VTA_DocumentoDetalleBN->getCantidadPedida()-$o_VTA_DocumentoDetalleBN->getCantidadRecibida())?></td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>

    <?php }else{ ?>

        <?php foreach ( $o_VTA_OrdenBN->getArrayDetallesFinal() as $i_Key => $o_VTA_ProductoFinalBN ){ ?>

            <div class="dropdown-divider"></div>


            <div class="card" style="width: 17rem; border-bottom: 0px;">
                <div class="card-header" style="border-bottom: 0px;"><?=$o_VTA_ProductoFinalBN->getItemTipoClase()==1?"ENCOFRADO":"ANDAMIO"?></div>
            </div>
            <div class="table-responsive">
                <table class="table table-sm table-bordered table-hover">
                    <thead class="thead-light">
                    <tr>
                        <th width="2%"  style="text-align: center;" scope="col"><b>No</b></th>
                        <th width="8%"  style="text-align: center;" scope="col"><b>C&oacute;digo</b></th>
                        <th width="25%" align="" scope="col"><b>Descripci&oacute;n</b></th>
                        <th width="8%"  style="text-align: center;" scope="col"><b>Cant</b></th>
                        <th width="4%"  align="center" scope="col">&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody id="">
                    <tr>
                        <th style="text-align: center;" scope="row"><?=$o_VTA_ProductoFinalBN->getSecuencia()?></th>
                        <td align="center"><?=$o_VTA_ProductoFinalBN->getIdItem()?></td>
                        <td align="" id=""><?=$o_VTA_ProductoFinalBN->getDetalleDescripcion()?></td>
                        <td align="center"><?=$o_VTA_ProductoFinalBN->getCantidad()?></td>
                        <td align="center" nowrap="nowrap">&nbsp;</td>
                    </tr>
                    <tr>
                        <td colspan=""> &nbsp; </td>
                        <td colspan="7">
                            <table class="table table-sm table-bordered table-hover">
                                <thead class="thead-light">
                                <tr>
                                    <th width="2%"  style="text-align: center;" scope="col"><b>No</b></th>
                                    <th width="8%"  style="text-align: center;" scope="col"><b>C&oacute;digo</b></th>
                                    <th width="25%" align="left" ><b>Descripci&oacute;n</b></th>
                                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Stock</b></th>
                                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Peso Unit</b></th>
                                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Peso Total</b></th>
                                    <th width="10%" style="text-align: center;" ><b>Cantidad Pedida</b></th>
                                    <th width="10%" style="text-align: center;" ><b>Cantidad Entregada</b></th>
                                </tr>
                                </thead>
                                <tbody id="">
                                <?php foreach ( VTA_ProductoFinalDetFN::selectAll( $o_VTA_ProductoFinalBN->getProFinalId() ) as $i_Key => $o_VTA_ProductoFinalDetBN ){ ?>
                                    <?php
                                    $s_InputId = "input_".$i_Key;
                                    $f_CantidadControl = $f_CantidadControl + ( $o_VTA_ProductoFinalDetBN->getCantidad() - $o_VTA_ProductoFinalDetBN->getCantidadRecibida() );
                                    $f_StockFisico = $o_VTA_ProductoFinalDetBN->getStockFisico();
                                    ?>
                                    <tr>
                                        <th style="text-align: center;" scope="row"><?=$o_VTA_ProductoFinalDetBN->getSecuencia()?></th>
                                        <td align="center"><?=$o_VTA_ProductoFinalDetBN->getIdItem()?></td>
                                        <td align="" id=""><?=$o_VTA_ProductoFinalDetBN->getDetalleDescripcion()?></td>
                                        <td align="center" <?php if( !$f_StockFisico ){ ?> style="color: red;"<?php } ?> ><b><?=$f_StockFisico?></b></td>
                                        <td align="center"><?=number_format( $o_VTA_ProductoFinalDetBN->getPesoUnitario(), 2 )?></td>
                                        <td align="center"><?=number_format( $o_VTA_ProductoFinalDetBN->getPesoTotal(), 2 )?></td>
                                        <td align="center"><?=$o_VTA_ProductoFinalDetBN->getCantidad()?></td>
                                        <td align="center"><?=$o_VTA_ProductoFinalDetBN->getCantidadRecibida()?></td>
                                    </tr>
                                <?php } ?>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>

        <?php } ?>

    <?php } ?>

    <div class="dropdown-divider"></div>

    <div class="table-responsive">
        <!-- <table class="table table-striped table-bordered" style="width:100%" id="example" > -->
        <table class="table table-sm table-bordered table-hover" id="example">
            <thead id="">
                <tr class="table-primary">
                    <th width="1%"  class="text-center" ><b>No</b></th>
                    <th width="20%" class="text-center"  ><b>Nro Guia</b></th>
                    <th width="10%" class="text-center" ><b>Fecha</b></th>
                    <th width="15%" class="text-center" ><b>Doc Referencia</b></th>
                    <th width="15%" class="text-center" ><b>Estado</b></th>
                    <!--<th width="15%" class="text-center" ><b>Estado Sunat </b></th>-->
                    <th width="5%" align="center" >&nbsp;</th>
                    <th width="5%" align="center" >&nbsp;</th>
                    <!--<th width="5%" align="center" >&nbsp;</th>-->
                </tr>
            </thead>
            
            <tbody id="content_all_row">
                <?php $f_MontoTotal = 0.00 ?>
                <?php foreach ( $a_SR_GuiaRemisionH as $i_Key => $o_SR_GuiaRemisionHBN ){ ?>
                    <?php
                    $s_InputId = "input_".$i_Key;
                    $s_ConcatIdTrx = $o_SR_GuiaRemisionHBN->getIdCompania()."_".$o_SR_GuiaRemisionHBN->getIdTipoDocumento()."_".$o_SR_GuiaRemisionHBN->getIdNumeroDocumento();
                    ?>
                <tr class="content_row">
                    <td align="center"><?=( $i_Key + 1 )?></td>
                    <td align="center"><?=$o_SR_GuiaRemisionHBN->getGuiaSerie()?>-<?=$o_SR_GuiaRemisionHBN->getGuiaNumero()?></td>
                    <td align="left"><?=$o_SR_GuiaRemisionHBN->getGuiaFecha()?></td>
                    <td align="center"><?=$o_SR_GuiaRemisionHBN->getReferenciaTipo()?><?=$o_SR_GuiaRemisionHBN->getReferenciaNumero()?></td>
                    <td align="center"><?=$o_SR_GuiaRemisionHBN->getEstadoDesc()?></td>
                    <!--<td align="center"><?/*=$o_SR_GuiaRemisionHBN->getSunatEstadoDesc()*/?></td>-->
                    <td align="center"> 
                        <?php if( $o_SR_GuiaRemisionHBN->getEnlaceDelPdf() ){ ?>
                        <label class='buttonpr micro alert' onclick="redirectFunction('<?=$o_SR_GuiaRemisionHBN->getEnlaceDelPdf()?>')">PDF</label>
                        <?php }else{ ?>
                            <?php if( myUser::getUser()->getObjectCompania()->getEnviarCompDirectoSunatFlag() ){ ?>
                                <label class='buttonpr micro alert' onclick="redirectFunction('<?=buildUrlComplet( "alm.php/transporte/printGuiaPDF", "Id=".$o_SR_GuiaRemisionHBN->getGuiaRemisionId() )?>')">PDF</label>
                            <?php } ?>
                        <?php } ?>
                    </td>
                    <td align="center">
                        <?php if( $o_SR_GuiaRemisionHBN->getIdNumeroDocumento() ){ ?>
                        <label class='buttonpr micro' onclick="redirectFunction('<?= buildUrlComplet( "alm.php/transacciones/viewdel", "s_TipoProc=shw&i_Id=".$s_ConcatIdTrx )?>')">TRX</label>
                        <?php } ?>
                    </td>
                    <!--<td align="center">
                        <?php /*if( $o_SR_GuiaRemisionHBN->getEstado() == SR_GuiaRemisionHBN::ESTADO_COMPLETADO ){ */?>
                            <?php /*if( $o_SR_GuiaRemisionHBN->getEstadoSunat() == SR_GuiaRemisionHBN::ESTADO_SUNAT_PENDIENTE || $o_SR_GuiaRemisionHBN->getEstadoSunat() == SR_GuiaRemisionHBN::ESTADO_SUNAT_ERROR ){ */?>
                                <button class="btn btn-primary btn-sm" type="button" onclick="enviarDocSunat( '<?/*=$o_SR_GuiaRemisionHBN->getGuiaRemisionId()*/?>' )">Enviar</button>
                            <?php /*} */?>
                            <?php /*if( $o_SR_GuiaRemisionHBN->getEstadoSunat() == SR_GuiaRemisionHBN::ESTADO_SUNAT_ENVIADO || $o_SR_GuiaRemisionHBN->getEstadoSunat() == SR_GuiaRemisionHBN::ESTADO_SUNAT_ERROR ){ */?>
                                <button class="btn btn-primary btn-sm" type="button" onclick="anularGuiaRemision( '<?/*=$o_SR_GuiaRemisionHBN->getGuiaRemisionId()*/?>' )">Anular</button>
                            <?php /*} */?>
                        <?php /*} */?>
                        <?php /*if( $o_SR_GuiaRemisionHBN->getEstado() == SR_GuiaRemisionHBN::ESTADO_ANULADO ){ */?>
                            <button class="btn btn-primary btn-sm" type="button" onclick="imprimirGuiaRemision( '<?/*=$s_IdMovimientoSerie*/?>', '<?/*=$o_SR_GuiaRemisionHBN->getGuiaRemisionId()*/?>' )">Re-enviar</button>
                        <?php /*} */?>
                    </td>-->
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</form>

<?=crearFuentePopupIframe( array( "div_id"=>"dialog4", "iframe_id"=>"myIframe4", "popup_title"=>"", "modal"=>true ) )?>

<script type="text/javascript">
    imprimirGuiaRemision = function( Id, IdGuia )
    {
        var s_param_ajax = "TipoProceso/DE/IdMovimientoSerie/" + Id + "/GuiaRemisionId/" + IdGuia;
        $( '#myIframe4' ).attr( 'src', '<?=buildUrl( 'transporte/printGuiaRem' )?>' + s_param_ajax );
        $( '#dialog4' ).dialog( 'open' );
    }

    enviarDocSunat = function( GuiaRemisionId )
    {
        x = confirm( "Esta seguro de enviar la Guia?" );
        if( x )
        {
            blockContent( 'form1' );
            var strFormSerialize = "GuiaRemisionId=" + GuiaRemisionId;
            executeAjaxJson
            (
                "<?php echo buildUrl( 'transporte/enviarSunatGuiaRem' ) ?>",
                strFormSerialize,
                function( o_json )
                {
                    pr( o_json );
                    unBlockContent( "form1" );
                    if( o_json.error )
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        return false;
                    }
                    if( o_json.enlace_pdf != "" )
                    {
                        window.open( o_json.enlace_pdf, '_blank', '' );
                        parent.realizarNuevaBusqueda();
                        parent.closeWindow();
                    }
                    else
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', "No se encontro link para la Guia." );
                        return false;
                    }
                }
            );
        }
    }

    closeWindow = function()
    {
        $( '#dialog4' ).dialog( 'close' );
    }

    realizarNuevaBusqueda = function()
    {
        location.reload();
    }

redirectFunction = function( link )
{
    window.open( link, "_BLANK" )
}

anularGuiaRemision = function( id )
{
    x = confirm( "Esta seguro de Anular la Guia seleccionada?" );
    if( x )
    {
        $( "#TipoProceso" ).val( "anular" );
        $( "#GuiaRemisionId" ).val( id );
    
        $( "#form1" ).submit();
    }
}

configurarDataTable = function()
{
    $( '#example' ).DataTable
    (
        {
            language:       { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
            responsive:     false,
            searching:      false,
            info:           false,
            lengthChange:   false,
            paging:         false,
            dom:            'lrtip'/*,
            fixedHeader: 
            {
                header: true,
                footer: true
            }*/
        }
    );
}

setTimeout
(
    function () 
    {
        configurarDataTable();
    }, 
    1000
);
</script>