<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/fixedheader/3.1.7/css/fixedHeader.dataTables.min.css" />

<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.7/js/dataTables.fixedHeader.min.js"></script>

<script type="text/javascript">
    reEnviarGuia = function()
    {
        x = confirm( "Esta seguro de imprimir la Guia?" );
        if( x )
        {
            blockContent( 'form1' );
            var strFormSerialize = $( '#form1' ).serialize()+'&GuiaRemisionId=<?=$s_GuiaRemisionId?>';
            executeAjaxJson
            (
                "<?php echo buildUrl( 'transporte/reEnviarGuiaRem' ) ?>",
                strFormSerialize,
                function( o_json )
                {
                    unBlockContent( "form1" );
                    if( o_json.error )
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        return false;
                    }
                    if( o_json.enlace_pdf != "" )
                    {
                        window.open( o_json.enlace_pdf, '_blank', '' );
                        parent.realizarNuevaBusqueda();
                        parent.closeWindow();
                    }
                    else
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', "No se encontro link para la Guia." );
                        return false;
                    }
                }
            );
        }
    }
ImprimirGuiaFormatoPDF = function()
{
    //validacion
	var elms = $( "#content_grid" ).find( ":input[type=text]" );

    var b_Control = true;
    var f_SumaCantidad = 0;
    
    $.each
    (
        elms, function( index, elm )
        {
            if( $( elm ).val().trim() != "" )
            {
            	var s_IdItem      = $( elm ).attr( "iditem" );
            	var f_StockFisico = parseFloat( $( elm ).attr( "stockfis" ) );
                var f_Cantidad    = parseFloat( $( elm ).val() );
                
                if( f_Cantidad > 0 )
                {
                    if( f_Cantidad > f_StockFisico )
                    {
                    	showAlertBootStrap( 'content_alert', 'alert-danger', "La cantidad ingresa para el producto ["+s_IdItem+"] es mayor al Stock Fisico." );
                    	b_Control = false;
                    }
                    f_SumaCantidad = f_SumaCantidad + f_Cantidad;
                }
            }
            pr( f_StockFisico + " - " + f_Cantidad );
        }
    );

    if( f_SumaCantidad <= 0 )
    {
    	showAlertBootStrap( 'content_alert', 'alert-danger', "Para generar Guia de Remision es necesario ingresar una cantidad." );
    	b_Control = false;
    }

    if( b_Control )
    {
        x = confirm( "Esta seguro de imprimir la Guia?" );
        if( x )
        {
        	blockContent( 'form1' );
            var strFormSerialize = $( '#form1' ).serialize();
            //window.open('<?=buildUrl( 'transporte/generarGuiaRem' )?>?' + strFormSerialize, '_blank', '');
            executeAjaxJson
            ( 
                "<?php echo buildUrl( 'transporte/generarGuiaRem' ) ?>", 
                strFormSerialize,
                function( o_json )
                {
                    pr( o_json );
                    unBlockContent( "form1" );
                    if( o_json.error )
                    {
                        if( o_json.mensaje_error == "ACTUALIZAR" )
                        {
                            showAlertBootStrap( 'content_alert', 'alert-danger', "La cantidad pedida es igual a la cantidad entregada." );
                            setTimeout(
                                function(  )
                                {
                                    parent.realizarNuevaBusqueda();
                                    parent.closeWindow();
                                },
                                2000
                            )
                            return false;
                        }
                    	showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        //mostrarMensajeError(  );
                        return false;
                    }
                    if( o_json.enlace_pdf != "" )
                    {
                        window.open( o_json.enlace_pdf, '_blank', '' );
                        parent.realizarNuevaBusqueda();
                        parent.closeWindow();
                    }
                    else
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', "No se encontro link para la Guia." );
                        return false;
                    }
                } 
            );
        }
    }
    return false;
}
</script>

<style type="text/css">
/*
#example_wrapper .row
{
    margin-right: 0;
    margin-left: 0;
}
table.dataTable tbody tr:hover 
{
   background-color: #DAE6FE !important;;
}
*/
.table td, .table th 
{
    /*padding: 8px;*/
    font-size: 13px;
    padding: .5rem;
}
th { white-space: nowrap; }

fieldset.scheduler-border 
{
    border: 1px solid #ccc !important;
    padding: 0 0.5em 0.5em 0.5em !important;
    margin: 0 0 0.5em 0 !important;
    -webkit-box-shadow: 0px 0px 0px 0px #000;
    box-shadow: 0px 0px 0px 0px #000;
}

legend.scheduler-border 
{
    font-size: 1em !important;
    font-weight: bold !important;
    text-align: left !important;
    width: auto;
    padding: 0 5px;
    border-bottom: none;
    margin-bottom: 0;    
}

</style>

<div class="marco">
    <div class="table-responsive">
        <table class="table table-borderless" style="margin-bottom: 0px; line-height: 1; padding: .50rem; ">
            <tbody>
                <tr>
                    <th class="text-nowrap" scope="row">Nro Documento:</th>
                    <td class="text-nowrap" style="color: #fc6d00;"><?=$o_VTA_DocumentoBN->getDocumentoTipoSerieNumero()  ?></td>
                    <th class="text-nowrap" scope="row">Fecha:</th>
                    <td class="text-nowrap"><?=substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 )?></td>
                    <th class="text-nowrap" scope="row">Cliente:</th>
                    <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getClienteNombre();?></td>
                    <th class="text-nowrap" scope="row">Cliente Documento:</th>
                    <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getClienteTipoDoc();?> <?=$o_VTA_DocumentoBN->getClienteRUC();?></td> 
                </tr>
                <tr>
                    <th class="text-nowrap" scope="row">Punto Partida:</th>
                    <td  colspan="3"><?=$o_GSS_SucursalBN->getDireccion();?></td>
                    <th class="text-nowrap" scope="row">Tipo Comp:</th>
                    <td class="text-nowrap" style="color: #fc6d00;"><?=$o_VTA_OrdenBN->getTipoOrdenComercialDesc()?> - <?=$o_VTA_OrdenBN->getTipoClasificacionDesc()?></td>
                    <th class="text-nowrap" scope="row">Almacen Despacho:</th>
                    <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getObjectAlmacenDespacho()->getDescripcionLocal()?></td>
                </tr>
                <tr>
                    <th class="text-nowrap" scope="row">Punto Llegada:</th>
                    <td class="text-nowrap" colspan="3"><?=$o_VTA_DocumentoBN->getClienteDireccion();?></td>
                    <th class="text-nowrap" scope="row">Cotizaci&oacute;n:</th>
                    <td class="text-nowrap" style="color: #fc6d00;" ><?=$o_VTA_OrdenBN->getOrdenNum();?></td>
                    <th class="text-nowrap" scope="row">Proyecto:</th>
                    <td class="text-nowrap" style="color: #fc6d00;"><?=$o_VTA_PrsProyectosBN->getNombreProyecto()  ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<div class="dropdown-divider"></div>
<div id="content_alert" style=""></div>

<?php $f_CantidadControl = 0; ?>

<script type="text/javascript">
calcularPesoTotal = function()
{
    var a_elm = $( "#form1" ).find( "input[name='Cantidad[]']" );
    var SumaPesoTotal = 0;
    $.each
    (
        a_elm, function( index, item )
        {
            var IdItem            = $( item ).attr( "iditem" );
            var CantidadTotal     = parseFloat( $( item ).val() );
            var PesoUnitario      = parseFloat( $( item ).attr( "peso" ) );
            var CantidadRecibido  = parseFloat( $( item ).attr( "cantrec" ) );
            
            if( CantidadTotal > CantidadRecibido )
            {
                $( item ).val( CantidadRecibido );
                CantidadTotal = CantidadRecibido;
                showAlertBootStrap( 'content_alert', 'alert-danger', "La cantidad ingresa para el producto ["+IdItem+"] es mayor a lo permitido." );
            }
            
            SumaPesoTotal = SumaPesoTotal + redondear( CantidadTotal * PesoUnitario, 2 );
        }
    );
    $( "#SumaPesoTotal" ).val( number_format( SumaPesoTotal, 2 ) );
}
</script>

<form id="form1" name="form1" method="POST" onsubmit="return ImprimirGuiaFormatoPDF();"  enctype="multipart/form-data">
    <input type="hidden" name="TipoProceso" value="<?=$s_TipoProceso?>"/>
    <input type="hidden" name="IdRuta" value="<?=$s_IdRuta?>"/>
    <input type="hidden" name="IdRutaLinea" value="<?=$s_IdRutaLinea?>"/>
    <input type="hidden" name="IdMovimientoSerie" value="<?=$s_IdMovimientoSerie?>"/>
    <input type="hidden" name="IdTransferencia" value="<?=$s_IdTransferencia?>"/>
    
    <input type="hidden" name="ControlProdFinal" value="<?=$b_ControlProdFinal?>"/>
    
    <div id="content_grid">
    
    <?php if( !$b_ControlProdFinal ){ ?>
    
    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover" id="example">
            <thead id="">
                <tr class="table-primary">
                    <!--<th width="1%"  align="center" ><b>No</b></th>-->
                    <th width="8%" align="center" ><b>C&oacute;digo</b></th>
                    <th width="35%" align="left"><b>Descripci&oacute;n</b></th>
                    <th width="8%" align="center" ><b>Stock</b></th>
                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Peso Unit</b></th>
                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Peso Total</b></th>
                    <th width="15%" align="center" ><b>Cant Pedida</b></th>
                    <th width="15%" align="center" ><b>Cant Entregada</b></th>
                    <th width="15%" align="center" ><b>Cant x Entregar</b></th>
                </tr>
            </thead>
            
            <tbody id="content_all_row">
                <?php $f_MontoTotal = 0.00 ?>
                <?php foreach ( $a_VTA_DocumentoDetalle as $i_Key => $o_VTA_DocumentoDetalleBN ){ ?>
                    <?php
                    if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() != VTA_DocumentoDetalleBN::TIPO_DETALLE )
                    {
                        continue;
                    }
                    $s_IdItem = $o_VTA_DocumentoDetalleBN->getItemCodigo();
                    $s_InputId = "input_".$i_Key;
                    $f_CantidadControl = $f_CantidadControl + ( $o_VTA_DocumentoDetalleBN->getCantidadPedida() - $o_VTA_DocumentoDetalleBN->getCantidadRecibida() );
                    $f_PesoUnitario = $o_VTA_DocumentoDetalleBN->getObjectItem()->getPesoGramos();
                    $f_StockFisico = $o_VTA_DocumentoDetalleBN->getStockFisico();
                    ?>
                <tr class="content_row">
                    <!--<td align="center"><?/*=( $i_Key + 1 )*/?></td>-->
                    <td align="center"><?=$s_IdItem?></td>
                    <td align="left"><?=$o_VTA_DocumentoDetalleBN->getDescripcion()?></td>
                    <td align="center" <?php if( !$f_StockFisico ){ ?> style="color: red;"<?php } ?> ><b><?=$f_StockFisico?></b></td>
                    <td align="center"><?= number_format( $f_PesoUnitario, 2 )?></td>
                    <td align="center"><?=number_format( $f_PesoUnitario * $o_VTA_DocumentoDetalleBN->getCantidadPedida(), 2 )?></td>
                    <td align="center"><?=$o_VTA_DocumentoDetalleBN->getCantidadPedida()?></td>
                    <td align="center"><?=$o_VTA_DocumentoDetalleBN->getCantidadRecibida()?></td>
                    <td align="center"> 
                        <input type="hidden" name="Secuencia[]" value="<?=$o_VTA_DocumentoDetalleBN->getSecuencia()?>">
                        <input type="hidden" name="ProFinalId[]" value="0">
                        <input type="hidden" name="ProFinalDetId[]" value="0">
                        <input type="hidden" name="IdUnidad[]" value="<?=$o_VTA_DocumentoDetalleBN->getIdUnidad()?>">
                        <input type="hidden" name="IdItem[]" value="<?=$s_IdItem?>">
                        <input type="text" class="form-control form-control-sm text-center" name="Cantidad[]" id="<?=$s_InputId?>" onfocus="this.select();" autocomplete="off" onblur="calcularPesoTotal();"
                            value="<?=( $o_VTA_DocumentoDetalleBN->getCantidadPedida() - $o_VTA_DocumentoDetalleBN->getCantidadRecibida() )?>" peso="<?=$o_VTA_DocumentoDetalleBN->getObjectItem()->getPesoGramos()?>" 
                            cantrec="<?=( $o_VTA_DocumentoDetalleBN->getCantidadPedida() - $o_VTA_DocumentoDetalleBN->getCantidadRecibida() )?>" iditem="<?=$o_VTA_DocumentoDetalleBN->getItemCodigo()?>"
                            stockfis="<?=$f_StockFisico?>" iditem="<?=$s_IdItem?>"
                            > 
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
    
    <?php }else{ ?>
    
        <?php foreach ( $o_VTA_OrdenBN->getArrayDetallesFinal() as $i_Key => $o_VTA_ProductoFinalBN ){ ?>
        
     <div class="dropdown-divider"></div>
     

    <div class="card" style="width: 17rem; border-bottom: 0px;">
        <div class="card-header" style="border-bottom: 0px;"><?=$o_VTA_ProductoFinalBN->getItemTipoClase()==1?"ENCOFRADO":"ANDAMIO"?></div>
    </div>
    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover">
            <thead class="thead-light">
                <tr>
                    <th width="2%"  style="text-align: center;" scope="col"><b>No</b></th>
                    <th width="8%"  style="text-align: center;" scope="col"><b>C&oacute;digo</b></th>
                    <th width="25%" align="" scope="col"><b>Descripci&oacute;n</b></th>
                    <th width="8%"  style="text-align: center;" scope="col"><b>Cant</b></th>
                    <th width="4%"  align="center" scope="col">&nbsp;</th>
                </tr>
            </thead>
            <tbody id="">
                <tr>
                    <th style="text-align: center;" scope="row"><?=$o_VTA_ProductoFinalBN->getSecuencia()?></th>
                    <td align="center"><?=$o_VTA_ProductoFinalBN->getIdItem()?></td>
                    <td align="" id=""><?=$o_VTA_ProductoFinalBN->getDetalleDescripcion()?></td>
                    <td align="center"><?=$o_VTA_ProductoFinalBN->getCantidad()?></td>
                    <td align="center" nowrap="nowrap">&nbsp;</td>
                </tr>
                <tr>
                    <td colspan=""> &nbsp; </td>
                    <td colspan="7">
                         <table class="table table-sm table-bordered table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th width="2%"  style="text-align: center;" scope="col"><b>No</b></th>
                                    <th width="8%"  style="text-align: center;" scope="col"><b>C&oacute;digo</b></th>
                                    <th width="25%" align="left" ><b>Descripci&oacute;n</b></th>
                                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Stock</b></th>
                                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Peso Unit</b></th>
                                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Peso Total</b></th>
                                    <th width="10%" style="text-align: center;" ><b>Cantidad Pedida</b></th>
                                    <th width="10%" style="text-align: center;" ><b>Cantidad Entregada</b></th>
                                    <th width="4%"  align="center" scope="col">&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody id="">
                            <?php foreach ( VTA_ProductoFinalDetFN::selectAll( $o_VTA_ProductoFinalBN->getProFinalId() ) as $i_Key => $o_VTA_ProductoFinalDetBN ){ ?>
                                <?php
                                $s_InputId = "input_".$i_Key;
                                $f_CantidadControl = $f_CantidadControl + ( $o_VTA_ProductoFinalDetBN->getCantidad() - $o_VTA_ProductoFinalDetBN->getCantidadRecibida() );
                                $f_StockFisico = $o_VTA_ProductoFinalDetBN->getStockFisico();
                                ?>
                                <tr>
                                    <th style="text-align: center;" scope="row"><?=$o_VTA_ProductoFinalDetBN->getSecuencia()?></th>
                                    <td align="center"><?=$o_VTA_ProductoFinalDetBN->getIdItem()?></td>
                                    <td align="" id=""><?=$o_VTA_ProductoFinalDetBN->getDetalleDescripcion()?></td>
                                    <td align="center" <?php if( !$f_StockFisico ){ ?> style="color: red;"<?php } ?> ><b><?=$f_StockFisico?></b></td>
                                    <td align="center"><?=number_format( $o_VTA_ProductoFinalDetBN->getPesoUnitario(), 2 )?></td>
                                    <td align="center"><?=number_format( $o_VTA_ProductoFinalDetBN->getPesoTotal(), 2 )?></td>
                                    <td align="center"><?=$o_VTA_ProductoFinalDetBN->getCantidad()?></td>
                                    <td align="center"><?=$o_VTA_ProductoFinalDetBN->getCantidadRecibida()?></td>
                                    <td align="center">
                                        <input type="hidden" name="Secuencia[]" value="<?=$o_VTA_ProductoFinalDetBN->getSecuencia()?>">
                                        <input type="hidden" name="ProFinalId[]" value="<?=$o_VTA_ProductoFinalDetBN->getProFinalId()?>">
                                        <input type="hidden" name="ProFinalDetId[]" value="<?=$o_VTA_ProductoFinalDetBN->getProFinalDetId()?>">
                                        <input type="hidden" name="IdUnidad[]" value="<?=$o_VTA_ProductoFinalDetBN->getIdUnidad()?>">
                                        <input type="hidden" name="IdItem[]" value="<?=$o_VTA_ProductoFinalDetBN->getIdItem()?>">
                                        <input type="text" class="form-control form-control-sm text-center" name="Cantidad[]" id="<?=$s_InputId?>" onfocus="this.select();" autocomplete="off" onblur="calcularPesoTotal();"
                                            value="<?=( $o_VTA_ProductoFinalDetBN->getCantidad() - $o_VTA_ProductoFinalDetBN->getCantidadRecibida() )?>" peso="<?=$o_VTA_ProductoFinalDetBN->getPesoUnitario()?>"
                                            cantrec="<?=( $o_VTA_ProductoFinalDetBN->getCantidad() - $o_VTA_ProductoFinalDetBN->getCantidadRecibida() )?>" iditem="<?=$o_VTA_ProductoFinalDetBN->getIdItem()?>"
                                            stockfis="<?=$f_StockFisico?>"
                                            > 
                                    </td>
                                </tr>
                            <?php } ?>
                            </tbody>
                         </table>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
        
        <?php } ?>
        
    <?php } ?>
    
    </div>

    <fieldset class="scheduler-border" style="background-color: antiquewhite;">
        <legend class="scheduler-border">Gu&iacute;a de Remisi&oacute;n</legend>
        
        <input type="hidden" name="TipoDocumentoFiscal" id="TipoDocumentoFiscal" value="GR">
        
        <div class="form-row mx-0">
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="SerieDocumentoFiscal">Serie</label>
                <input type="text" class="form-control text-center" name="SerieDocumentoFiscal" id="SerieDocumentoFiscal" placeholder="Serie" maxlength="4" 
                    onfocus="this.select();" onkeypress="return NumCheckEntero( event, this );" value="<?=$s_Serie?>" required
                    >
            </div>
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="NumeroDocumentoFiscal">Numero</label>
                <input type="text" class="form-control text-center" name="NumeroDocumentoFiscal" id="NumeroDocumentoFiscal" placeholder="Numero" maxlength="10" 
                    onfocus="this.select();" onkeypress="return NumCheckEntero( event, this );" value="<?=$s_Numero?>" required
                    >
            </div>
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="FechaIniTraslado">Fecha Traslado</label>
                <input type="text" class="form-control text-center" name="FechaIniTraslado" id="FechaIniTraslado" value="<?=date( "Y-m-d" )?>" maxlength="10" onfocus="this.select();" autocomplete="off" required>
                <script type="text/javascript">
                    $( "#FechaIniTraslado" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-0:+1", changeMonth: true, onClose: function ( fec_sel, obj_sel ){  } } );
                </script>
            </div>
        </div>
        <div class="form-row mx-0">
            <div class="col-md-4 mb-1">
                <div class="form-row mx-0">
                    <div class="col-md-6 mb-1">
                        <label class="col-form-label" for="TipoDeTransporteId">Tipo Transporte</label>
                        <select class="form-control" name="TipoDeTransporteId" id="TipoDeTransporteId">
                            <!--<option value=""> - SELECCIONE - </option>-->
                            <?php foreach ( SR_GuiaRemisionHBN::getArrayTipoDeTransporte() as $i_Key => $a_TipoTransporte ){ ?>
                                <?php if( $a_TipoTransporte['Estado'] != "A" ){ continue; } ?>
                                <option value="<?=$i_Key?>" > <?=$a_TipoTransporte['Descripcion']?> </option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-6 mb-1">
                        <label class="col-form-label" for="MotivoTrasladoId">Motivo Traslado</label>
                        <select class="form-control" name="MotivoTrasladoId" id="MotivoTrasladoId">
                            <!--<option value=""> - SELECCIONE - </option>-->
                            <?php foreach ( SR_GuiaRemisionHBN::getArrayMotivoTraslado() as $i_Key => $a_DataMotivo ){ ?>
                                <?php if( $a_DataMotivo['Estado'] != "A" ){ continue; } ?>
                                <option value="<?=$i_Key?>" > <?=$a_DataMotivo['Descripcion']?> </option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-md-8 mb-1">
                <label for="Observaciones" class="col-form-label">Observaciones:</label>
                <textarea class="form-control" id="Observaciones" name="Observaciones" rows="1" ></textarea>
            </div>
        </div>
        <div class="form-row mx-0">
            <div class="col-md-12">
                <fieldset class="scheduler-border" style="background-color: #add8e6;">
                    <legend class="scheduler-border">
                        <input type="checkbox" id="TransporteManual" name="TransporteManual" value="1" onclick="mostrarDatosTransporteManual();" > <label class="col-form-label font-weight-bold" for="TransporteManual">Datos del Transporte - Manual</label>
                    </legend>
                    <div id="content_transporte_manual" class="collapse" style="">
                    <!--<div class="card p-1" id="content_transporte_manual" style="">-->
                        <div class="form-row mx-0">
                            <div class="col-md-12" style="background-color: gainsboro;">
                                <label class="col-form-label" for="TransportistaDocumentoTipo">Transportista / Veh&iacute;culo</label>
                                <div class="form-row mx-0">
                                    <div class="col-md-2 mb-1">
                                        <select class="form-control" name="TransportistaDocumentoTipo" id="TransportistaDocumentoTipo">
                                            <option value="6" <?php if( $s_TransportistaDocumentoTipo == "6" ){ echo "selected"; } ?> > RUC </option>
                                            <option value="1" <?php if( $s_TransportistaDocumentoTipo == "1" ){ echo "selected"; } ?> > DNI </option>
                                        </select>
                                    </div>
                                    <div class="col-md-2 mb-1">
                                        <input type="text" class="form-control text-center" name="TransportistaDocumentoNumero" id="TransportistaDocumentoNumero" value="<?=$s_TransportistaDocumentoNumero?>" placeholder="Documento" onfocus="this.select();" autocomplete="off">
                                    </div>
                                    <div class="col-md-5 mb-1">
                                        <input type="text" class="form-control text-center" name="TransportistaDenominacion" id="TransportistaDenominacion" value="<?=$s_TransportistaDenominacion?>" placeholder="Denominacion" onfocus="this.select();" autocomplete="off">
                                    </div>
                                    <div class="col-md-3 mb-1">
                                        <input type="text" class="form-control text-center" name="TransportistaPlacaNumero" id="TransportistaPlacaNumero" value="<?=$s_TransportistaPlacaNumero?>" placeholder="Placa Numero" onfocus="this.select();" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-row mx-0">
                            <div class="col-md-12" style="background-color: #b8daff;">
                                <label class="col-form-label" for="IdChofer">Conductor</label>
                                <div class="form-row mx-0">
                                    <div class="col-md-2 mb-1">
                                        <select class="form-control" name="ConductorDocumentoTipo" id="ConductorDocumentoTipo">
                                            <!--<option value="6"> RUC </option>-->
                                            <option value="1" <?php if( $s_ConductorDocumentoTipo == "1" ){ echo "selected"; } ?>> DNI </option>
                                            <option value="4" <?php if( $s_ConductorDocumentoTipo == "4" ){ echo "selected"; } ?>> CARNET DE EXTRANJERÍA </option>
                                            <option value="7" <?php if( $s_ConductorDocumentoTipo == "7" ){ echo "selected"; } ?>> PASAPORTE </option>
                                            <option value="A" <?php if( $s_ConductorDocumentoTipo == "A" ){ echo "selected"; } ?>> CÉDULA DIPLOMÁTICA DE IDENTIDAD </option>
                                        </select>
                                    </div>
                                    <div class="col-md-2 mb-1">
                                        <input type="text" class="form-control text-center" name="ConductorDocumentoNumero" id="ConductorDocumentoNumero" value="<?=$s_ConductorDocumentoNumero?>" placeholder="Documento" onfocus="this.select();">
                                    </div>
                                    <div class="col-md-3 mb-1">
                                        <!-- Razón o nombre completo del CONDUCTOR. Y SOLO PARA TRANSPORTE PÚBLICO -->
                                        <input type="hidden" class="form-control text-center" name="ConductorDenominacion" id="ConductorDenominacion" value="<?=$s_ConductorDenominacion?>" placeholder="Nombre" onfocus="this.select();" readonly>
                                        <input type="text" class="form-control text-center" name="ConductorNombre" id="ConductorNombre" value="<?=$s_ConductorNombre?>" placeholder="Nombre" onfocus="this.select();" autocomplete="off">
                                    </div>
                                    <div class="col-md-3 mb-1">
                                        <input type="text" class="form-control text-center" name="ConductorApellido" id="ConductorApellido" value="<?=$s_ConductorApellido?>" placeholder="Apellido" onfocus="this.select();" autocomplete="off">
                                    </div>
                                    <div class="col-md-2 mb-1">
                                        <input type="text" class="form-control text-center" name="ConductorNroLicencia" id="ConductorNroLicencia" value="<?=$s_ConductorNumeroLicencia?>" placeholder="Nro Licencia" onfocus="this.select();" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>

                <fieldset class="scheduler-border" style="background-color: #add8e6;">
                    <legend class="scheduler-border">
                        <input type="checkbox" id="TransporteDinamico" name="TransporteDinamico" value="1" onclick="mostrarDatosTransporte();" > <label class="col-form-label font-weight-bold" for="TransporteDinamico">Datos del Transporte</label>
                    </legend>
                    <div id="content_transporte_dinamico" class="collapse" style="">
                        <div class="form-row mx-0">
                            <div class="col-md-6 mb-1">
                                <label class="col-form-label" for="IdVehiculo">Transportista / Veh&iacute;culo</label>
                                <select class="form-control" name="IdVehiculo" id="IdVehiculo">
                                    <option value=""> - SELECCIONE - </option>
                                    <?php foreach ( TR_VehiculoFN::selectActivos() as $i_Key => $o_TR_VehiculoBN ){ ?>
                                        <option value="<?=$o_TR_VehiculoBN->getIdVehiculo()?>" <?php if( "XXX"==$o_TR_VehiculoBN->getIdVehiculo() ){ echo "SELECTED"; } ?>>
                                            <?=$o_TR_VehiculoBN->getTransportTipoDocDesc()?> - <?=$o_TR_VehiculoBN->getTransportNumDoc()?> - <?=$o_TR_VehiculoBN->getTransportNombre()?> - <?=$o_TR_VehiculoBN->getVehiculoPlaca()?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="col-md-6 mb-1">
                                <label class="col-form-label" for="IdChofer">Conductor</label>
                                <select class="form-control" name="IdChofer" id="IdChofer">
                                    <option value=""> - SELECCIONE - </option>
                                    <?php foreach ( TR_ChoferFN::selectActivos() as $i_Key => $o_TR_ChoferBN ){ ?>
                                        <option value="<?=$o_TR_ChoferBN->getIdChofer()?>" <?php if( "XXX"==$o_TR_ChoferBN->getIdChofer() ){ echo "SELECTED"; } ?> >
                                            <?=$o_TR_ChoferBN->getTipoDocumentoDesc()?> - <?=$o_TR_ChoferBN->getChoferDocumento()?> - <?=$o_TR_ChoferBN->getChoferNombre()?> <?=$o_TR_ChoferBN->getChoferApellidoP()?> <?=$o_TR_ChoferBN->getChoferApellidoM()?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </fieldset>

            </div>
        </div>
    </fieldset>

    <script>
        $( "#content_transporte_dinamico" ).collapse( 'hide' );
        $( "#content_transporte_manual" ).collapse( 'hide' );
        mostrarDatosTransporte = function()
        {
            if( $( "#TransporteDinamico" ).is( ":checked" ) )
            {
                $( "#content_transporte_dinamico" ).collapse( 'show' );
                //$( "#content_transporte_manual" ).collapse( 'hide' );
            }
            else
            {
                $( "#content_transporte_dinamico" ).collapse( 'hide' );
                //$( "#content_transporte_manual" ).collapse( 'show' );
            }
        }

        mostrarDatosTransporteManual = function ()
        {
            if( $( "#TransporteManual" ).is( ":checked" ) )
            {
                $( "#content_transporte_manual" ).collapse( 'show' );
            }
            else
            {
                $( "#content_transporte_manual" ).collapse( 'hide' );
            }
        }
    </script>
    
    <div class="dropdown-divider"></div>
    
    <fieldset class="scheduler-border" style="background-color: gainsboro;">
        <legend class="scheduler-border">Peso Acumulado</legend>
        <div class="form-row mx-0">

            <div class="col-md-4 mb-1">
            </div>
            <div class="col-md-4 mb-1">
                <div class="form-row mx-0">
                    <div class="col-md-6 mb-1 text-right">
                        <label class="col-form-label" for="SumaPesoTotal">Peso Total</label>
                    </div>
                    <div class="col-md-6 mb-1">
                        <input type="text" class="form-control text-center" name="SumaPesoTotal" id="SumaPesoTotal" onfocus="this.select();" readonly="readonly">
                    </div>
                </div>
            </div>

            <div class="col-md-4 mb-1">
                <div class="form-row mx-0">
                    <div class="col-md-6 mb-1 text-right">
                        <label class="col-form-label" for="TotalBulto">Bultos</label>
                    </div>
                    <div class="col-md-6 mb-1">
                        <input type="text" class="form-control text-center" name="TotalBulto" id="TotalBulto" value="1" onfocus="this.select();" >
                    </div>
                </div>
            </div>
        </div>
    </fieldset>
    
    <div class="dropdown-divider"></div>

<script type="text/javascript">
actualizarFechaAlquiler = function( fecha_alq )
{
    if( fecha_alq.trim() != "" )
    {
        blockContent( 'form1' );
        param_url = 'OrdenId=<?=$o_VTA_OrdenBN->getOrdenId()?>&TipoProc=actualizarFechaAlquiler&NoUpdate=1&FechaInicioAlquiler=' + fecha_alq;
        executeAjaxJson
        ( 
            "<?php echo buildUrlComplet( 'vta.php/cot/requestOrden' ) ?>", 
            param_url,
            function( o_json )
            {
            	unBlockContent( 'form1' );
                if( o_json.error )
                {
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }
                pr( o_json );
                $( "#FechaFinAlq" ).val( o_json.FechaFinAlquiler );
            } 
        );
    }
}
</script>
    <?php if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER ){ ?>
    <fieldset class="scheduler-border">
        <legend class="scheduler-border">Fecha de Alquiler</legend>
        <div class="form-row mx-0">
            <div class="col-md-6 mb-1">
                <label class="col-form-label" for="FechaInicioAlq">Inicio</label>
                <input type="text" class="form-control text-center" name="FechaInicioAlq" id="FechaInicioAlq" maxlength="10" value="<?=date( 'Y-m-d' )?>" autocomplete="off" required>
                <script type="text/javascript">
                $( "#FechaInicioAlq" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-0:+1", changeMonth: true, onClose: function ( fec_sel, obj_sel ){ actualizarFechaAlquiler( fec_sel ); } } );
                </script>
            </div>
            <div class="col-md-6 mb-1">
                <label class="col-form-label" for="FechaFinAlq">Fin</label>
                <input type="text" class="form-control text-center" name="FechaFinAlq" id="FechaFinAlq" maxlength="10" onfocus="" value="" readonly="readonly" required>
            </div>
        </div>
    </fieldset>
    
    <div class="dropdown-divider"></div>
    <?php } ?>

    <fieldset class="scheduler-border" style="background-color: papayawhip;">
        <legend class="scheduler-border">
            <input type="checkbox" id="DireccionOrigenChk" name="DireccionOrigenChk" value="1" onclick="mostrarDirOrg();" > <label class="col-form-label font-weight-bold" for="DireccionOrigenChk">Modificar Punto de Partida</label>
        </legend>
        <div id="content_direccionorigen" class="collapse" style="">
            <div class="form-row mx-0">
                <div class="col-md-4 mb-1">
                    <label class="col-form-label" for="DepartamentoOrigen">Departamento</label>
                    <select class="form-control" name="DepartamentoOrigen" id="DepartamentoOrigen"
                            onchange="$('#ProvinciaOrigen')[0].options.length=1; $('#DistritoOrigen')[0].options.length=1; publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Provincia&Departamento='+this.value, 'ProvinciaOrigen');"
                            >
                        <option value=""> - SELECCIONE - </option>
                        <?php foreach ( $a_DptMST_Ubigeo as $i_Key => $o_DptMST_UbigeoBN ){ ?>
                        <option value="<?=$o_DptMST_UbigeoBN->getIdUbigeo()?>" <?php if( "XXX"==$o_DptMST_UbigeoBN->getIdUbigeo() ){ echo "SELECTED"; } ?>> <?=$o_DptMST_UbigeoBN->getDescripcion()?> </option>
                        <?php } ?>
                    </select>
                </div>
                <div class="col-md-4 mb-1">
                    <label class="col-form-label" for="ProvinciaOrigen">Provincia</label>
                    <select class="form-control" name="ProvinciaOrigen" id="ProvinciaOrigen"
                            onchange="$('#DistritoOrigen')[0].options.length = 1; publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Distrito&Provincia='+this.value, 'DistritoOrigen');"
                            >
                        <option value=""> - SELECCIONE - </option>
                    </select>
                </div>
                <div class="col-md-4 mb-1">
                    <label class="col-form-label" for="DistritoOrigen">Distrito</label>
                    <select class="form-control" name="DistritoOrigen" id="DistritoOrigen">
                        <option value=""> - SELECCIONE - </option>
                    </select>
                </div>
            </div>
            <div class="form-group m-1">
                <label for="DireccionOrigen" class="col-form-label">Direcci&oacute;n:</label>
                <textarea class="form-control" id="DireccionOrigen" name="DireccionOrigen" rows="1" ></textarea>
            </div>
        </div>
    </fieldset>
    <script>
        $( "#content_direccionorigen" ).collapse( 'hide' );
        mostrarDirOrg = function()
        {
            if( $( "#DireccionOrigenChk" ).is( ":checked" ) )
            {
                $( "#content_direccionorigen" ).collapse( 'show' );
            }
            else
            {
                $( "#content_direccionorigen" ).collapse( 'hide' );
            }
        }
    </script>
    
    <div class="dropdown-divider"></div>
    
    <fieldset class="scheduler-border" style="background-color: gainsboro;">
        <legend class="scheduler-border">
            <input type="checkbox" id="DireccionDestinoChk" name="DireccionDestinoChk" value="1" onclick="mostrarDirDest();" > <label class="col-form-label font-weight-bold" for="DireccionDestinoChk">Modificar Punto de Llegada</label>
        </legend>
        <div id="content_direcciondestino" class="collapse" style="">
            <div class="form-row mx-0">
                <div class="col-md-4 mb-1">
                    <label class="col-form-label" for="DepartamentoDestino">Departamento</label>
                    <select class="form-control" name="DepartamentoDestino" id="DepartamentoDestino"
                            onchange="$('#ProvinciaDestino')[0].options.length=1; $('#DistritoDestino')[0].options.length=1; publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Provincia&Departamento='+this.value, 'ProvinciaDestino');"
                            >
                        <option value=""> - SELECCIONE - </option>
                        <?php foreach ( $a_DptMST_Ubigeo as $i_Key => $o_DptMST_UbigeoBN ){ ?>
                        <option value="<?=$o_DptMST_UbigeoBN->getIdUbigeo()?>" <?php if( "XXX"==$o_DptMST_UbigeoBN->getIdUbigeo() ){ echo "SELECTED"; } ?>> <?=$o_DptMST_UbigeoBN->getDescripcion()?> </option>
                        <?php } ?>
                    </select>
                </div>
                <div class="col-md-4 mb-1">
                    <label class="col-form-label" for="ProvinciaDestino">Provincia</label>
                    <select class="form-control" name="ProvinciaDestino" id="ProvinciaDestino"
                            onchange="$('#DistritoDestino')[0].options.length=1; publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Distrito&Provincia='+this.value, 'DistritoDestino');"
                            >
                        <option value=""> - SELECCIONE - </option>
                    </select>
                </div>
                <div class="col-md-4 mb-1">
                    <label class="col-form-label" for="DistritoDestino">Distrito</label>
                    <select class="form-control" name="DistritoDestino" id="DistritoDestino">
                        <option value=""> - SELECCIONE - </option>
                    </select>
                </div>
            </div>
            <div class="form-group m-1">
                <label for="DireccionDestino" class="col-form-label">Direcci&oacute;n:</label>
                <textarea class="form-control" id="DireccionDestino" name="DireccionDestino" rows="1" ></textarea>
            </div>
        </div>
    </fieldset>
    <script>
        $( "#content_direcciondestino" ).collapse( 'hide' );
        mostrarDirDest = function()
        {
            if( $( "#DireccionDestinoChk" ).is( ":checked" ) )
            {
                $( "#content_direcciondestino" ).collapse( 'show' );
            }
            else
            {
                $( "#content_direcciondestino" ).collapse( 'hide' );
            }
        }
    </script>
    
    <?php if( $s_IdRuta ){ ?>
    <div> <p> <input type="checkbox" name="ParaProvincia" id="ParaProvincia" value="1"> <label for="ParaProvincia">Marque si se env&iacute;a a Provincia. </label> </p> </div>
    <?php  } ?>

    <div class="form-row mx-0" style="padding: 10px;" id="content_buttons">
        <div class="col-md-6 mb-1">
            <button type="button" class="btn btn-danger btn-lg btn-block" onclick="parent.closeWindow();">CANCELAR</button>
        </div>
    <?php if( $s_GuiaRemisionId ){ ?>
        <div class="col-md-6 mb-1">
            <button type="button" class="btn btn-primary btn-lg btn-block" onclick="reEnviarGuia()">RE-ENVIAR GUIA</button>
        </div>
    <?php }else{ ?>
        <?php if( $b_CtrlVwButtons ){ ?>
            <?php if( $f_CantidadControl ){ ?>
            <div class="col-md-6 mb-1">
                <button type="submit" class="btn btn-primary btn-lg btn-block" onclick="">GENERAR GUIA</button>
            </div>
            <?php }else{ ?>

                <div class="col-md-6 mb-1">
                    <button type="button" class="btn btn-primary btn-lg btn-block" onclick="cambiarEstadoImpreson('C')">COMPLETADO</button>
                </div>
            <?php } ?>
        <?php } ?>
    <?php } ?>
    </div>

</form>

<script type="text/javascript">
cambiarEstadoImpreson = function( Estado )
{
    x = confirm( "Esta seguro de cambiar de Estado?" );
    if( x )
    {
        blockContent( "content_buttons" );
        var strFormSerialize = "TipoProc=CambiarEstado&Id=<?=$s_IdMovimientoSerie?>&Estado=" + Estado;
        executeAjaxJson
        (
            "<?php echo buildUrl( 'transporte/requestTransporte' ) ?>",
            strFormSerialize,
            function( o_json )
            {
                unBlockContent( "content_buttons" );
                if( o_json.error )
                {
                    mostrarMensajeError( o_json.mensaje_error );
                    return false;
                }
                parent.findControl();
                parent.closeWindow();
            }
        );
    }
}

configurarDataTable = function()
{
    $( '#example' ).DataTable
    (
        {
            language:       { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
            responsive:     false,
            searching:      false,
            info:           false,
            lengthChange:   false,
            paging:         false,
            dom:            'lrtip'/*,
            fixedHeader: 
            {
                header: true,
                footer: true
            }*/
        }
    );
}

setTimeout
(
    function () 
    {
        configurarDataTable();
    }, 
    500
);
</script>

<script type="text/javascript">
calcularPesoTotal();
<?php if( $mensaje_error ){ ?>
showAlertBootStrap( 'content_alert', 'alert-danger', "<?=$mensaje_error?>" );
<?php } ?>

<?php if( $b_CtrlDisabledAll ){ ?>
convertirDisabledTodosLosInputs();
<?php } ?>
</script>

<script>
    <?php if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER ){ ?>
    actualizarFechaAlquiler( '<?=date("Y-m-d" )?>' );
    <?php } ?>
</script>

<script>
    <?php if( !$o_VTA_DocumentoBN->getClienteDireccion() ){ ?>
    seleccionarDistrito = function()
    {
        setTimeout( function(){ $( '#DistritoDestino' ).val( '<?=$s_UbigeoDestino?>' ); }, 500 );
    }

    seleccionarProvincia = function()
    {
        setTimeout( function(){ $( '#ProvinciaDestino' ).val( '<?=$s_ProvinDestino?>' ); }, 500 );

        publicForSelectAjaxJSON( '<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Distrito&Provincia=<?=$s_ProvinDestino?>', 'DistritoDestino', seleccionarDistrito() );
    }

    $( '#DireccionDestinoChk' ).prop( 'checked', true );
    mostrarDirDest();
    $( '#DepartamentoDestino' ).val( '<?=$s_DepartDestino?>' );

    publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Provincia&Departamento=<?=$s_DepartDestino?>', 'ProvinciaDestino', seleccionarProvincia());

    $( '#DireccionDestino' ).val( '<?=$s_DireccDestino?>');
    <?php } ?>
</script>