<!-- https://ourcodeworld.com/articles/read/687/how-to-configure-a-header-and-footer-in-dompdf -->
<html>
<head>
    <style type="text/css">
        @page
        {
            size: A4 portrait;
            margin: 0cm 0cm;
        }

        header
        {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 10px;
        }

        footer
        {
            bottom: 0cm;
            left: 0cm;
            right: 0cm;
        }

        body
        {
            margin : 0.5cm;
            /*margin-top: 1cm;*/
            font-family: Arial, Helvetica, sans-serif;
            font-size: 10px;
            /*margin-top: 0.5cm;
            margin-left: 0.5cm;
            margin-right: 0.5cm;
            margin-bottom: 0.5cm;*/
        }

        table
        {
            font-family: Arial, Helvetica, sans-serif;
            font-size: 10px;
        }

        .new-page{ page-break-before: always; }

        #watermark
        {
            position: fixed;
            opacity: 0.2;
            /**
                Establece una posición en la página para tu imagen
                Esto debería centrarlo verticalmente
            **/
            bottom:   13cm;
            left:     6.5cm;

            /** Cambiar las dimensiones de la imagen **/
            width:    8cm;
            height:   8cm;

            /** Tu marca de agua debe estar detrás de cada contenido **/
            z-index:  -1000;
        }

    </style>
</head>
<!--<body style="page-break-before: always;">-->
<body>

    <div id="watermark">
        <img src="<?=$o_GSS_CompaniaBN->getLogoBackFileToPDF()?>" style="width: <?=$o_GSS_CompaniaBN->getLogoBackFileAncho()?>px; height: <?=$o_GSS_CompaniaBN->getLogoBackFileAlto()?>px;" >
    </div>

    <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0"  >
        <tr>
            <td style="width: 30%">

                <div style="">
                    <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0"  >
                        <tr>
                            <td style=""> <img src="<?=$o_GSS_CompaniaBN->getLogoFileToPDF()?>" style="width: <?=$o_GSS_CompaniaBN->getLogoFileAncho()?>px; height: <?=$o_GSS_CompaniaBN->getLogoFileAlto()?>px;" > </td>
                        </tr>
                    </table>
                </div>
            </td>
            <td style="width: 38%">
                <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0" >
                    <tr>
                        <td style="font-size: 10px;" align="center">
                            <label><b><?=$o_GSS_CompaniaBN->getDireccionComun()?></b></label>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-size: 10px;" align="center">
                            <label><?=$o_GSS_CompaniaBN->getDireccionAdicional()?></label>
                        </td>
                    </tr>
                </table>
            </td>
            <td style="width: 30%;">

                <div style=" vertical-align: top; background-color: #EDEDED; padding: 5px;
                            border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px;
                            border: 1px solid #B9B5B5;
                            ">
                    <div style="text-align: center;"><label style="font-size: 18px; font-weight: bold;">RUC <?=$o_GSS_CompaniaBN->getRuc()?></label></div>
                    <div style="text-align: center;"><label style="font-size: 18px; font-weight: bold;">GUIA DE REMISIÓN REMITENTE ELECTRÓNICA</label></div>
                    <div style="text-align: center;"> <label style="font-size: 18px; font-weight: bold;"><?=$o_SR_GuiaRemisionHBN->getGuiaSerieNumeroConcat()?></label> </div>
                </div>
            </td>
        </tr>
    </table>

    <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px; border: 1px solid #B9B5B5;  ">
        <div style="background-color: #EEEEEE; border: 1px solid #B9B5B5; border-top-left-radius: 5px; border-bottom-left-radius: 5px; border-bottom-right-radius: 5px; border-top-right-radius: 5px; padding: 5px;">
            <b>DATOS DEL DESTINATARIO</b>
        </div>
        <table style="width: 100%;" border="0" cellpadding="3" cellspacing="0" >
            <tr>
                <td>
                    <table cellpadding="3" cellspacing="0" border="0" width="100%" >
                        <tr>
                            <td width="40%" align="right"><b><?=$o_SR_GuiaRemisionHBN->getClienteTipoDocumento()?>:</b>&nbsp;&nbsp;</td>
                            <td><?=$o_SR_GuiaRemisionHBN->getClienteNumDocumento()?></td>
                        </tr>
                        <tr>
                            <td align="right"><b>DENOMINACIÓN:</b>&nbsp;&nbsp;</td>
                            <td><?=$o_SR_GuiaRemisionHBN->getClienteNombre()?></td>
                        </tr>
                        <tr>
                            <td align="right"><b>FECHA EMISIÓN:</b>&nbsp;&nbsp;</td>
                            <td><?=substr( $o_SR_GuiaRemisionHBN->getGuiaFecha(), 0 , 10 )?></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>

    <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px; border: 1px solid #B9B5B5; ">
        <div style="background-color: #EEEEEE; border: 1px solid #B9B5B5; border-top-left-radius: 5px; border-bottom-left-radius: 5px; border-bottom-right-radius: 5px; border-top-right-radius: 5px; padding: 5px;">
            <b>DATOS DEL TRASLADO</b>
        </div>
        <table style="width: 100%;" border="0" cellpadding="3" cellspacing="0" >
            <tr>
                <td>
                    <table cellpadding="3" cellspacing="0" border="0" width="100%" >
                        <tr>
                            <td width="40%"  align="right"><b>FECHA INICIO DE TRASLADO:</b>&nbsp;&nbsp;</td>
                            <td><?=$o_SR_GuiaRemisionHBN->getFechaIniTraslado()?></td>
                        </tr>
                        <tr>
                            <td align="right"><b>MOTIVO DE TRASLADO:</b>&nbsp;&nbsp;</td>
                            <td><?=$o_SR_GuiaRemisionHBN->getMotivoTrasladoDesc()?></td>
                        </tr>
                        <tr>
                            <td align="right"><b>MODALIDAD DE TRANSPORTE</b>&nbsp;&nbsp;</td>
                            <td><?=$o_SR_GuiaRemisionHBN->getModalidadTransporteDesc()?></td>
                        </tr>
                        <tr>
                            <td align="right"><b>PESO BRUTO TOTAL (KGM):</b>&nbsp;&nbsp;</td>
                            <td><?=number_format( $f_SumaPesoTotal, 2 )?></td>
                        </tr>
                        <tr>
                            <td align="right"><b>NÚMERO DE BULTOS:</b>&nbsp;&nbsp;</td>
                            <td>0</td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>

    <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px; border: 1px solid #B9B5B5; ">
        <div style="background-color: #EEEEEE; border: 1px solid #B9B5B5; border-top-left-radius: 5px; border-bottom-left-radius: 5px; border-bottom-right-radius: 5px; border-top-right-radius: 5px; padding: 5px;">
            <b>DATOS DEL TRASLADO</b>
        </div>
        <table style="width: 100%;" border="0" cellpadding="3" cellspacing="0" >
            <tr>
                <td>
                    <table cellpadding="3" cellspacing="0" border="0" width="100%" >
                        <tr>
                            <td width="40%" align="right"><b>PUNTO DE PARTIDA:</b>&nbsp;&nbsp;</td>
                            <td><?=$o_SR_GuiaRemisionHBN->getDireccionOrigen()?></td>
                        </tr>
                        <tr>
                            <td align="right"><b>PUNTO DE LLEGADA:</b>&nbsp;&nbsp;</td>
                            <td><?=$o_SR_GuiaRemisionHBN->getDireccionDestino()?></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>

    <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px; border: 1px solid #B9B5B5; ">
        <div style="background-color: #EEEEEE; border: 1px solid #B9B5B5; border-top-left-radius: 5px; border-bottom-left-radius: 5px; border-bottom-right-radius: 5px; border-top-right-radius: 5px; padding: 5px;">
            <b>DATOS DEL TRANSPORTISTA</b>
        </div>
        <table style="width: 100%;" border="0" cellpadding="3" cellspacing="0" >
            <tr>
                <td>
                    <table cellpadding="3" cellspacing="0" border="0" width="100%" >
                        <tr>
                            <td width="40%" align="right"><b>TRANSPORTISTA:</b>&nbsp;&nbsp;</td>
                            <td><?=$s_TransportistaDenominacion?></td>
                        </tr>
                        <tr>
                            <td align="right"><b>VEHICULO:</b>&nbsp;&nbsp;</td>
                            <td><?=$s_TransportistaPlacaNumero?></td>
                        </tr>
                        <tr>
                            <td align="right"><b>CONDUCTOR:</b>&nbsp;&nbsp;</td>
                            <td><?=$s_ConductorDenominacion?></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    </div>

    <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px;
                    border: 1px solid #B9B5B5; padding: 5px; ">

        <table style="width: 100%;" border="0" cellpadding="3" cellspacing="0" >
            <tr>
                <!-- 1% -->
                <td style="width: 5%; background-color: #EEEEEE; border-bottom: 1px solid ; border-left: 1px solid; border-top: 1px solid; border-color: #B9B5B5;
                            border-top-left-radius: 5px; border-bottom-left-radius: 5px;
                            " align="center">
                    <b>COD</b>
                </td>
                <td style="width: 50%; background-color: #EEEEEE; border-bottom: 1px solid; border-top: 1px solid; border-color: #B9B5B5;"><b>DESCRIPCION</b></td>
                <td style="width: 6%; background-color: #EEEEEE; border-bottom: 1px solid; border-top: 1px solid; border-color: #B9B5B5;" align="center"><b>U.M</b></td>
                <td style="width: 10%; background-color: #EEEEEE; border-bottom: 1px solid; border-top: 1px solid; border-right: 1px solid; border-color: #B9B5B5;
                               border-bottom-right-radius: 5px; border-top-right-radius: 5px;" align="right">
                    <b>CANTIDAD</b>
                </td>
            </tr>

            <?php foreach( $a_SR_GuiaRemisionDet as $i_Key => $o_SR_GuiaRemisionDetBN ){ ?>
                <?php $s_Background = $i_Key%2==0 ? "" : "background-color: #F0F0F0;"; ?>
                <tr style="<?=$s_Background?>">
                    <td style="" align="center"><?=$o_SR_GuiaRemisionDetBN->getIdItem()?></td>
                    <td style="" align="left">
                        <?=$o_SR_GuiaRemisionDetBN->getDescripcion()?>
                        <?php
                        //SE RECUPERA SERIES SI SE ENCUENTRA:
                        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_SR_GuiaRemisionDetBN->getIdItem() );

                        $s_SerieConcat = "";
                        if( $o_ALM_ItemMastBN->SiManejaSerie() )
                        {
                            $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
                            $o_VTA_DocumentoDetalleBN->setItemCodigo( $o_ALM_ItemMastBN->getIdItem() );
                            $a_Series = $o_VTA_DocumentoDetalleBN->getSeriesEscaneadasxIdMov( $o_SR_GuiaRemisionDetBN->getMovimientoId() );
                            $s_Series = implode( " ", $a_Series );
                            echo $s_Series;
                        }
                        ?>
                    </td>
                    <td style="" align="center"><?=$o_SR_GuiaRemisionDetBN->getObjectUnidad()->getDescripcionCorta()?></td>
                    <td style="" align="right"><?=number_format( $o_SR_GuiaRemisionDetBN->getCantidad(), 2 )?></td>
                </tr>
            <?php } ?>

            <?php if( count( $a_SR_GuiaRemisionDet ) < 10 ){ ?>
                <?php $i_Key = $i_Key + 1 ?>
                <?php for ( $i=$i_Key; $i < 10; $i++) { ?>
                    <?php $s_Background = $i%2==0 ? "" : "background-color: #F0F0F0;"; ?>
                    <tr style="<?=$s_Background?>">
                        <td style="" align="center">&nbsp;</td>
                        <td style="" align="left">&nbsp;</td>
                        <td style="" align="center">&nbsp;</td>
                        <td style="" align="right">&nbsp;</td>
                    </tr>
                <?php } ?>
            <?php } ?>

        </table>
    </div>

    <div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px; border: 1px solid #B9B5B5; padding: 5px; ">
        <table cellpadding="3" cellspacing="0" border="0" width="100%" >
            <tr>
                <td width="15%" align="right"><b>OBSERVACIONES:</b>&nbsp;&nbsp;</td>
                <td><?=$o_SR_GuiaRemisionHBN->getComentario()?></td>
            </tr>
        </table>
    </div>

    <!--<div style="border-top-right-radius: 5px; border-top-left-radius: 5px; border-bottom-right-radius: 5px; border-bottom-left-radius: 5px; margin-top: 10px; border: 1px solid #B9B5B5; padding: 5px; ">
        <table cellpadding="3" cellspacing="0" border="0" width="100%" >
            <tr>
                <td align="left">Representación impresa de la GUIA DE REMISIÓN REMITENTE ELECTRÓNICA</td>
            </tr>
            <tr>
                <td align="left">Emitido mediante un PROVEEDOR Autorizado por la SUNAT mediante Resolución de Intendencia No.034-005-0005315</td>
            </tr>
        </table>
    </div>-->

</body>
</html>