<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class PrintFormatPDFAction extends wtActions 
{
    public function execute()
    {

        $s_TipoProceso       = $this->getRequestParameter( 'TipoProceso' ); //POR AHORA SOLO HAY 2 TIPOS -> TR[TRANSFERENCIA] DE[DESPACHO][PARA VENTA]
        $s_IdRuta            = $this->getRequestParameter( 'IdRuta' );
        $s_IdRutaLinea       = $this->getRequestParameter( 'IdRutaLinea' );
        $s_IdMovimientoSerie = $this->getRequestParameter( "IdMovimientoSerie" );
        $s_IdTransferencia   = $this->getRequestParameter( "IdTransferencia" );

        $s_Tipo   = $this->getRequestParameter( 'TipoDocumentoFiscal' );
        $s_Serie  = $this->getRequestParameter( 'SerieDocumentoFiscal' );
        $s_Numero = $this->getRequestParameter( 'NumeroDocumentoFiscal' );

        $b_ControlRuta = false;
        $b_ControlImpr = false;
        ///////////////////////////////////////////////////////////////////////////
        ///PARAMETROS

        $s_vHtml    = "";
        $IdCompania = "-";

        $o_VTA_DocumentoBN        = null;
        //$o_DocumentoReferenciaDet = null;

        $a_Data = array();
        
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();
        
            $a_Data['Serie']  = $s_Serie;
            $a_Data['Numero'] = $s_Numero;
    
            if( $this->getRequestParameter( 'IdMovimientoSerie' ) )
            {
                $o_SR_MovimientoFN = new SR_MovimientoFN();
                $o_SR_MovimientoBN = $o_SR_MovimientoFN->selectByPK( $s_IdMovimientoSerie );
               
                if( $o_SR_MovimientoBN->getTipoMovimiento() == "VTA" ) //&& $o_SR_MovimientoBN->getReferenciaTipo() == "OS"
                {
                    $o_VTA_OrdenBN = $o_SR_MovimientoBN->getObjectDocumentoReferencia();
                    $o_VTA_DocumentoBN = $o_VTA_OrdenBN->getObjectVTADocumento();
                    $a_VTA_DocumentoDetalle = $o_VTA_DocumentoBN->getArrayObjectDetalles();
    
                    $IdCompania = $o_VTA_DocumentoBN->getIdCompania();
                    
                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $o_VTA_DocumentoBN->getClienteNumero() );
                    //pr( $o_MST_PersonaMastBN );
                    
                    $s_AlmacenDespacho = $o_SR_MovimientoBN->getAlmacen();
                    $i_IdSucursal = ALM_AlmacenMastFN::recuperarIdSucursal( $s_AlmacenDespacho );
                    
                    $o_GSS_SucursalFN = new GSS_SucursalFN();
                    $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $i_IdSucursal );

                    //ahora se recupera la direccion de Partida
                    $a_Data['DepartamentoOrigen'] = MST_UbigeoFN::getDescripcionPorId( $o_GSS_SucursalBN->getDepartamento() );
                    $a_Data['ProvinciaOrigen']    = MST_UbigeoFN::getDescripcionPorId( $o_GSS_SucursalBN->getProvincia() );
                    $a_Data['DistritoOrigen']     = MST_UbigeoFN::getDescripcionPorId( $o_GSS_SucursalBN->getDistrito() );
                    $a_Data['DireccionOrigen']    = $o_GSS_SucursalBN->getDireccion();

                    //ahora se recupera la direccion de Destino
                    $a_Data['DepartamentoDestino'] = $o_MST_PersonaMastBN->getDepartamentoDesc();
                    $a_Data['ProvinciaDestino']    = $o_MST_PersonaMastBN->getProvinciaDesc();
                    $a_Data['DistritoDestino']     = $o_MST_PersonaMastBN->getDistritoDesc();
                    $a_Data['DireccionDestino']    = $o_MST_PersonaMastBN->getDireccion();
                    
                    //informacion 
                    $a_Data['TipoDocumento']      = $o_VTA_DocumentoBN->getClienteTipoDoc();
                    $a_Data['ClienteRUC']         = $o_VTA_DocumentoBN->getClienteRUC();
                    $a_Data['ClienteNombre']      = $o_VTA_DocumentoBN->getClienteNombre();
                    $a_Data['TipoDocumentoDesc']  = $o_VTA_DocumentoBN->getTipoDocumentoDesc();
                    $a_Data['TipoSerieNumero']    = $o_VTA_DocumentoBN->getDocumentoTipoSerieNumero();
                }
            }
            
            if( $this->getRequestParameter( 'IdRuta' ) )
            {
                /*
                $o_TR_RutaFN = new TR_RutaFN();
                $o_TR_RutaBN = $o_TR_RutaFN->selectByPK( $s_IdRuta );
                
                $o_TR_RutaDetalleFN = new TR_RutaDetalleFN();
                $o_TR_RutaDetalleBN = $o_TR_RutaDetalleFN->selectByPK( $s_IdRuta, $s_IdRutaLinea );
    
                //direccion de destino
                $a_Data['DepartamentoDestino'] = $o_TR_RutaDetalleBN->getRutaDetDpto();
                $a_Data['ProvinciaDestino']    = $o_TR_RutaDetalleBN->getRutaDetCiudad();
                $a_Data['DistritoDestino']     = $o_TR_RutaDetalleBN->getRutaDetDir1();
                $a_Data['DireccionDestino']    = $o_TR_RutaDetalleBN->getRutaDetDir2();
                
                $o_VTA_DocumentoBN = $o_TR_RutaDetalleBN->getObjectVTADocumento();
                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoBN->getArrayObjectDetalles();
    
                $IdCompania        = $o_VTA_DocumentoBN->getIdCompania();
                */
                /*//los detalles
                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_DocumentoReferencia->getIdTipoDocumento() );
                $o_VTA_DocumentoDetalleFN->setIdCompania( $o_DocumentoReferencia->getIdCompania() );
                $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_DocumentoReferencia->getNumeroDocumento() );
                $o_DocumentoReferenciaDet = $o_VTA_DocumentoDetalleFN->select();*/
                
                $b_ControlRuta = true;
            }
            
            $a_IdItem   = $this->getRequestParameter( 'IdItem' );
            $a_Cantidad = $this->getRequestParameter( 'Cantidad' );
            
            $a_TMP_VTA_DocumentoDetalle = array();
            $a_GuiaDetalle              = array();
            if( $s_TipoProceso == "DE" )
            {
                foreach ( $a_Cantidad as $i_Key => $s_Cantidad )
                {
                    foreach ( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN )
                    {
                        if( $o_VTA_DocumentoDetalleBN->getItemCodigo() == $a_IdItem[$i_Key] )
                        {
                            if( floatval( $s_Cantidad ) > 0 )
                            {
                                if( ( $o_VTA_DocumentoDetalleBN->getCantidadRecibida() + floatval( $s_Cantidad ) ) > $o_VTA_DocumentoDetalleBN->getCantidadPedida() )
                                {
                                    throw new Exception( "El Codigo [".$a_IdItem[$i_Key]."] tiene una cantidad solicitada mayor a la cantidad Facturada." );
                                }

                                if( ( $o_VTA_DocumentoDetalleBN->getCantidadRecibida() + floatval( $s_Cantidad ) ) == $o_VTA_DocumentoDetalleBN->getCantidadPedida() )
                                {
                                    $b_ControlImpr = true;
                                }
                                else
                                {
                                    $b_ControlImpr = false;
                                }

                                $o_VTA_DocumentoDetalleBN->setCantidadaDescontar( floatval( $s_Cantidad ) );

                                $a_TMP_VTA_DocumentoDetalle[] = $o_VTA_DocumentoDetalleBN;
                                
                                $a_GuiaDetalle[] = array
                                (
                                    "ItemCodigo"         => $o_VTA_DocumentoDetalleBN->getItemCodigo(),
                                    "CantidadaDescontar" => $o_VTA_DocumentoDetalleBN->getCantidadaDescontar(),
                                    "DescripcionUnidad"  => $o_VTA_DocumentoDetalleBN->getObjectUnidad()->getDescripcionCorta(),
                                    "DescripcionItem"    => $o_VTA_DocumentoDetalleBN->getDescripcion(),
                                    "PesoGramos"         => $o_VTA_DocumentoDetalleBN->getObjectItem()->getPesoGramos()
                                );
                            }
                        }
                    }
                }
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //direccion de Partida - personalizado
            if( $this->getRequestParameter( 'DepartamentoOrigen' ) )
            {
                $a_Data['DepartamentoOrigen'] = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'DepartamentoOrigen' ) );
            }
            if( $this->getRequestParameter( 'ProvinciaOrigen' ) )
            {
                $a_Data['ProvinciaOrigen'] = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'ProvinciaOrigen' ) );
            }
            if( $this->getRequestParameter( 'DistritoOrigen' ) )
            {
                $a_Data['DistritoOrigen'] = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'DistritoOrigen' ) );
            }
            if( $this->getRequestParameter( 'DireccionOrigen' ) )
            {
                $a_Data['DireccionOrigen'] = $this->getRequestParameter( 'DireccionOrigen' );
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //direccion de Destino - personalizado
            if( $this->getRequestParameter( 'DepartamentoDestino' ) )
            {
                $a_Data['DepartamentoDestino'] = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'DepartamentoDestino' ) );
            }
            if( $this->getRequestParameter( 'ProvinciaDestino' ) )
            {
                $a_Data['ProvinciaDestino'] = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'ProvinciaDestino' ) );
            }
            if( $this->getRequestParameter( 'DistritoDestino' ) )
            {
                $a_Data['DistritoDestino'] = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'DistritoDestino' ) );
            }
            if( $this->getRequestParameter( 'DireccionDestino' ) )
            {
                $a_Data['DireccionDestino'] = $this->getRequestParameter( 'DireccionDestino' );
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $o_GSS_CompaniaFN = new GSS_CompaniaFN();
            $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $IdCompania );
            
            $a_Data['Ruc']                = $o_GSS_CompaniaBN->getRuc();
            $a_Data['DireccionComun']     = $o_GSS_CompaniaBN->getDireccionComun();
            $a_Data['DireccionAdicional'] = $o_GSS_CompaniaBN->getDireccionAdicional();
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
            //$a_Data['o_VTA_DocumentoBN']      = $o_VTA_DocumentoBN;
            $a_Data['a_GuiaDetalle'] = $a_GuiaDetalle;
            ///////////////////////////////////////////////////////////////////////////
    
            //////////////////////////////////////////////////////////////////////////////////////
            $s_Class   = ParameterWR::getInstance()->getModule();
            $s_Module  = strtolower( $s_Class );
            $s_Action  = ParameterWR::getInstance()->getActions();
            //$s_Methods = ucwords( $s_Action );
    
            $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
            
            ob_start();
            require( $s_FileTemp );
            $s_vHtml = ob_get_contents();
            ob_end_clean();
            
            echo $s_vHtml;         exit;
    
            //ahora se registra la guia de remision
            //-> 1 si 
            /*$o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
            $o_SR_GuiaRemisionHDP->setMovimientoId( intval( $o_VTA_DocumentoBN->getNumeroDocumento() ) );
            $o_SR_GuiaRemisionHDP->setEstado( "I" );
            $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_SR_GuiaRemisionHDP->update_custom();*/
    
            $s_NumeroGuiaConcat = "";
            foreach ( $a_Data['serie_num'] as $a_Values ) 
            {
                $s_NumeroGuiaConcat = $a_Values['Serie']."-".$a_Values['Numero'];
                $s_GuiaRemisionId   = $a_Values['Serie'].$a_Values['Numero'];
                
                $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
                $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $s_GuiaRemisionId );
                $o_SR_GuiaRemisionHDP->setTipoGuia( $s_TipoProceso );
                $o_SR_GuiaRemisionHDP->setGuiaSerie( $a_Values['Serie'] );
                $o_SR_GuiaRemisionHDP->setGuiaNumero( $a_Values['Numero'] );
                $o_SR_GuiaRemisionHDP->setGuiaFecha( date( "Y-m-d H:i:s" ) );
                
                $o_SR_GuiaRemisionHDP->setReferenciaTipo( $o_VTA_DocumentoBN->getDocumentoCod() );
                $o_SR_GuiaRemisionHDP->setReferenciaNumero( $o_VTA_DocumentoBN->getDocumentoSerieNumero() );
                $o_SR_GuiaRemisionHDP->setMovimientoId( intval( $o_VTA_DocumentoBN->getNumeroDocumento() ) ); //EL ID DEL DOCUMENTO FACTURA O BOLETA
    
                $o_SR_GuiaRemisionHDP->setEstado( SR_GuiaRemisionHBN::ESTADO_COMPLETADO );
                $o_SR_GuiaRemisionHDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
                $o_SR_GuiaRemisionHDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
                $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_SR_GuiaRemisionHDP->save();
                
                //ahora se va a registrar los detalles
            }
            ///////////////////////////////////////
            
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //AHORA SE PROCEDE A REALIZAR EL PROCESO DE TRANSACCION DE INVENTARIO - SI SE ENCUENTRA HABILITADO :: 2021-01-13
            if( $s_TipoProceso == "DE" )
            {
                //if( GSS_ParametroMastFN::getValorPorTipo( "VT", "GUIA_REM" ) )
                if( myUser::getUser()->getObjectCompania()->getOpeDsctoStockEnGuiaR() )
                {
                    $o_VTA_DocumentoBN->setNumeroGuia( $s_NumeroGuiaConcat );

                    $o_VTA_DocumentoBN->setTipoDocumentoFiscal( $s_Tipo );
                    $o_VTA_DocumentoBN->setSerieDocumentoFiscal( $s_Serie );
                    $o_VTA_DocumentoBN->setNumeroDocumentoFiscal( $s_Numero );
                    $o_VTA_DocumentoBN->setIdTipoDocumentoTransaccion( VTA_DocumentoBN::TIPO_DOCUMENTO );
                    $o_VTA_DocumentoBN->setIdTransaccion( VTA_DocumentoBN::TRANSACCION_X_DEFECTO );
                    $o_VTA_DocumentoBN->setIdTransaccionOperacion( VTA_DocumentoBN::TIPO_TRANSACCION_X_DEFECTO );

                    $o_OrdenVentaBL = new OrdenVentaBL();
                    $o_ALM_TransaccionCabeceraBN = $o_OrdenVentaBL->generarTransaccion( $o_VTA_DocumentoBN, $a_TMP_VTA_DocumentoDetalle, true );

                    $s_IdNumeroDocumento = $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento();

                    //AHORA SE ACTUALIZA LA TRANSACCION EN LA GUIA DE REMISION

                }
            }
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            if( $this->getRequestParameter( 'IdMovimientoSerie' ) )
            {
                if( $b_ControlImpr )
                {
                    $o_SR_MovimientoDP = new SR_MovimientoDP();
                    $o_SR_MovimientoDP->setMovimientoId( ( int ) $s_IdMovimientoSerie );
                    $o_SR_MovimientoDP->setImpresionEstado( SR_MovimientoBN::ESTADO_IMP_C );
                    $o_SR_MovimientoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_SR_MovimientoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    //$o_SR_MovimientoDP->update();
                }
            }
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
            $con->commit();
    
            $options = new Options();
            //$options->set( 'isRemoteEnabled', TRUE );
            $options->setIsPhpEnabled( true );
    
            $dompdf = new Dompdf( $options );
            //$dompdf->setOption( 'isPhpEnabled', true );
            $dompdf->loadHtml( $s_vHtml );
            $dompdf->setPaper( 'A4', 'portrait' );
            $dompdf->render();
    
            //For Footer
            $canvas = $dompdf->get_canvas();
            $footer = $canvas->open_object();
            $font = "";
            $font_metrics = $dompdf->getFontMetrics();
            $font = $font_metrics->getFont( "helvetica", "bold" );
            //$canvas->page_text(35, 823, "HiveDesk Screenshot Report", $font, 8, array( 0, 0, 0 ) );
            //$canvas->page_text(250, 823, "Page:  {PAGE_NUM} of {PAGE_COUNT}", $font, 8, array( 0, 0, 0 ) );
            $canvas->page_text( 500, 823, date( "Y-m-d H:i:s" ), $font, 8, array( 0, 0, 0 ) );
            $canvas->close_object();
            $canvas->add_object( $footer, "all" );
    
            $dompdf->stream( $s_Tipo."_".$s_Serie."-".$s_Numero, array( "Attachment" => 0 ) );
        }
        catch ( Exception $o_Excepcion )
        {
            $con->rollback();
            pr( $o_Excepcion->getMessage() );
        }
        
        exit;
        //////////////////////////////////////////////////////////////////////////////////////
    }
}