<?php
use_helper( 'UrlFunctions' );
class GenerarGuiaRemAction extends wtActions
{
    public function execute()
    {
        $s_TipoProceso       = $this->getRequestParameter( 'TipoProceso' ); //POR AHORA SOLO HAY 2 TIPOS -> TR[TRANSFERENCIA] DE[DESPACHO][PARA VENTA]
        $s_IdMovimientoSerie = intval( $this->getRequestParameter( "IdMovimientoSerie" ) );
        $s_ControlProdFinal  = intval( $this->getRequestParameter( "ControlProdFinal" ) );
        $s_Tipo              = $this->getRequestParameter( "TipoDocumentoFiscal" );
        $s_Observaciones     = $this->getRequestParameter( "Observaciones" );
        
        $a_Result = array( "error" => false );
        $s_GuiaRemisionId = "";
        $s_CodigoError    = "";
        $b_ControlImpr    = true;

        $con = Conexion::getConexion();
        try
        {
            $con->begin();

            myUser::getUser()->validar_session();

            //VALIDACION DE PERIODO
            $s_Periodo     = date( "Ym" );
            $b_FlagPeriodo = PRO_CierreMensualFN::flagPeriodoAbierto( $s_Periodo );
            if( !$b_FlagPeriodo )
            {
                throw new Exception( "El Periodo se encuentra Cerrado." );
            }
            ///////////////////////

            //////////////////////////////////////////////////////////////////////////////////////////////////////
            //se recupera serie y numero de guia
            $s_Serie               = "";
            $s_Numero              = "";
            $s_FechaGuia           = date( "Y-m-d H:i:s" );
            $s_FechaInicioTraslado = $this->getRequestParameter( "FechaIniTraslado" );

            $i_IdCompania = null;
            $i_IdSucursal = null;

            $o_VTA_OrdenBN          = null;
            $o_VTA_DocumentoBN      = null;
            $a_VTA_DocumentoDetalle = null;

            $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
            $o_GSS_SucursalDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
            if( myUser::getUser()->getIdSucursal() )
            {
                $o_GSS_SucursalDocumentoFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            }
            $o_GSS_SucursalDocumentoFN->setIdTipoDocumento( $s_Tipo ); //GR -> Guia de Remision
            $a_GSS_SucursalDocumento = $o_GSS_SucursalDocumentoFN->select();
            if( $a_GSS_SucursalDocumento )
            {
                $o_GSS_SucursalDocumentoBN = $a_GSS_SucursalDocumento[0];

                $s_Serie  = $o_GSS_SucursalDocumentoBN->getSerieFormatoFinal();
                $s_Numero = $o_GSS_SucursalDocumentoBN->getNumeroActualFormato();
            }
            else
            {
                throw new Exception( "No se encuentra configurado el correlativo para la Guia de Remision." );
            }

            $o_SR_MovimientoFN = new SR_MovimientoFN();
            $o_SR_MovimientoBN = $o_SR_MovimientoFN->selectByPK( $s_IdMovimientoSerie );

            if( $o_SR_MovimientoBN->getTipoMovimiento() == "VTA" ) //&& $o_SR_MovimientoBN->getReferenciaTipo() == "OS"
            {
                $o_VTA_OrdenBN     = $o_SR_MovimientoBN->getObjectDocumentoReferencia();
                $o_VTA_DocumentoBN = $o_VTA_OrdenBN->getObjectVTADocumento();

                $s_IdTipoDocumento = $o_VTA_DocumentoBN->getIdTipoDocumento();
                $s_NumeroDocumento = $o_VTA_DocumentoBN->getNumeroDocumento();
                $s_DocumentoCod    = $o_VTA_DocumentoBN->getDocumentoCod();
                $s_DocumentoSerie  = $o_VTA_DocumentoBN->getDocumentoSerie();
                $s_DocumentoNumero = $o_VTA_DocumentoBN->getDocumentoNumero();

                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoBN->getArrayObjectDetalles();

                $i_IdCompania = $o_VTA_DocumentoBN->getIdCompania();

                $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $o_VTA_DocumentoBN->getClienteNumero() );

                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                /// validacion por direccion, se le da direccion del proyecto
                if( $o_VTA_DocumentoBN->getIdTipoDocumento() == VTA_DocumentoBN::TIPO_DOCUMENTO_BOLETA_VAL || $o_VTA_DocumentoBN->getIdTipoDocumento() == "NV" )
                {
                    if( !$o_VTA_DocumentoBN->getClienteDireccion() )
                    {
                        if( $o_VTA_DocumentoBN->getIdProyecto() )
                        {
                            $o_VTA_PrsProyectosFN       = new VTA_PrsProyectosFN();
                            $o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $o_VTA_DocumentoBN->getIdProyecto() );

                            $o_VTA_DocumentoBN->setClienteDireccion( $o_VTA_PrsProyectosBN->getDireccion() );

                            $o_MST_PersonaMastBN->setDepartamento( $o_VTA_PrsProyectosBN->getDepartamento() );
                            $o_MST_PersonaMastBN->setProvincia( $o_VTA_PrsProyectosBN->getProvincia() );
                            $o_MST_PersonaMastBN->setDistrito( $o_VTA_PrsProyectosBN->getDistrito() );
                            $o_MST_PersonaMastBN->setDireccion( $o_VTA_PrsProyectosBN->getDireccion()." - ".$o_VTA_PrsProyectosBN->getDepartamentoDesc()." - ".$o_VTA_PrsProyectosBN->getProvinciaDesc()." - ".$o_VTA_PrsProyectosBN->getDistritoDesc() );
                        }
                    }
                }
                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                $s_AlmacenDespacho = $o_SR_MovimientoBN->getAlmacen();
                $i_IdSucursal      = ALM_AlmacenMastFN::recuperarIdSucursal( $s_AlmacenDespacho );

                $o_GSS_SucursalFN = new GSS_SucursalFN();
                $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $i_IdSucursal );

                //ahora se recupera la direccion de Partida
                $s_PuntoPartidaUbigeo = $o_GSS_SucursalBN->getDistrito();
                $s_DepartamentoOrigen = MST_UbigeoFN::getDescripcionPorId( $o_GSS_SucursalBN->getDepartamento() );
                $s_ProvinciaOrigen    = MST_UbigeoFN::getDescripcionPorId( $o_GSS_SucursalBN->getProvincia() );
                $s_DistritoOrigen     = MST_UbigeoFN::getDescripcionPorId( $o_GSS_SucursalBN->getDistrito() );
                $s_DireccionOrigen    = $o_GSS_SucursalBN->getDireccion(); //." - ".$s_DepartamentoOrigen." - ".$s_ProvinciaOrigen." - ".$s_DistritoOrigen;

                //ahora se recupera la direccion de Destino
                $s_PuntoLlegadaUbigeo  = $o_MST_PersonaMastBN->getDistrito();
                $s_DepartamentoDestino = $o_MST_PersonaMastBN->getDepartamentoDesc();
                $s_ProvinciaDestino    = $o_MST_PersonaMastBN->getProvinciaDesc();
                $s_DistritoDestino     = $o_MST_PersonaMastBN->getDistritoDesc();
                $s_DireccionDestino    = $o_MST_PersonaMastBN->getDireccion(); //." - ".$s_DepartamentoDestino." - ".$s_ProvinciaDestino." - ".$s_DistritoDestino;
                $s_ClienteDireccion    = $o_MST_PersonaMastBN->getDireccion();

                $s_ClienteEmail        = $o_MST_PersonaMastBN->getEmail();

                //informacion
                $s_TipoDocumento     = $o_VTA_DocumentoBN->getClienteTipoDoc();
                $s_ClienteDocumento  = $o_VTA_DocumentoBN->getClienteRUC();
                $s_ClienteNombre     = $o_VTA_DocumentoBN->getClienteNombre();
                $s_TipoDocumentoDesc = $o_VTA_DocumentoBN->getTipoDocumentoDesc();
                $s_TipoSerieNumero   = $o_VTA_DocumentoBN->getDocumentoTipoSerieNumero();

                $o_GSS_CompaniaFN = new GSS_CompaniaFN();
                $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $i_IdCompania );

                $s_EmpresaNumDocumento  = $o_GSS_CompaniaBN->getRuc();
                $s_EmpresaDireccion     = $o_GSS_CompaniaBN->getDireccionComun();
                $s_EmpresaInfoAdicional = $o_GSS_CompaniaBN->getDireccionAdicional();

                $this->realizarTransaccionSeriesVTA( $o_VTA_DocumentoBN, $o_VTA_OrdenBN );
            }

            //////////////////////////////////////////////////////////////////////////////////////////////////////
            if( $o_VTA_DocumentoBN )
            {
                $s_Observaciones = "Comprobante: ".$o_VTA_DocumentoBN->getDocumentoTipoSerieNumero()." Pedido: ".$o_VTA_DocumentoBN->getDocumentoParentCod()." | ".$s_Observaciones;
            }
            else
            {
                throw new Exception( "No se encontro el comprobante." );
            }

            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //direccion de Partida - personalizado
            if( $this->getRequestParameter( 'DepartamentoOrigen' ) )
            {
                $s_DepartamentoOrigen = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'DepartamentoOrigen' ) );
            }
            if( $this->getRequestParameter( 'ProvinciaOrigen' ) )
            {
                $s_ProvinciaOrigen = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'ProvinciaOrigen' ) );
            }
            if( $this->getRequestParameter( 'DistritoOrigen' ) )
            {
                $s_PuntoPartidaUbigeo = $this->getRequestParameter( 'DistritoOrigen' );
                $s_DistritoOrigen     = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'DistritoOrigen' ) );
            }
            if( $this->getRequestParameter( 'DireccionOrigen' ) )
            {
                $s_DireccionOrigen = $this->getRequestParameter( 'DireccionOrigen' )." - ".$s_DepartamentoOrigen." ".$s_ProvinciaOrigen." ".$s_DistritoOrigen;
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //direccion de Destino - personalizado
            if( $this->getRequestParameter( 'DepartamentoDestino' ) )
            {
                $s_DepartamentoDestino = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'DepartamentoDestino' ) );
            }
            if( $this->getRequestParameter( 'ProvinciaDestino' ) )
            {
                $s_ProvinciaDestino = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'ProvinciaDestino' ) );
            }
            if( $this->getRequestParameter( 'DistritoDestino' ) )
            {
                $s_PuntoLlegadaUbigeo = $this->getRequestParameter( 'DistritoDestino' );
                $s_DistritoDestino    = MST_UbigeoFN::getDescripcionPorId( $this->getRequestParameter( 'DistritoDestino' ) );

                if( !$o_MST_PersonaMastBN->getDistrito() )
                {
                    $o_MST_PersonaMastDP = new MST_PersonaMastDP();
                    $o_MST_PersonaMastDP->setIdPersona( $o_MST_PersonaMastBN->getIdPersona() );
                    $o_MST_PersonaMastDP->setDepartamento( $this->getRequestParameter( 'DepartamentoDestino' ) );
                    $o_MST_PersonaMastDP->setProvincia( $this->getRequestParameter( 'ProvinciaDestino' ) );
                    $o_MST_PersonaMastDP->setDistrito( $this->getRequestParameter( 'DistritoDestino' ) );
                    $o_MST_PersonaMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_MST_PersonaMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_MST_PersonaMastDP->update();
                }
            }
            if( $this->getRequestParameter( 'DireccionDestino' ) )
            {
                $s_DireccionDestino = $this->getRequestParameter( 'DireccionDestino' );
                if( !$s_ClienteDireccion )
                {
                    $s_ClienteDireccion = $this->getRequestParameter( 'DireccionDestino' );
                }
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //VALIDACIONES:
            if( !$s_DireccionOrigen )
            {
                throw new Exception( "Error en punto de partida direccion" );
            }
            if( !$s_PuntoPartidaUbigeo )
            {
                throw new Exception( "Error en ubigeo en punto de PARTIDA" );
            }
            if( !$s_PuntoLlegadaUbigeo )
            {
                $s_PuntoLlegadaUbigeo = "";
                //throw new Exception( "Error en ubigeo en punto de LLEGADA" );
            }
            if( !$s_DireccionDestino )
            {
                $s_DireccionDestino = "";
                //throw new Exception( "Error en punto de llegada direccion" );
            }
            if( !$s_ClienteDireccion )
            {
                $s_ClienteDireccion = "";
                //throw new Exception( "Error en el cliente direccion" );
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //se recupera los parametros
            $a_IdItem        = $this->getRequestParameter( "IdItem" );
            $a_Secuencia     = $this->getRequestParameter( "Secuencia" );
            $a_ProFinalId    = $this->getRequestParameter( "ProFinalId" );
            $a_ProFinalDetId = $this->getRequestParameter( "ProFinalDetId" );
            $a_IdUnidad      = $this->getRequestParameter( "IdUnidad" );
            $a_Cantidad      = $this->getRequestParameter( "Cantidad" );

            //aqui se puede hacer una validacion: como que el stock sea mayor o igual a la cantidad pedida
            foreach( $a_IdItem as $i_Key => $s_IdItem )
            {
                $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_IdItem );

                $f_Cantidad      = floatval( $a_Cantidad[ $i_Key ] );
                $s_ProFinalDetId = $a_ProFinalDetId[ $i_Key ];

                if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER )
                {
                    if( $s_ControlProdFinal ) //SI ES PRODUCTO TERMINADO
                    {
                        //TIPO_PRODUCTOS_TERMINADOS
                        //pero primero de recupera
                        $o_VTA_ProductoFinalDetFN = new VTA_ProductoFinalDetFN();
                        $o_VTA_ProductoFinalDetBN = $o_VTA_ProductoFinalDetFN->selectByPK( $s_ProFinalDetId );
                        if( $o_VTA_ProductoFinalDetBN->getStockFisico() < $f_Cantidad )
                        {
                            throw new Exception( "El Producto [".$a_IdItem[ $i_Key ]."] no tiene StockSuficiente para efectuar el procedimiento. " );
                        }

                    }
                    else //SI SON ACCESORIOS
                    {
                        foreach( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN )
                        {
                            if( $o_VTA_DocumentoDetalleBN->getItemCodigo() == $a_IdItem[ $i_Key ] )
                            {
                                if( $o_VTA_DocumentoDetalleBN->getStockFisico() < $f_Cantidad )
                                {
                                    throw new Exception( "El Producto [".$a_IdItem[ $i_Key ]."] no tiene Stock Suficiente para efectuar el procedimiento. " );
                                }
                            }
                        }
                    }
                }
                else
                {
                    //aqui es venta
                    foreach( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN )
                    {
                        if( $o_VTA_DocumentoDetalleBN->getItemCodigo() == $a_IdItem[ $i_Key ] )
                        {
                            if( $o_VTA_DocumentoDetalleBN->getStockFisico() < $f_Cantidad )
                            {
                                throw new Exception( "El Producto [".$a_IdItem[ $i_Key ]."] no tiene Stock Suficiente para efectuar el procedimiento. " );
                            }
                        }
                    }
                }
            }
            //validacion de stock para venta y producto final
            if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_VENTA )
            {
                if( $s_ControlProdFinal ) //SI ES PRODUCTO TERMINADO
                {
                    $o_VTA_ProductoFinalFN = new VTA_ProductoFinalFN();
                    $o_VTA_ProductoFinalFN->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
                    $a_VTA_ProductoFinal = $o_VTA_ProductoFinalFN->select();
                    foreach( $a_VTA_ProductoFinal as $o_VTA_ProductoFinalBN )
                    {
                        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
                        $o_ALM_ItemAlmacenStockFN->setIdAlmacen( $o_VTA_ProductoFinalBN->getIdAlmacen() );
                        $o_ALM_ItemAlmacenStockFN->setIdItem( $o_VTA_ProductoFinalBN->getIdItem() );
                        $a_ALM_ItemAlmacenStock = $o_ALM_ItemAlmacenStockFN->select();
                        $f_StockFisico          = 0;
                        if( count( $a_ALM_ItemAlmacenStock ) == 1 )
                        {
                            $f_StockFisico = $a_ALM_ItemAlmacenStock[0]->getStockFisico();
                        }
                        if( $o_VTA_ProductoFinalBN->getCantidad() < $f_StockFisico )
                        {
                            throw new Exception( "El Producto [{$o_VTA_ProductoFinalBN->getIdItem()}] no tiene Stock Suficiente para efectuar el procedimiento. " );
                        }
                    }
                }
            }
            ////////////////////////////

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $s_MotivoTrasladoId = $this->getRequestParameter( "MotivoTrasladoId" );

            if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER )
            {
                //Si el Motivo de Traslado es 'Compra' o 'Traslado entre Establecimientos de la Misma Empresa', el Destinario debe de ser igual al RUC Emisor
                //$s_MotivoTrasladoId = "01"; //"04" = "TRASLADO ENTRE ESTABLECIMIENTOS DE LA MISMA EMPRESA"
                //aqui se remplaza varias cosas cuando es transferencia, pero para este caso siempre va ser venta:
                /*$s_ClienteDocumento = $o_GSS_CompaniaBN->getRuc();
                 $s_ClienteNombre    = $o_GSS_CompaniaBN->getDescripcionCorta();
                 $s_ClienteEmail     = $o_GSS_CompaniaBN->getEmailEmpresa();*/
            }
            if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_VENTA )
            {
                //$s_MotivoTrasladoId = "01"; //"01" = "VENTA"
            }

            $a_DataMotivo = SR_GuiaRemisionHBN::getArrayMotivoTraslado( $s_MotivoTrasladoId );
            $s_MotivoTrasladoProv = $a_DataMotivo['CodigoSunatPr'];

            $s_TipoDeTransporte   = $this->getRequestParameter( "TipoDeTransporteId" );
            $a_DataTipoTransporte = SR_GuiaRemisionHBN::getArrayTipoDeTransporte( $s_TipoDeTransporte );
            $s_TipoDeTransporteId = $a_DataTipoTransporte['CodigoSunatPr'];

            $i_IdChofer   = null;
            $i_IdVehiculo = null;

            $s_ConductorDocumentoTipo   = $this->getRequestParameter( "ConductorDocumentoTipo" ); //1 DNI | 6 = RUC  |
            $s_ConductorDocumentoNumero = utilString::eliminar_espacios( $this->getRequestParameter( "ConductorDocumentoNumero" ) );
            $s_ConductorDenominacion    = $this->getRequestParameter( "ConductorDenominacion" ); //nombre del conductor
            $s_ConductorNombre          = trim( $this->getRequestParameter( "ConductorNombre" ) ); //
            $s_ConductorApellido        = trim( $this->getRequestParameter( "ConductorApellido" ) ); //
            $s_ConductorNroLicencia     = trim( $this->getRequestParameter( "ConductorNroLicencia" ) ); //

            $s_TransportistaDocumentoTipo   = $this->getRequestParameter( "TransportistaDocumentoTipo" ); //1 DNI | 6 = RUC  |
            $s_TransportistaDocumentoNumero = utilString::eliminar_espacios( $this->getRequestParameter( "TransportistaDocumentoNumero" ) );
            $s_TransportistaDenominacion    = $this->getRequestParameter( "TransportistaDenominacion" ); //nombre del transportista
            $s_TransportistaPlacaNumero     = $this->getRequestParameter( "TransportistaPlacaNumero" );
            if( !$s_ConductorDenominacion )
            {
                $s_ConductorDenominacion = $s_ConductorNombre." ".$s_ConductorApellido;
            }

            if( $this->getRequestParameter( "TransporteDinamico" ) )
            {
                $i_IdChofer   = intval( $this->getRequestParameter( "IdChofer" ) );
                $i_IdVehiculo = intval( $this->getRequestParameter( "IdVehiculo" ) );

                $o_TR_VehiculoFN = new TR_VehiculoFN();
                $o_TR_VehiculoBN = $o_TR_VehiculoFN->selectByPK( $i_IdVehiculo );

                $s_TransportistaDocumentoTipo   = $o_TR_VehiculoBN->getTransportTipoDoc(); //1 DNI | 6 = RUC  |
                $s_TransportistaDocumentoNumero = $o_TR_VehiculoBN->getTransportNumDoc();
                $s_TransportistaDenominacion    = $o_TR_VehiculoBN->getTransportNombre(); //nombre del transportista
                $s_TransportistaPlacaNumero     = $o_TR_VehiculoBN->getVehiculoPlaca();

                $o_TR_ChoferFN = new TR_ChoferFN();
                $o_TR_ChoferBN = $o_TR_ChoferFN->selectByPK( $i_IdChofer );

                $s_ConductorDocumentoTipo   = $o_TR_ChoferBN->getChoferTipoDocumento(); //1 DNI | 6 = RUC  |
                $s_ConductorDocumentoNumero = $o_TR_ChoferBN->getChoferDocumento();
                $s_ConductorDenominacion    = $o_TR_ChoferBN->getChoferNombre()." ".$o_TR_ChoferBN->getChoferApellidoP()." ".$o_TR_ChoferBN->getChoferApellidoM(); //nombre del conductor
                $s_ConductorNombre          = $o_TR_ChoferBN->getChoferNombre();
                $s_ConductorApellido        = $o_TR_ChoferBN->getChoferApellidoP()." ".$o_TR_ChoferBN->getChoferApellidoM();
                $s_ConductorNroLicencia     = $o_TR_ChoferBN->getChoferLicencia();
            }
            if( $s_TransportistaDocumentoNumero == "" )
            {
                //throw new Exception( "Es necesario el numero de documento del Transportista." );
            }
            if( $s_TransportistaDenominacion == "" )
            {
                //throw new Exception( "Es necesario el nombre del Transportista." );
            }
            if( $s_ConductorDocumentoNumero == "" )
            {
                //throw new Exception( "Es necesario el numero de documento del Conductor." );
            }
            if( $s_ConductorDocumentoTipo == "1" )
            {
                if( strlen( $s_ConductorDocumentoNumero ) < 8 )
                {
                    //throw new Exception( "Es necesario el numero de documento del Conductor." );
                }
            }
            if( $s_ConductorDenominacion == "" && $s_TipoDeTransporte == "01" )
            {
                //throw new Exception( "Es necesario el nombre del Conductor." );
                $s_ConductorDenominacion = $s_ConductorNombre;
            }
            if( $s_ConductorNombre == "" )
            {
                //throw new Exception( "Es necesario el nombre del Conductor." );
            }
            if( $s_ConductorApellido == "" )
            {
                //throw new Exception( "Es necesario el apellido del Conductor." );
            }
            if( $s_ConductorNroLicencia == "" )
            {
                //throw new Exception( "Es necesario la licencia del Conductor." );
            }
            if( strlen( $s_ConductorNroLicencia ) < 9 )
            {
                //throw new Exception( "Número de Licencia de conducir del conductor es demasiado corto (9 caracteres mínimo)" );
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //LUEGO DE LAS VALIDACIONES
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //PARA INCREMENTAR EL CORRELATIVO
            //if( $o_VTA_DocumentoBN->getIdTipoDocumento() == "FC" || $o_VTA_DocumentoBN->getIdTipoDocumento() == "BV" ) //SOLO DE DEBE DE INCRMENTAR CUANDO ES FACTURA Y BOLETA Q SUBE A LA SUNAT
            //{                                                                                                          //PARA NOTA DE VENTA NO DEBERIA DE INCREMENTAR, PERO EL CORRELATIVO ES LA CONCATENACION DE SERIE Y NUMERO, SE TIENE Q CAMBIAR :-(
                $o_TMP_VTA_DocumentoBN = new VTA_DocumentoBN();
                $o_TMP_VTA_DocumentoBN->setIdCompania( myUser::getUser()->getIdBusiness() );
                $o_TMP_VTA_DocumentoBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_TMP_VTA_DocumentoBN->setIdTipoDocumento( $s_Tipo );
                $o_TMP_VTA_DocumentoBN->setDocumentoSerie( $s_Serie );
                $o_TMP_VTA_DocumentoBN->setDocumentoNumero( $s_Numero );
                $o_TMP_VTA_DocumentoBN->setEsGuiaRemision( true );

                $o_OrdenVentaBL = new OrdenVentaBL();
                $o_OrdenVentaBL->incrementarDocumentoNumero( $o_TMP_VTA_DocumentoBN );
                $s_Numero = $o_TMP_VTA_DocumentoBN->getDocumentoNumero();
            //}
            //////////////////////////////////////////////////////////////////////////////////////////////////////

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora se registra la cabecera de la guia
            $s_NumeroGuiaConcat   = $s_Serie."-".$s_Numero;
            $s_GuiaRemisionId     = $s_Serie.$s_Numero;
            $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
            $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $s_GuiaRemisionId );
            $o_SR_GuiaRemisionHDP->setIdCompania( $i_IdCompania );
            $o_SR_GuiaRemisionHDP->setIdSucursal( $i_IdSucursal );
            $o_SR_GuiaRemisionHDP->setTipoGuia( "DE" );
            $o_SR_GuiaRemisionHDP->setGuiaSerie( $s_Serie );
            $o_SR_GuiaRemisionHDP->setGuiaNumero( $s_Numero );
            $o_SR_GuiaRemisionHDP->setGuiaFecha( $s_FechaGuia );
            $o_SR_GuiaRemisionHDP->setFechaIniTraslado( $s_FechaInicioTraslado );
            $o_SR_GuiaRemisionHDP->setEstado( SR_GuiaRemisionHBN::ESTADO_COMPLETADO );
            //$o_SR_GuiaRemisionHDP->setEstadoDevolucion( SR_GuiaRemisionHBN::ESTADO_DEVOLUCION_PENDIENTE );
            $o_SR_GuiaRemisionHDP->setEstadoSunat( "P" );
            $o_SR_GuiaRemisionHDP->setComentario( $s_Observaciones );
            $o_SR_GuiaRemisionHDP->setConductorDocumentoTipo( ( int ) $s_ConductorDocumentoTipo ); //1 DNI | 6 = RUC  |
            $o_SR_GuiaRemisionHDP->setConductorDocumentoNumero( $s_ConductorDocumentoNumero );
            $o_SR_GuiaRemisionHDP->setConductorDenominacion( $s_ConductorDenominacion );
            $o_SR_GuiaRemisionHDP->setConductorNombre( $s_ConductorNombre );
            $o_SR_GuiaRemisionHDP->setConductorApellido( $s_ConductorApellido );
            $o_SR_GuiaRemisionHDP->setConductorNumeroLicencia( $s_ConductorNroLicencia );
            $o_SR_GuiaRemisionHDP->setTransportistaDocumentoTipo( ( int ) $s_TransportistaDocumentoTipo );  //1 DNI | 6 = RUC  |
            $o_SR_GuiaRemisionHDP->setTransportistaDocumentoNumero( $s_TransportistaDocumentoNumero );
            $o_SR_GuiaRemisionHDP->setTransportistaDenominacion( $s_TransportistaDenominacion );
            $o_SR_GuiaRemisionHDP->setTransportistaPlacaNumero( $s_TransportistaPlacaNumero );

            $o_SR_GuiaRemisionHDP->setIdProyecto( $o_VTA_OrdenBN->getIdProyecto() );
            $o_SR_GuiaRemisionHDP->setOrdenTipoComercialId( $o_VTA_OrdenBN->getOrdenTipoComercialId() );
            $o_SR_GuiaRemisionHDP->setReferenciaParentId( $o_VTA_OrdenBN->getOrdenId() );
            $o_SR_GuiaRemisionHDP->setReferenciaParentNum( $o_VTA_OrdenBN->getOrdenNum() );
            $o_SR_GuiaRemisionHDP->setReferenciaIdTipoDocumento( $s_IdTipoDocumento );
            $o_SR_GuiaRemisionHDP->setReferenciaTipo( $s_DocumentoCod );
            $o_SR_GuiaRemisionHDP->setReferenciaNumero( $s_DocumentoSerie."-".$s_DocumentoNumero );
            $o_SR_GuiaRemisionHDP->setReferenciaNumeroDocumento( $s_NumeroDocumento );

            $o_SR_GuiaRemisionHDP->setEmpresaTipoDoc( "RUC" );
            $o_SR_GuiaRemisionHDP->setEmpresaNumDoc( $s_EmpresaNumDocumento );
            $o_SR_GuiaRemisionHDP->setEmpresaDireccion( $s_EmpresaDireccion );
            $o_SR_GuiaRemisionHDP->setEmpresaInfoAdicional( $s_EmpresaInfoAdicional );

            $o_SR_GuiaRemisionHDP->setMovimientoId( $s_IdMovimientoSerie );

            $s_FechaInicioAlq = $this->getRequestParameter( 'FechaInicioAlq' );
            $s_FechaFinAlq    = $this->getRequestParameter( 'FechaFinAlq' );
            $o_SR_GuiaRemisionHDP->setFechaInicioAlq( $s_FechaInicioAlq );
            $o_SR_GuiaRemisionHDP->setFechaFinAlq( $s_FechaFinAlq );

            $o_SR_GuiaRemisionHDP->setClienteNombre( $s_ClienteNombre );
            $o_SR_GuiaRemisionHDP->setClienteTipoDocumento( $s_TipoDocumento );
            $o_SR_GuiaRemisionHDP->setClienteNumDocumento( $s_ClienteDocumento );

            $o_SR_GuiaRemisionHDP->setDepartamentoOrigen( $s_DepartamentoOrigen );
            $o_SR_GuiaRemisionHDP->setProvinciaOrigen( $s_ProvinciaOrigen );
            $o_SR_GuiaRemisionHDP->setDistritoOrigen( $s_DistritoOrigen );
            $o_SR_GuiaRemisionHDP->setDireccionOrigen( $s_DireccionOrigen );
            $o_SR_GuiaRemisionHDP->setUbigeoOrigen( $s_PuntoPartidaUbigeo );
            $o_SR_GuiaRemisionHDP->setDepartamentoDestino( $s_DepartamentoDestino );
            $o_SR_GuiaRemisionHDP->setProvinciaDestino( $s_ProvinciaDestino );
            $o_SR_GuiaRemisionHDP->setDistritoDestino( $s_DistritoDestino );
            $o_SR_GuiaRemisionHDP->setDireccionDestino( $s_DireccionDestino );
            $o_SR_GuiaRemisionHDP->setUbigeoDestino( $s_PuntoLlegadaUbigeo );
            $o_SR_GuiaRemisionHDP->setIdChofer( $i_IdChofer );
            $o_SR_GuiaRemisionHDP->setIdVehiculo( $i_IdVehiculo );
            $o_SR_GuiaRemisionHDP->setMotivoTrasladoId( $s_MotivoTrasladoId );
            $o_SR_GuiaRemisionHDP->setModalidadTransporteId( $s_TipoDeTransporte );
            $o_SR_GuiaRemisionHDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
            $o_SR_GuiaRemisionHDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
            $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_SR_GuiaRemisionHDP->save();

            //AHORA CUENTO CUANTAS GUIAS HAY POR LA COTIZACION
            $o_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
            //$o_SR_GuiaRemisionHFN->setReferenciaParentId( $o_VTA_OrdenBN->getOrdenId() );
            $o_SR_GuiaRemisionHFN->setIdProyecto( $o_VTA_OrdenBN->getIdProyecto() );
            $i_ContadorGuia = $o_SR_GuiaRemisionHFN->selectNumRows();

            //aqui se registra los detalles de la guia
            $a_TMP_VTA_DocumentoDetalle = array();
            $f_SumaPesoTotal            = 0;
            $f_NumeroBultos             = intval( $this->getRequestParameter( "TotalBulto" ) );
            if( $f_NumeroBultos <= 0 )
            {
                throw new Exception( "Es necesario la cantidad de Bultos." );
            }
            foreach( $a_IdItem as $i_Key => $s_IdItem )
            {
                $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_IdItem );

                $f_Cantidad = floatval( $a_Cantidad[ $i_Key ] );

                $s_Secuencia     = $a_Secuencia[ $i_Key ];
                $s_ProFinalId    = $a_ProFinalId[ $i_Key ];
                $s_ProFinalDetId = $a_ProFinalDetId[ $i_Key ];
                $s_IdUnidad      = $a_IdUnidad[ $i_Key ];

                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //AQUI SE IMPLEMENTA EL RESUMEN, PARA CONTROLAR LAS DEVOLUCIONES: PROYECTO, COTIZACION DETALLES Q NO SE REPITEN LOS DETALLES SUMANDO CANTIDAD ALQUILADA O PEDIDA
                if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER )
                {
                    if ( $f_Cantidad > 0 )
                    {
                        /*$o_VTA_ProductoFinalDetFN = new VTA_ProductoFinalDetFN();
                        $o_VTA_ProductoFinalDetBN = $o_VTA_ProductoFinalDetFN->selectByPK( $s_ProFinalDetId );
                        $f_CantidadRec = $o_VTA_ProductoFinalDetBN->getCantidadRecibida();*/

                        $o_SR_CotizacionDevolucionCabFN = new SR_CotizacionDevolucionCabFN();
                        $o_SR_CotizacionDevolucionCabFN->setIdProyecto( $o_VTA_OrdenBN->getIdProyecto() );
                        //$o_SR_CotizacionDevolucionCabFN->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );      //SE CAMBIO EL PROCEDIMIENTO, LA ORDEN NO ES RELAVANTE | 2021-05-24
                        $o_SR_CotizacionDevolucionCabFN->setIdItem( $s_IdItem );
                        $a_SR_CotizacionDevolucionCab = $o_SR_CotizacionDevolucionCabFN->select();
                        if ( $a_SR_CotizacionDevolucionCab )
                        {
                            //update
                            $o_SR_CotizacionDevolucionCabBN = $a_SR_CotizacionDevolucionCab[0];
                            $f_CantidadPedida               = $o_SR_CotizacionDevolucionCabBN->getCantidadPedida();
                            //$i_ContadorGuia = $o_SR_CotizacionDevolucionCabBN->getContadorGuia();

                            $o_SR_CotizacionDevolucionCabDP = new SR_CotizacionDevolucionCabDP();
                            $o_SR_CotizacionDevolucionCabDP->setCotiDevolucionId( $o_SR_CotizacionDevolucionCabBN->getCotiDevolucionId() );
                            $o_SR_CotizacionDevolucionCabDP->setContadorGuia( $i_ContadorGuia );
                            $o_SR_CotizacionDevolucionCabDP->setCantidadPedida( $f_CantidadPedida + $f_Cantidad );
                            $o_SR_CotizacionDevolucionCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_SR_CotizacionDevolucionCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_SR_CotizacionDevolucionCabDP->update();
                        }
                        else
                        {
                            //insert
                            $i_CotiDevolucionId = SR_CotizacionDevolucionCabDP::recuperarId();

                            $o_SR_CotizacionDevolucionCabDP = new SR_CotizacionDevolucionCabDP();
                            $o_SR_CotizacionDevolucionCabDP->setCotiDevolucionId( $i_CotiDevolucionId );
                            $o_SR_CotizacionDevolucionCabDP->setIdProyecto( $o_VTA_OrdenBN->getIdProyecto() );
                            //$o_SR_CotizacionDevolucionCabDP->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                            //$o_SR_CotizacionDevolucionCabDP->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
                            $o_SR_CotizacionDevolucionCabDP->setOrdenTipoComercialId( $o_VTA_OrdenBN->getOrdenTipoComercialId() );
                            $o_SR_CotizacionDevolucionCabDP->setOrdenTipoClasificacionId( $o_VTA_OrdenBN->getOrdenTipoClasificacionId() );
                            $o_SR_CotizacionDevolucionCabDP->setIdItem( $s_IdItem );
                            $o_SR_CotizacionDevolucionCabDP->setIdUnidad( ( int ) $s_IdUnidad );
                            $o_SR_CotizacionDevolucionCabDP->setItemDescripcion( $o_ALM_ItemMastBN->getDescripcionCompleta() );
                            $o_SR_CotizacionDevolucionCabDP->setContadorGuia( $i_ContadorGuia );
                            $o_SR_CotizacionDevolucionCabDP->setCantidadPedida( $f_Cantidad );
                            $o_SR_CotizacionDevolucionCabDP->setCantidadDevuelto( 0 );
                            $o_SR_CotizacionDevolucionCabDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                            $o_SR_CotizacionDevolucionCabDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                            $o_SR_CotizacionDevolucionCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_SR_CotizacionDevolucionCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_SR_CotizacionDevolucionCabDP->save();
                        }
                    }
                }
                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER )
                {
                    if( $s_ControlProdFinal ) //SI ES PRODUCTO TERMINADO
                    {
                        //TIPO_PRODUCTOS_TERMINADOS
                        if( $f_Cantidad > 0 )
                        {
                            $i_GuiaRemisionDetId = SR_GuiaRemisionDetDP::recuperarId();

                            $o_SR_GuiaRemisionDetDP = new SR_GuiaRemisionDetDP();
                            $o_SR_GuiaRemisionDetDP->setGuiaRemisionDetId( $i_GuiaRemisionDetId );
                            $o_SR_GuiaRemisionDetDP->setGuiaRemisionId( $s_GuiaRemisionId );
                            $o_SR_GuiaRemisionDetDP->setMovimientoId( $s_IdMovimientoSerie );
                            $o_SR_GuiaRemisionDetDP->setIdItem( $s_IdItem );
                            $o_SR_GuiaRemisionDetDP->setDescripcion( $o_ALM_ItemMastBN->getDescripcionCompleta() );
                            $o_SR_GuiaRemisionDetDP->setSecuencia( $s_Secuencia );
                            $o_SR_GuiaRemisionDetDP->setProFinalId( ( int ) $s_ProFinalId );
                            $o_SR_GuiaRemisionDetDP->setProFinalDetId( ( int ) $s_ProFinalDetId );
                            $o_SR_GuiaRemisionDetDP->setIdUnidad( ( int ) $s_IdUnidad );
                            $o_SR_GuiaRemisionDetDP->setCantidad( $f_Cantidad );
                            $o_SR_GuiaRemisionDetDP->setCantidadPendienteDevolucion( $f_Cantidad );
                            $o_SR_GuiaRemisionDetDP->setPesoUnitario( $o_ALM_ItemMastBN->getPesoGramos() );
                            $o_SR_GuiaRemisionDetDP->setPesoTotal( $o_ALM_ItemMastBN->getPesoGramos() * $f_Cantidad );
                            $o_SR_GuiaRemisionDetDP->save();

                            $f_SumaPesoTotal = $f_SumaPesoTotal + ( $o_ALM_ItemMastBN->getPesoGramos() * $f_Cantidad );

                            //pero primero de recupera
                            $o_VTA_ProductoFinalDetFN = new VTA_ProductoFinalDetFN();
                            $o_VTA_ProductoFinalDetBN = $o_VTA_ProductoFinalDetFN->selectByPK( $s_ProFinalDetId );
                            $f_CantidadRec            = $o_VTA_ProductoFinalDetBN->getCantidadRecibida();

                            //ahora se descuenta la cantidad recibida
                            $o_VTA_ProductoFinalDetDP = new VTA_ProductoFinalDetDP();
                            $o_VTA_ProductoFinalDetDP->setProFinalDetId( ( int ) $s_ProFinalDetId );
                            $o_VTA_ProductoFinalDetDP->setCantidadRecibida( $f_Cantidad + $f_CantidadRec );
                            $o_VTA_ProductoFinalDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_VTA_ProductoFinalDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_VTA_ProductoFinalDetDP->update();
                        }
                    }
                    else //SI SON ACCESORIOS
                    {
                        foreach( $a_VTA_DocumentoDetalle as $i_Cnt => $o_VTA_DocumentoDetalleBN )
                        {
                            if( $o_VTA_DocumentoDetalleBN->getItemCodigo() == $a_IdItem[ $i_Key ] )
                            {
                                if( $f_Cantidad > 0 )
                                {
                                    $f_CantidadRec       = $o_VTA_DocumentoDetalleBN->getCantidadRecibida();
                                    $i_GuiaRemisionDetId = SR_GuiaRemisionDetDP::recuperarId();

                                    $o_SR_GuiaRemisionDetDP = new SR_GuiaRemisionDetDP();
                                    $o_SR_GuiaRemisionDetDP->setGuiaRemisionDetId( $i_GuiaRemisionDetId );
                                    $o_SR_GuiaRemisionDetDP->setGuiaRemisionId( $s_GuiaRemisionId );
                                    $o_SR_GuiaRemisionDetDP->setMovimientoId( $s_IdMovimientoSerie );
                                    $o_SR_GuiaRemisionDetDP->setIdItem( $s_IdItem );
                                    $o_SR_GuiaRemisionDetDP->setDescripcion( $o_ALM_ItemMastBN->getDescripcionCompleta() );
                                    $o_SR_GuiaRemisionDetDP->setSecuencia( $s_Secuencia );
                                    $o_SR_GuiaRemisionDetDP->setProFinalId( ( int ) $s_ProFinalId );
                                    $o_SR_GuiaRemisionDetDP->setProFinalDetId( ( int ) $s_ProFinalDetId );
                                    $o_SR_GuiaRemisionDetDP->setIdUnidad( ( int ) $s_IdUnidad );
                                    $o_SR_GuiaRemisionDetDP->setCantidad( $f_Cantidad );
                                    $o_SR_GuiaRemisionDetDP->setCantidadPendienteDevolucion( $f_Cantidad );
                                    $o_SR_GuiaRemisionDetDP->setPesoUnitario( $o_ALM_ItemMastBN->getPesoGramos() );
                                    $o_SR_GuiaRemisionDetDP->setPesoTotal( $o_ALM_ItemMastBN->getPesoGramos() * $f_Cantidad );
                                    $o_SR_GuiaRemisionDetDP->save();

                                    $f_SumaPesoTotal = $f_SumaPesoTotal + ( $o_ALM_ItemMastBN->getPesoGramos() * $f_Cantidad );

                                    //ahora se actualiza la cantidad recibida
                                    $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP();
                                    $o_VTA_DocumentoDetalleDP->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                                    $o_VTA_DocumentoDetalleDP->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
                                    $o_VTA_DocumentoDetalleDP->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                                    $o_VTA_DocumentoDetalleDP->setSecuencia( $o_VTA_DocumentoDetalleBN->getSecuencia() );
                                    $o_VTA_DocumentoDetalleDP->setCantidadRecibida( ( $f_Cantidad + $f_CantidadRec ) );
                                    $o_VTA_DocumentoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                    $o_VTA_DocumentoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                    $o_VTA_DocumentoDetalleDP->update();

                                    $o_VTA_DocumentoDetalleBN->setCantidadRecibida( $f_Cantidad + $f_CantidadRec );
                                }
                            }
                        }
                    }
                }
                else
                {
                    //aqui es cuando es para venta
                    if( $s_ControlProdFinal ) //SI ES PRODUCTO TERMINADO
                    {
                        //TIPO_PRODUCTOS_TERMINADOS
                        if( $f_Cantidad > 0 )
                        {
                            $i_GuiaRemisionDetId = SR_GuiaRemisionDetDP::recuperarId();

                            $o_SR_GuiaRemisionDetDP = new SR_GuiaRemisionDetDP();
                            $o_SR_GuiaRemisionDetDP->setGuiaRemisionDetId( $i_GuiaRemisionDetId );
                            $o_SR_GuiaRemisionDetDP->setGuiaRemisionId( $s_GuiaRemisionId );
                            $o_SR_GuiaRemisionDetDP->setMovimientoId( $s_IdMovimientoSerie );
                            $o_SR_GuiaRemisionDetDP->setIdItem( $s_IdItem );
                            $o_SR_GuiaRemisionDetDP->setDescripcion( $o_ALM_ItemMastBN->getDescripcionCompleta() );
                            $o_SR_GuiaRemisionDetDP->setSecuencia( $s_Secuencia );
                            $o_SR_GuiaRemisionDetDP->setProFinalId( ( int ) $s_ProFinalId );
                            $o_SR_GuiaRemisionDetDP->setProFinalDetId( ( int ) $s_ProFinalDetId );
                            $o_SR_GuiaRemisionDetDP->setIdUnidad( ( int ) $s_IdUnidad );
                            $o_SR_GuiaRemisionDetDP->setCantidad( $f_Cantidad );
                            $o_SR_GuiaRemisionDetDP->setPesoUnitario( $o_ALM_ItemMastBN->getPesoGramos() );
                            $o_SR_GuiaRemisionDetDP->setPesoTotal( $o_ALM_ItemMastBN->getPesoGramos() * $f_Cantidad );
                            $o_SR_GuiaRemisionDetDP->save();

                            $f_SumaPesoTotal = $f_SumaPesoTotal + ( $o_ALM_ItemMastBN->getPesoGramos() * $f_Cantidad );

                            //pero primero de recupera
                            $o_VTA_ProductoFinalDetFN = new VTA_ProductoFinalDetFN();
                            $o_VTA_ProductoFinalDetBN = $o_VTA_ProductoFinalDetFN->selectByPK( $s_ProFinalDetId );
                            $f_CantidadRec            = $o_VTA_ProductoFinalDetBN->getCantidadRecibida();

                            //ahora se descuenta la cantidad recibida
                            $o_VTA_ProductoFinalDetDP = new VTA_ProductoFinalDetDP();
                            $o_VTA_ProductoFinalDetDP->setProFinalDetId( ( int ) $s_ProFinalDetId );
                            $o_VTA_ProductoFinalDetDP->setCantidadRecibida( $f_Cantidad + $f_CantidadRec );
                            $o_VTA_ProductoFinalDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_VTA_ProductoFinalDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_VTA_ProductoFinalDetDP->update();
                        }
                    }
                    else
                    {
                        //aqui es venta
                        foreach( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN )
                        {
                            if( $o_VTA_DocumentoDetalleBN->getItemCodigo() == $a_IdItem[ $i_Key ] )
                            {
                                if( $f_Cantidad > 0 )
                                {
                                    $f_CantidadRec       = $o_VTA_DocumentoDetalleBN->getCantidadRecibida();
                                    $i_GuiaRemisionDetId = SR_GuiaRemisionDetDP::recuperarId();

                                    $o_SR_GuiaRemisionDetDP = new SR_GuiaRemisionDetDP();
                                    $o_SR_GuiaRemisionDetDP->setGuiaRemisionDetId( $i_GuiaRemisionDetId );
                                    $o_SR_GuiaRemisionDetDP->setGuiaRemisionId( $s_GuiaRemisionId );
                                    $o_SR_GuiaRemisionDetDP->setMovimientoId( $s_IdMovimientoSerie );
                                    $o_SR_GuiaRemisionDetDP->setIdItem( $s_IdItem );
                                    $o_SR_GuiaRemisionDetDP->setDescripcion( $o_ALM_ItemMastBN->getDescripcionCompleta() );
                                    $o_SR_GuiaRemisionDetDP->setSecuencia( $s_Secuencia );
                                    $o_SR_GuiaRemisionDetDP->setProFinalId( ( int ) $s_ProFinalId );
                                    $o_SR_GuiaRemisionDetDP->setProFinalDetId( ( int ) $s_ProFinalDetId );
                                    $o_SR_GuiaRemisionDetDP->setIdUnidad( ( int ) $s_IdUnidad );
                                    $o_SR_GuiaRemisionDetDP->setCantidad( $f_Cantidad );
                                    $o_SR_GuiaRemisionDetDP->setPesoUnitario( $o_ALM_ItemMastBN->getPesoGramos() );
                                    $o_SR_GuiaRemisionDetDP->setPesoTotal( $o_ALM_ItemMastBN->getPesoGramos() * $f_Cantidad );
                                    $o_SR_GuiaRemisionDetDP->save();

                                    $f_SumaPesoTotal = $f_SumaPesoTotal + ( $o_ALM_ItemMastBN->getPesoGramos() * $f_Cantidad );

                                    $o_VTA_DocumentoDetalleBN->setCantidadaDescontar( $f_Cantidad );
                                    $o_VTA_DocumentoDetalleBN->setCantidadRecibida( $f_Cantidad + $f_CantidadRec );
                                    $a_TMP_VTA_DocumentoDetalle[] = $o_VTA_DocumentoDetalleBN;
                                }
                            }
                        }
                    }
                }
            }

            $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
            $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $s_GuiaRemisionId );
            $o_SR_GuiaRemisionHDP->setPesoTotal( $f_SumaPesoTotal );
            $o_SR_GuiaRemisionHDP->setNumeroBultos( $f_NumeroBultos );
            $o_SR_GuiaRemisionHDP->update();
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $o_SR_GuiaRemisionDetFN = new SR_GuiaRemisionDetFN();
            $o_SR_GuiaRemisionDetFN->setGuiaRemisionId( $s_GuiaRemisionId );
            $a_SR_GuiaRemisionDet = $o_SR_GuiaRemisionDetFN->select();

            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //aqui consultamos si ya salio del almacen

            $f_SumaCantidadPedida   = 0;
            $f_SumaCantidadRecibida = 0;
            if( $s_ControlProdFinal )
            {
                //SI ES PRODUCTO TERMINADO
                $o_VTA_ProductoFinalDetFN = new VTA_ProductoFinalDetFN();
                $o_VTA_ProductoFinalDetFN->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
                $a_VTA_ProductoFinalDet = $o_VTA_ProductoFinalDetFN->select();
                foreach( $a_VTA_ProductoFinalDet as $o_VTA_ProductoFinalDetBN )
                {
                    $f_SumaCantidadPedida   = $f_SumaCantidadPedida + $o_VTA_ProductoFinalDetBN->getCantidad();
                    $f_SumaCantidadRecibida = $f_SumaCantidadRecibida + $o_VTA_ProductoFinalDetBN->getCantidadRecibida();
                }
            }
            else
            {
                //accesorios
                foreach( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN )
                {
                    $f_SumaCantidadPedida   = $f_SumaCantidadPedida + $o_VTA_DocumentoDetalleBN->getCantidadPedida();
                    $f_SumaCantidadRecibida = $f_SumaCantidadRecibida + $o_VTA_DocumentoDetalleBN->getCantidadRecibida();
                }
            }
            //AHORA SE PREGUNTA, QUE LA SUMA ENTRE CANTIDADES: PEDIDA Y ENTREGADA SEAN IGUALES
            //pr( " if( $f_SumaCantidadPedida != $f_SumaCantidadRecibida ) " ); exit;
            if( $f_SumaCantidadPedida != $f_SumaCantidadRecibida )
            {
                $b_ControlImpr = false;
            }
            if( $f_SumaCantidadRecibida > $f_SumaCantidadPedida )
            {
                throw new Exception( "ACTUALIZAR" );
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            if( $s_TipoProceso == "DE" )
            {
                //if( GSS_ParametroMastFN::getValorPorTipo( "VT", "GUIA_REM" ) )
                if( myUser::getUser()->getObjectCompania()->getOpeDsctoStockEnGuiaR() )
                {
                    //ahora se realiza las transacciones
                    if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER )
                    {
                        //aqui se realiza transferencias
                        $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
                        $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( "NT" );
                        $o_ALM_TransaccionCabeceraBN->setIdTransaccion( "TRA" ); //transferencia
                        $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $o_VTA_OrdenBN->getAlmacenDespacho() ); //almacen despacho
                        $o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( "A1302" ); //alquiler
                        $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( ALM_TransaccionCabeceraBN::TIPO_TRANSFERENCIA );
                        $o_ALM_TransaccionCabeceraBN->setFechaDocumento( date( "Y-m-d H:i:s" ) );
                        $o_ALM_TransaccionCabeceraBN->setTipodeCambio( $o_VTA_OrdenBN->getMonedaCambioValor() );
                        $o_ALM_TransaccionCabeceraBN->setMonedaCod( $o_VTA_OrdenBN->getMonedaCod() );
                        $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( "CZ" );
                        $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( ( string ) $o_VTA_OrdenBN->getOrdenId() );
                        $o_ALM_TransaccionCabeceraBN->setIdProyecto( $o_VTA_OrdenBN->getIdProyecto() );
                        //$o_ALM_TransaccionCabeceraBN->setComentario( $o_DefaultBN->getComentario() );
                        $o_ALM_TransaccionCabeceraBN->setCodigoCliente( GSS_ParametroMastFN::getValorParam( "AL", "PR_ID_COMPANIA" ) );

                        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
                        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $s_Tipo );

                        $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $s_Tipo ); //$o_VTA_DocumentoBN->getIdTipoDocumento()
                        $o_ALM_TransaccionCabeceraBN->getCodDocumentoFiscal( $o_VTA_TipoDocumentoBN->getTipoDocumentoCod() );
                        $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $s_Serie ); //$o_VTA_DocumentoBN->getDocumentoSerie()
                        $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $s_Numero ); //$o_VTA_DocumentoBN->getDocumentoNumero()
                        $o_ALM_TransaccionCabeceraBN->setFechaDocumentoFiscal( substr( $s_FechaGuia, 0, 10 ) );
                        
                        $a_DataTxrDet = array();
                        foreach ( $a_SR_GuiaRemisionDet as $i_Key => $o_SR_GuiaRemisionDetBN )
                        {
                            $f_Cantidad = $o_SR_GuiaRemisionDetBN->getCantidad();
                            
                            if( isset( $a_DataTxrDet[$o_SR_GuiaRemisionDetBN->getIdItem()] ) )
                            {
                                $a_DataTxrDet[$o_SR_GuiaRemisionDetBN->getIdItem()]['Cantidad'] = $a_DataTxrDet[$o_SR_GuiaRemisionDetBN->getIdItem()]['Cantidad'] + $f_Cantidad;
                                continue;
                            }
                            
                            //se suma los duplicados
                            $a_DataTxrDet[$o_SR_GuiaRemisionDetBN->getIdItem()] = array
                            (
                                    "IdItem"         => $o_SR_GuiaRemisionDetBN->getIdItem(),
                                    "Cantidad"       => $o_SR_GuiaRemisionDetBN->getCantidad(),
                                    "IdUnidad"       => ( string ) $o_SR_GuiaRemisionDetBN->getIdUnidad(),
                                    "PrecioUnitario" => 0
                            );
                        }
                        
                        foreach( $a_DataTxrDet as $s_IdItem => $a_Valores )
                        {
                            $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
                            $o_ALM_TransaccionDetalleBN->setIdItem( $s_IdItem );
                            $o_ALM_TransaccionDetalleBN->setCantidad( $a_Valores['Cantidad'] );
                            $o_ALM_TransaccionDetalleBN->setUnidadCodigo( $a_Valores['IdUnidad'] );
                            $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $a_Valores['PrecioUnitario'] );
                            $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;
                        }
                        
                        $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );

                        $o_MovimientoBL = new MovimientoBL();
                        $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );
                        
                        $s_IdTipoDocumento   = $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento();
                        $s_IdNumeroDocumento = $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento();
                        $s_IdTransaccion     = $o_ALM_TransaccionCabeceraBN->getIdTransaccion();
                        
                        //ahora se actualiza la transaccion en la guia
                        $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
                        $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $s_GuiaRemisionId );
                        $o_SR_GuiaRemisionHDP->setIdTipoDocumento( $s_IdTipoDocumento );
                        $o_SR_GuiaRemisionHDP->setIdNumeroDocumento( $s_IdNumeroDocumento );
                        $o_SR_GuiaRemisionHDP->setIdTransaccion( $s_IdTransaccion );
                        $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_SR_GuiaRemisionHDP->update();
                    }
                    else
                    {
                        //PARA VENTA
                        if( $s_ControlProdFinal ) //SI ES PRODUCTO TERMINADO
                        {
                            //se controla que todos la materia prima se haya repartido el total, para realizar la salida de inventario pero del producto final
                            if( $b_ControlImpr )
                            {
                                //AQUI SE REALIZA LA SALIDA
                                $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
                                $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( VTA_DocumentoBN::TIPO_DOCUMENTO );
                                $o_ALM_TransaccionCabeceraBN->setIdTransaccion( VTA_DocumentoBN::TRANSACCION_X_DEFECTO ); //SALIDA POR SERVICIO DE PRODUCCIÓN
                                //$o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( "A1303" ); //alquiler
                                $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $o_VTA_OrdenBN->getAlmacenDespacho() ); //almacen produccion
                                $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( ALM_TransaccionCabeceraBN::TIPO_SALIDA );
                                $o_ALM_TransaccionCabeceraBN->setFechaDocumento( date( "Y-m-d H:i:s" ) );
                                $o_ALM_TransaccionCabeceraBN->setTipodeCambio( GSS_TipoCambioFN::getStaticTipoCambioCobranza() );
                                $o_ALM_TransaccionCabeceraBN->setMonedaCod( $o_VTA_OrdenBN->getMonedaCod() );
                                $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() ); //ORDEN DE PRODUCCION -> VTA_TipoDocumento
                                $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                                $o_ALM_TransaccionCabeceraBN->setIdProyecto( $o_VTA_DocumentoBN->getIdProyecto() );
                                //$o_ALM_TransaccionCabeceraBN->setComentario( $o_DefaultBN->getComentario() );
                                $o_ALM_TransaccionCabeceraBN->setCodigoCliente( GSS_ParametroMastFN::getValorParam( "AL", "PR_ID_COMPANIA" ) ); //ID DE LA EMPRESA POR DEFECTO
                                
                                /*$o_utilGenerateId = new utilGenerateId();
                                $o_utilGenerateId->setIdCompania( -1 );
                                $o_utilGenerateId->setTipoCorrelativo( "CTRINT" );
                                $o_utilGenerateId->setSerie( "TIPO" );
                                $i_IdCrtl = $o_utilGenerateId->generateId();
                                
                                $s_Tipo = "CT";
                                $s_Serie = "0001";
                                $s_Numero = str_pad( $i_IdCrtl, 10, "0", STR_PAD_LEFT );*/

                                $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $o_VTA_DocumentoBN->getIdTipoDocumento() ); //$o_VTA_DocumentoBN->getIdTipoDocumento()
                                $o_ALM_TransaccionCabeceraBN->getCodDocumentoFiscal( $o_VTA_DocumentoBN->getDocumentoCod() );
                                $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $o_VTA_DocumentoBN->getDocumentoSerie() ); //$o_VTA_DocumentoBN->getDocumentoSerie()
                                $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $o_VTA_DocumentoBN->getNumeroComprobante() ); //$o_VTA_DocumentoBN->getDocumentoNumero()
                                $o_ALM_TransaccionCabeceraBN->setFechaDocumentoFiscal( substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 ) );
                                
                                $a_MovientoDetalle = array();
                                $o_VTA_ProductoFinalFN = new VTA_ProductoFinalFN();
                                $o_VTA_ProductoFinalFN->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
                                $a_VTA_ProductoFinal = $o_VTA_ProductoFinalFN->select();
                                foreach ( $a_VTA_ProductoFinal as $o_VTA_ProductoFinalBN )
                                {
                                    $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
                                    $o_ALM_TransaccionDetalleBN->setIdItem( $o_VTA_ProductoFinalBN->getIdItem() );
                                    $o_ALM_TransaccionDetalleBN->setCantidad( $o_VTA_ProductoFinalBN->getCantidad() );
                                    $o_ALM_TransaccionDetalleBN->setUnidadCodigo( ( string ) $o_VTA_ProductoFinalBN->getIdUnidad() );
                                    $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $o_VTA_ProductoFinalBN->getPrecioCostoUnit() );
                                    $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;
                                    
                                    //ahora se actualiza la cantidad entregada
                                    $o_VTA_ProductoFinalDP = new VTA_ProductoFinalDP();
                                    $o_VTA_ProductoFinalDP->setProFinalId( $o_VTA_ProductoFinalBN->getProFinalId() );
                                    $o_VTA_ProductoFinalDP->setCantidadRecibida( $o_VTA_ProductoFinalBN->getCantidad() );
                                    $o_VTA_ProductoFinalDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                    $o_VTA_ProductoFinalDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                    $o_VTA_ProductoFinalDP->update();
                                }
                                $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );
                                
                                $o_MovimientoBL = new MovimientoBL();
                                $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );

                                $s_IdTipoDocumento   = $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento();
                                $s_IdNumeroDocumento = $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento();
                                $s_IdTransaccion     = $o_ALM_TransaccionCabeceraBN->getIdTransaccion();
                                
                                //aqui podemos guarda la relacion de la transaccion, eso tambien puede identificar q realmente salio
                                //ahora se actualiza la transaccion en la guia
                                $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
                                $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $s_GuiaRemisionId );
                                $o_SR_GuiaRemisionHDP->setIdTipoDocumento( $s_IdTipoDocumento );
                                $o_SR_GuiaRemisionHDP->setIdNumeroDocumento( $s_IdNumeroDocumento );
                                $o_SR_GuiaRemisionHDP->setIdTransaccion( $s_IdTransaccion );
                                $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                $o_SR_GuiaRemisionHDP->update();
                            }
                        }
                        else
                        {
                            //accesorios
                            $o_VTA_DocumentoBN->setNumeroGuia( $s_NumeroGuiaConcat );
                            
                            $o_VTA_DocumentoBN->setTipoDocumentoFiscal( $s_Tipo );     //SE COMENTA PARA Q EL NUMERO FISCAL SEA EL MISMO DEL COMPROBANTE
                            $o_VTA_DocumentoBN->setSerieDocumentoFiscal( $s_Serie );   //SE COMENTA PARA Q EL NUMERO FISCAL SEA EL MISMO DEL COMPROBANTE
                            $o_VTA_DocumentoBN->setNumeroDocumentoFiscal( $s_Numero ); //SE COMENTA PARA Q EL NUMERO FISCAL SEA EL MISMO DEL COMPROBANTE

                            $o_VTA_DocumentoBN->setIdTipoDocumentoTransaccion( VTA_DocumentoBN::TIPO_DOCUMENTO );
                            $o_VTA_DocumentoBN->setIdTransaccion( VTA_DocumentoBN::TRANSACCION_X_DEFECTO );
                            $o_VTA_DocumentoBN->setIdTransaccionOperacion( VTA_DocumentoBN::TIPO_TRANSACCION_X_DEFECTO );

                            $o_OrdenVentaBL = new OrdenVentaBL();
                            $o_ALM_TransaccionCabeceraBN = $o_OrdenVentaBL->generarTransaccion( $o_VTA_DocumentoBN, $a_TMP_VTA_DocumentoDetalle, $b_ControlImpr );
                            
                            $s_IdTipoDocumento   = $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento();
                            $s_IdNumeroDocumento = $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento();
                            $s_IdTransaccion     = $o_ALM_TransaccionCabeceraBN->getIdTransaccion();
                            
                            //ahora se actualiza la transaccion en la guia
                            $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
                            $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $s_GuiaRemisionId );
                            $o_SR_GuiaRemisionHDP->setIdTipoDocumento( $s_IdTipoDocumento );
                            $o_SR_GuiaRemisionHDP->setIdNumeroDocumento( $s_IdNumeroDocumento );
                            $o_SR_GuiaRemisionHDP->setIdTransaccion( $s_IdTransaccion );
                            $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_SR_GuiaRemisionHDP->update();
                        }
                    }
                }
                
                /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                if( $b_ControlImpr )
                {
                    //se cambia el estado de las guias asociadas a la cotizacion (porcia) | por sermaqui 2021-05-09
                    /*$o_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
                    $o_SR_GuiaRemisionHFN->setReferenciaParentId( $o_VTA_OrdenBN->getOrdenId() );
                    $a_SR_GuiaRemision = $o_SR_GuiaRemisionHFN->select();
                    foreach ( $a_SR_GuiaRemision as $o_SR_GuiaRemisionBN )
                    {
                        $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
                        $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $o_SR_GuiaRemisionBN-> getGuiaRemisionId() );
                        $o_SR_GuiaRemisionHDP->setEstadoDevolucion( "P" );
                        $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        //$o_SR_GuiaRemisionHDP->update(); EVALUAR DETENIDAMENTE............
                    }*/

                    //AQUI SE AGREGA EL ESTADO DE DEVOLUCION POR PROYECTO
                    $o_VTA_PrsProyectosFN = new VTA_PrsProyectosFN();
                    $o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $o_VTA_OrdenBN->getIdProyecto() );
                    if( $o_VTA_PrsProyectosBN )
                    {
                        $o_VTA_PrsProyectosDP = new VTA_PrsProyectosDP();
                        $o_VTA_PrsProyectosDP->setIdProyecto( $o_VTA_OrdenBN->getIdProyecto() );
                        $o_VTA_PrsProyectosDP->setEstadoDevolucion( VTA_PrsProyectosBN::ESTADO_DEVOLUCION_PENDIENTE );
                        if( !$o_VTA_PrsProyectosBN->getFechaInicioDespacho() )
                        {
                            $o_VTA_PrsProyectosDP->setFechaInicioDespacho( date( "Y-m-d" ) );
                        }
                        $o_VTA_PrsProyectosDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_VTA_PrsProyectosDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_VTA_PrsProyectosDP->update();
                    }

                    //ahora de cambia el estado devolucion a la cotizacion | por sermaqui 2021-05-09
                    $o_VTA_OrdenDP = new VTA_OrdenDP();
                    $o_VTA_OrdenDP->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
                    $o_VTA_OrdenDP->setEstadoDevolucion( "P" );
                    $o_VTA_OrdenDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_OrdenDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                    $o_VTA_OrdenDP->update();
                    
                    //se cambia el estado donde se indica q se termino de despachar
                    $o_SR_MovimientoDP = new SR_MovimientoDP();
                    $o_SR_MovimientoDP->setMovimientoId( ( int ) $s_IdMovimientoSerie );
                    $o_SR_MovimientoDP->setImpresionEstado( SR_MovimientoBN::ESTADO_IMP_C );
                    $o_SR_MovimientoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_SR_MovimientoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_SR_MovimientoDP->update();
                }
                /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            }
        }
        catch ( Exception $o_Exception )
        {
            //pr( $o_Exception );
            $con->rollback();
            $a_Result['error'] = true;
            $a_Result['mensaje_error'] = $o_Exception->getMessage();
        }

        if( !$a_Result['error'] )
        {
            try
            {
                $o_iDespacho = new iDespacho();
                $a_Data = $o_iDespacho->enviarSunatGuiaRemision( $s_GuiaRemisionId );
                $a_Result['enlace_pdf'] = $a_Data['EnlaceDelPdf'];
                $a_Result['enlace_pdf'] = buildUrlComplet( "alm.php/transporte/printGuiaPDF", "Id=".$s_GuiaRemisionId );
                $con->commit();
            }
            catch ( Exception $o_Exception )
            {
                //pr( $o_Exception );
                $con->rollback();
                $a_Result['error'] = true;
                $a_Result['mensaje_error'] = $o_Exception->getMessage();
            }
        }
        
        echo json_encode( $a_Result );
        exit;
        return ViewResponse::NONE;
    }

    public function realizarTransaccionSeriesVTA( VTA_DocumentoBN $o_VTA_DocumentoBN, VTA_OrdenBN $o_VTA_OrdenBN )
    {
        if( $o_VTA_DocumentoBN )
        {
            //por ahora la referencia principal es la orden de venta
            if( $o_VTA_OrdenBN )
            {
                $a_VTA_OrdenDetalle = $o_VTA_OrdenBN->getArrayDetalles();
                foreach ( $a_VTA_OrdenDetalle as $o_VTA_OrdenDetalleBN )
                {
                    $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                    $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_VTA_OrdenDetalleBN->getItemCod() );

                    if( $o_VTA_OrdenDetalleBN->getItemTipo() != VTA_OrdenDetalleBN::TIPO_COMENTARIO )
                    {
                        if( $o_ALM_ItemMastBN->SiManejaSerie() )
                        {
                            $o_SR_MovimientoFN = new SR_MovimientoFN();
                            $o_SR_MovimientoFN->setTipoMovimiento( VTA_DocumentoBN::TRANSACCION_X_DEFECTO );
                            $o_SR_MovimientoFN->setOperacion( ALM_TransaccionCabeceraBN::TIPO_SALIDA );
                            $o_SR_MovimientoFN->setAlmacen( $o_VTA_DocumentoBN->getAlmacenDespacho() );
                            $o_SR_MovimientoFN->setReferenciaTipo( $o_VTA_DocumentoBN->getIdTipoDocumento() ); //OS
                            $o_SR_MovimientoFN->setReferenciaNumero( $o_VTA_DocumentoBN->getNumeroDocumento() ); //$o_VTA_OrdenBN->getOrdenNum()
                            //$o_SR_MovimientoFN->setReferenciaFecha( $o_VTA_OrdenBN->getOrdenFecha() );
                            $o_SR_MovimientoFN->setEstado( "C" );
                            $a_SR_Movimiento = $o_SR_MovimientoFN->select();
                            if( $a_SR_Movimiento )
                            {
                                $o_SR_MovimientoBN = $a_SR_Movimiento[0];

                                $o_SR_MovimientoDetalleBN = new SR_MovimientoDetalleBN();
                                $o_SR_MovimientoDetalleBN->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
                                $o_SR_MovimientoDetalleBN->setProductoId( $o_ALM_ItemMastBN->getIdItem() );

                                $o_SR_MovimientoBN->setMovimientoDetalleObject( $o_SR_MovimientoDetalleBN );

                                $o_SerieBL = new SerieBL();
                                $o_SerieBL->realizarTransaccionH( $o_SR_MovimientoBN );
                            }
                        }
                    }
                }
            }
        }
    }
}