<?php
class transaccionesActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->setEstado( "A" );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::Nombres );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $this->a_ALM_AlmacenMastOrg = $o_ALM_AlmacenMastFN->select();
        
        $this->a_ALM_AlmacenMastDst = $o_ALM_AlmacenMastFN->select();
        
        $this->a_TipoTransaccion = ALM_TransaccionCabeceraBN::getArrayTipoTransaccion();
        
        $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN(); //PARA DOCUMENTO DE REFENCIA
        $o_ALM_TipoDocumentoFN->setEstado( "A" );
        $o_ALM_TipoDocumentoFN->addOrderBy( ALM_TipoDocumentoFN::Descripcion );
        $this->a_ALM_TipoDocumento = $o_ALM_TipoDocumentoFN->select();
        
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastFN->addOrderBy( ALM_TransaccionMastFN::DescripcionLocal );
        $o_ALM_TransaccionMastFN->addCondition( ALM_TransaccionMastFN::IngresoEgresoFlag, "IN", "( 'I', 'E' )", false );
        $this->a_ALM_TransaccionMast  = $o_ALM_TransaccionMastFN->select();
    }
    
    public function executeGrid()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_TransaccionCabeceraFN() );
        
        $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdAlmacen" );
        $o_GridAction->addAssignFilter( "IdTransaccionOperacion" );
        $o_GridAction->addAssignFilter( "IdTransaccion" );
        $o_GridAction->addAssignFilter( "IdNumeroDocumento" );
        $o_GridAction->addAssignFilter( "ReferenciaNumeroDocumento" );
        $o_GridAction->addAssignFilter( "CodigoProveedor" );
        $o_GridAction->addAssignFilter( "TipoDocumentoFiscal" );
        
        $o_GridAction->addConditionFilter( "SerieDocumentoFiscal", ALM_TransaccionCabeceraFN::SerieDocumentoFiscal, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "NumeroDocumentoFiscal", ALM_TransaccionCabeceraFN::NumeroDocumentoFiscal, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", ALM_TransaccionCabeceraFN::FechaDocumento,    ">=" );
        $o_GridAction->addConditionFilter( "FechaDocumento2", ALM_TransaccionCabeceraFN::FechaDocumento,    "<=" );
        
        //$o_GridAction->addOrder( "Codigo",           GSS_CompaniaFN::Codigo );
        //$o_GridAction->addOrder( "DescripcionCorta", GSS_CompaniaFN::DescripcionCorta );
        //$o_GridAction->addOrder( "Ruc",              GSS_CompaniaFN::Ruc );
        
        $o_GridAction->addOrderDefault( ALM_TransaccionCabeceraFN::FechaCreacion, false );
        
        $o_GridAction->addRowsToShow( 
                                        "IdTransaccionCabeceraConcat", "IdTipoDocumento", "IdNumeroDocumento", "FechaDocumentoPer", "IdTransaccion", "IdAlmacen", 
                                        "AlmacenTraslado", "ReferenciaNumeroDocumento", "DocumentoRefFiscal", "UsuarioCreacion", "TipoDocumentoFiscalDesc"
                                    );
        
        $o_GridAction->addInnerJoin( new ALM_TransaccionMastFN(), "IdTransaccion", "DescripcionLocal" );
        $o_GridAction->addInnerJoin( new ALM_AlmacenMastFN(), "IdAlmacen", "DescripcionLocal" );
        $o_GridAction->addInnerJoin( new ALM_AlmacenMastFN(), "AlmacenTraslado", "DescripcionLocal" );
        $o_GridAction->addInnerJoin( new ALM_TipoDocumentoFN(), "IdTipoDocumento", "Descripcion" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaFN->setEstado( "A" );
        $o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::DescripcionCorta );
        $this->a_GSS_Compania= $o_GSS_CompaniaFN->select();
        
        $this->a_TipoTransaccion = ALM_TransaccionCabeceraBN::getArrayTipoTransaccion();
        
        $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN(); //PARA DOCUMENTO DE REFENCIA
        $o_ALM_TipoDocumentoFN->setEstado( "A" );
        //$o_ALM_TipoDocumentoFN->setTransaccionSistemaFlag( "S" );
        $this->a_ALM_TipoDocumento = $o_ALM_TipoDocumentoFN->select();
        
        $this->a_ALM_TransaccionMast = array();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::Estado ,"<>", "I" );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );

        $this->a_ALM_AlmacenMastOrg = $o_ALM_AlmacenMastFN->select();
        $this->a_ALM_AlmacenMastDst = $o_ALM_AlmacenMastFN->select();
        
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $this->a_MST_UnidadMast = $o_MST_UnidadMastFN->select();
        
        $this->TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
        
        $this->s_Titulo = "Nueva Transacción";
        $this->noedit = "";
        
        $this->o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
        $this->o_ALM_TransaccionCabeceraBN->setFechaDocumento( date( "Y-m-d" ) );
        $this->o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( "I" );
        if( $this->s_TipoProc == "upd" )
        {
            $a_Ids = explode( "_", $this->i_Id );
            $IdCompania      = $a_Ids[0];
            $IdTipoDocumento = $a_Ids[1];
            $NumeroDocumento = $a_Ids[2];
            
            $this->s_Titulo = "Editar Transacción";
            $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
            $this->o_ALM_TransaccionCabeceraBN = $o_ALM_TransaccionCabeceraFN->selectByPK( $IdCompania, $IdTipoDocumento, $NumeroDocumento );
            //$this->noedit = "noedit=2";
            
            $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
            $o_ALM_TransaccionMastFN->setIngresoEgresoFlag( $this->o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() );
            $this->a_ALM_TransaccionMast = $o_ALM_TransaccionMastFN->select();
        }
    }
    
    public function executeRequest()
    {
        //set_header_utf8();
        $block                  = $this->getRequestParameter( 'block' );
        $IdTransaccionOperacion = $this->getRequestParameter( 'IdTransaccionOperacion' );
        $IdTransaccion          = $this->getRequestParameter( 'IdTransaccion' );
        $IdUnidadProduccion     = $this->getRequestParameter( 'IdUnidadProduccion' );
        $TipoProc               = $this->getRequestParameter( 'TipoProc' );
        
        switch ( $TipoProc )
        {
            case "getDetallesTrxPorIdGuia":
                $s_IdOrdenGuia = $this->getRequestParameter( 'IdOrdenGuia' );
                
                $o_ALM_OrdenGuiaFacturaFN = new ALM_OrdenGuiaFacturaFN();
                $o_ALM_OrdenGuiaFacturaBN = $o_ALM_OrdenGuiaFacturaFN->selectByPK( $s_IdOrdenGuia );
                //pr( $o_ALM_OrdenGuiaFacturaBN );
                $a_lst = array();
                if( $o_ALM_OrdenGuiaFacturaBN->getIdTipoDocumentoRef() )
                {
                    $o_ALM_TransaccionDetalleFN = new ALM_TransaccionDetalleFN();
                    $o_ALM_TransaccionDetalleFN->setIdCompania( myUser::getUser()->getIdCompania() );
                    $o_ALM_TransaccionDetalleFN->setIdTipoDocumento( $o_ALM_OrdenGuiaFacturaBN->getIdTipoDocumentoRef() );
                    $o_ALM_TransaccionDetalleFN->setIdNumeroDocumento( $o_ALM_OrdenGuiaFacturaBN->getIdNumeroDocumentoRef() );
                    $a_ALM_TransaccionDetalle = $o_ALM_TransaccionDetalleFN->select();
                    $a_lst = array();
                    foreach ( $a_ALM_TransaccionDetalle as $o_ALM_TransaccionDetalleBN )
                    {
                        $a_lst[] = array( "IdItem" => $o_ALM_TransaccionDetalleBN->getIdItem(), "Cantidad" => $o_ALM_TransaccionDetalleBN->getCantidad(), "CostoConIGV" => $o_ALM_TransaccionDetalleBN->getMontoTotal() );
                    }
                }
            break;
            case "IdTransaccion":
                $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
                //$o_ALM_TransaccionMastFN->setDebug( 1 );
                $o_ALM_TransaccionMastFN->setIngresoEgresoFlag( $IdTransaccionOperacion );
                $o_ALM_TransaccionMastFN->addCondition( ALM_TransaccionMastFN::CodigoSunat, "NOT IN", "('01')", false );
                $o_ALM_TransaccionMastFN->addCondition( ALM_TransaccionMastFN::IdTransaccion, "NOT IN", "('ROC')", false );
                //$o_ALM_TransaccionMastFN->setAjusteInventarioFlag( "S" );
                //$o_ALM_TransaccionMastFN->setDireccionDestinoFlag( "S" );
                $o_ALM_TransaccionMastFN->addOrderBy( ALM_TransaccionMastFN::DescripcionLocal );
                $o_ALM_TransaccionMastFN->setEstado( "A" );
                $a_Result  = $o_ALM_TransaccionMastFN->select();
                $s_NameId  = "getIdTransaccion";
                $s_NameDes = "getDescripcionLocal";
                
                foreach ( $a_Result as $i_Key => $o_ObjectBN )
                {
                    $a_lst[$o_ObjectBN->$s_NameId()] = ( ( $o_ObjectBN->$s_NameDes() ) );
                }
            break;
            case "IdTipoDocumento":
                $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
                $o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $IdTransaccion );
                $s_TipoDocumentoGenerado = $o_ALM_TransaccionMastBN->getTipoDocumentoGenerado();
                
                $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN();
                $o_ALM_TipoDocumentoBN = $o_ALM_TipoDocumentoFN->selectByPK( $s_TipoDocumentoGenerado );
                
                $o_stdClass = new stdClass();
                $o_stdClass->IdTipoDocumento = $o_ALM_TipoDocumentoBN->getIdTipoDocumento();
                $o_stdClass->Descripcion     = strtoupper ( $o_ALM_TipoDocumentoBN->getDescripcion() );
                
                $a_lst = $o_stdClass;
            break;
            case "getStockActual":
                $s_IdItem               = $this->getRequestParameter( 'IdItem' );
                $i_IdCompania           = $this->getRequestParameter( 'IdCompania' );
                $s_IdAlmacen            = $this->getRequestParameter( 'IdAlmacen' );
                $s_IdLote               = $this->getRequestParameter( 'IdLote' );
                $s_IdUnidad             = $this->getRequestParameter( 'IdUnidad' );

                //se agrega por cajachica 2019-11-30
                if( $s_IdLote == "undefined" || $s_IdLote == "" )
                {
                    $s_IdLote = "000";
                }

                //$i_IdUnidadMedidaActual  = $s_IdUnidad; //UNIDAD DE MEDIDA SELECCIONADA
                //$i_IdUnidadMedidaAsig    = ALM_ItemMastFN::getItemUnidadVentaAsignada( $s_IdItem ); //UNI MEDIDA ASIGNADA

                $i_StockActual          = ALM_ItemAlmacenStockFN::recuperarStockDisponible( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdLote ); //se recupera el stock como esta
                //$s_FechaVencimientoLote = ALM_ItemAlmacenStockFN::recuperarFechaVencimientoLote( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdLote ); //se recupera fecha de vencimiento
                //$f_PrecioUnitario       = ALM_ItemMastFN::getItemPrecioUnitarioLocal( $s_IdItem );
                
                //ahora se valida el stock real por la unidad de medida
                //$o_SEL_MST_UnidadMastBN = MST_UnidadMastFN::select_one( $i_IdUnidadMedidaActual ); //unidad de medida seleccionada
                //$o_ASI_MST_UnidadMastBN = MST_UnidadMastFN::select_one( $i_IdUnidadMedidaAsig );   //unidad de medida asignada

                /*if( $o_SEL_MST_UnidadMastBN->getEsUnidadMinimaFlag() )
                {
                    //si es unidad minima se muestra el stock como lo busco
                }*/
                /*elseif ( $o_SEL_MST_UnidadMastBN->getUnidadEquivalenteFlag() && $o_SEL_MST_UnidadMastBN->getUsoFraccionFlag() )
                {
                    $f_CantidadAsiganada = ALM_ItemMastFN::getItemCantidadMedidaAsignada( $s_IdItem );
                    $i_StockActual    = round( $i_StockActual / $f_CantidadAsiganada, 2 );
                }
                elseif ( $o_SEL_MST_UnidadMastBN->getUnidadEquivalenteFlag() && !$o_SEL_MST_UnidadMastBN->getUsoFraccionFlag() && !$o_SEL_MST_UnidadMastBN->getEsUnidadMinimaFlag() ) 
                {
                    $a_MST_UnidadConversionMast = MST_UnidadMastFN::find_uni_eq( $i_IdUnidadMedidaActual );
                    if( $a_MST_UnidadConversionMast )
                    {
                        foreach ( $a_MST_UnidadConversionMast as $key => $o_MST_UnidadConversionMastBN ) 
                        {
                            $o_MST_UnidadMastFN = new MST_UnidadMastFN();
                            $o_TmpMST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $o_MST_UnidadConversionMastBN->getIdUnidadEquivalente() );
                            if( $o_TmpMST_UnidadMastBN->getEsUnidadMinimaFlag() )
                            {
                                $f_CantidadEq = $o_MST_UnidadConversionMastBN->getCantidadEquivalente();
                                break;
                            }
                        }
                        //$f_CantidadAsiganada = ALM_ItemMastFN::getItemCantidadMedidaAsignada( $s_IdItem );
                        $i_StockActual    = round( $i_StockActual / $f_CantidadEq, 2 );
                    }
                    else
                    {
                        $i_StockActual = 0;
                    }
                }
                else
                {
                    $i_StockActual = 0;
                }*/

                $f_PrecioUnitario = 0;
                $o_ALM_RequerimientoDetalleLogBN = ALM_RequerimientoDetalleLogFN::buscar_log_ref( $s_IdItem, "LO" );
                if( $o_ALM_RequerimientoDetalleLogBN )
                {
                    $f_PrecioUnitario = round( $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitarioIGVMN(), 2 );
                }
                
                $a_lst['error']       = false;
                $a_lst['result']      = true;
                $a_lst['StockActual'] = $i_StockActual;
                $a_lst['Costo']       = $f_PrecioUnitario;
                //$a_lst['FechaVencimientoLote'] = substr( $s_FechaVencimientoLote, 0, 10 );
            break;
        }

        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }
    
    public function executeSaveAddEdit()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        //CABECERA
        //$FechaDocumento             = date( "Y-m-d H:i:s" );
        $FechaDocumento             = $this->getRequestParameter( "FechaDocumento" );
        $IdTransaccionOperacion     = $this->getRequestParameter( 'IdTransaccionOperacion' );
        $IdAlmacen                  = $this->getRequestParameter( 'IdAlmacen' ); //ALMACEN ORIGEN
        $IdTransaccion              = $this->getRequestParameter( 'IdTransaccion' ); //
        $AlmacenTraslado            = $this->getRequestParameter( 'AlmacenTraslado' ); //ALMACEN DE DESTINO
        $IdTipoDocumento            = $this->getRequestParameter( 'IdTipoDocumento' );

        $ReferenciaTipoDocumento    = $this->getRequestParameter( 'ReferenciaTipoDocumento' );
        $ReferenciaSerieDocumento   = $this->getRequestParameter( 'ReferenciaSerieDocumento' ); //
        $ReferenciaNumeroDocumento  = $this->getRequestParameter( 'ReferenciaNumeroDocumento' ); //
        $ReferenciaFechaDocumento   = $this->getRequestParameter( 'ReferenciaFechaDocumento' ); //

        $Descripcion                = strtoupper( $this->getRequestParameter( "Descripcion" ) );
        
        $s_SerieDocumentoFiscal     = str_pad( strtoupper( $ReferenciaSerieDocumento ), 4, "0", STR_PAD_LEFT );
        $s_NumeroDocumentoFiscal    = str_pad( $ReferenciaNumeroDocumento, 10, "0", STR_PAD_LEFT );

        $Comentario                 = $this->getRequestParameter( 'Comentario' ); //
        //$TipodeCambio               = $this->getRequestParameter( 'TipodeCambio' ); //
        $TipodeCambio               = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
        $s_MonedaCod                = $this->getRequestParameter( 'MonedaCod' ); //
        
        //DETALLES
        $a_Cantidad                 = $this->getRequestParameter( 'Cantidad' ); //
        $a_IdItem                   = $this->getRequestParameter( 'IdItem' ); //
        $a_IdLote                   = $this->getRequestParameter( 'IdLote' ); //cuando es de tipo salida
        $a_IdUnidad                 = $this->getRequestParameter( 'IdUnidad' ); //
        
        $a_NumeroLote               = $this->getRequestParameter( 'NumeroLote' ); //cuando es de tipo ingreso
        $a_FechaVencimiento         = $this->getRequestParameter( 'FechaVencimiento' ); //
        
        $a_PrecioUnitario           = $this->getRequestParameter( 'PrecioUnitario' ); //se agrega por cajachica 2019-11-30

        $s_IdProveedor              = $this->getRequestParameter( 'IdProveedor' ); //
        
        $s_RegistroKardexFlag       = $this->getRequestParameter( 'RegistroKardexFlag' ); //

        //pr( $_REQUEST );

        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            myUser::getUser()->validar_session();
            
            if( !$TipodeCambio )
            {
                $s_FechaSel = date( "Y-m-d" );

                $o_iVentas = new iVentas();
                $o_iVentas->registrarTipoCambio( $s_FechaSel );

                //throw new Exception( "Debe de registrar el Tipo de Cambio de hoy." );

                $TipodeCambio = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
                //$TipodeCambio = 1;
            }

            $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
            $o_ALM_TransaccionCabeceraBN->setIdTransaccion( $IdTransaccion );
            $o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $AlmacenTraslado );
            $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $IdAlmacen );
            $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( $IdTransaccionOperacion );
            $o_ALM_TransaccionCabeceraBN->setFechaDocumento( $FechaDocumento );
            $o_ALM_TransaccionCabeceraBN->setTipodeCambio( floatval( $TipodeCambio ) );
            $o_ALM_TransaccionCabeceraBN->setMonedaCod( $s_MonedaCod );
            $o_ALM_TransaccionCabeceraBN->setDescripcion( $Descripcion );

            if( $IdTransaccion == COM_OrdenCompraCabeceraBN::TRANSACCION_X_NC_PROV )
            {
                $s_IdOrdenGuia = $this->getRequestParameter( 'IdOrdenGuia' ); //
                $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroInterno( $s_IdOrdenGuia );
            }
            
            //$o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
            //$o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );
            
            $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( $IdTipoDocumento );
            $o_ALM_TransaccionCabeceraBN->setComentario( $Comentario );

            if( $ReferenciaTipoDocumento == "CT" )
            {
                $o_utilGenerateId = new utilGenerateId();
                $o_utilGenerateId->setIdCompania( -1 );
                $o_utilGenerateId->setTipoCorrelativo( "CTRINT" );
                $o_utilGenerateId->setSerie( "TIPO" );
                $i_IdCrtl = $o_utilGenerateId->generateId();

                $ReferenciaTipoDocumento   = "CT";
                $CodDocumentoFiscal        = "CIN";
                $ReferenciaSerieDocumento  = "0001";
                $ReferenciaNumeroDocumento = str_pad( $i_IdCrtl, 10, "0", STR_PAD_LEFT );

                $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $ReferenciaTipoDocumento );
                $o_ALM_TransaccionCabeceraBN->setCodDocumentoFiscal( $CodDocumentoFiscal );
                $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $ReferenciaSerieDocumento );
                $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $ReferenciaNumeroDocumento );
                $o_ALM_TransaccionCabeceraBN->setFechaDocumentoFiscal( date( "Y-m-d" ) );
            }
            else
            {
                $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
                $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $ReferenciaTipoDocumento );

                $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $ReferenciaTipoDocumento );
                $o_ALM_TransaccionCabeceraBN->setCodDocumentoFiscal( $o_VTA_TipoDocumentoBN->getTipoDocumentoCod() );
                $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $s_SerieDocumentoFiscal );
                $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $s_NumeroDocumentoFiscal );
                $o_ALM_TransaccionCabeceraBN->setFechaDocumentoFiscal( $ReferenciaFechaDocumento );
            }

            if( $this->getRequestParameter( 'IdProveedor' ) )
            {
                $o_ALM_TransaccionCabeceraBN->setCodigoProveedor( $s_IdProveedor );
            }
            else
            {
                $o_ALM_TransaccionCabeceraBN->setCodigoCliente( myUser::getUser()->getObjectCompania()->getIdUsuarioAdmin() );
                
                if( $IdTransaccionOperacion == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
                {
                    //validacion por el ingreso de mercaderias
                    if( $IdTransaccion == COM_OrdenCompraCabeceraBN::TRANSACCION_X_DEFECTO || $IdTransaccion == COM_OrdenCompraCabeceraBN::TRANSACCION_X_COMPRA_NACIONAL )
                    {
                        if( trim( $s_IdProveedor ) == "" )
                        {
                            throw new Exception( "Para la Recepcion de Mercaderia es necesario el Proveedor." );
                        }
                    }
                }
            }
            
            if( $s_RegistroKardexFlag )
            {
                $o_ALM_TransaccionCabeceraBN->setGenerarKardex( false );
            }
            
            $f_MontoTotalIGV = 0;
            
            $b_PrecioLog = false;
            $a_MovientoDetalle = array();
            foreach ( $a_IdItem as $i_Key => $s_Value )
            {
                $s_Value = trim( $s_Value );
                if( $s_Value != "" )
                {
                    $o_ALM_ItemMastBN = ALM_ItemMastFN::getObjectItem( $s_Value );
                    
                    $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
                    $o_ALM_TransaccionDetalleBN->setIdItem( $s_Value );
                    $o_ALM_TransaccionDetalleBN->setCantidad( floatval( $a_Cantidad[$i_Key] ) );
                    $o_ALM_TransaccionDetalleBN->setUnidadCodigo( $a_IdUnidad[$i_Key] );

                    //SI MANEJA LOTE:
                    $b_ManejaLote = ALM_ItemMastFN::SiManejaLoteFlag( $s_Value );
                    if( !myUser::getUser()->getObjectCompania()->getMostrarNumeroLote() )
                    {
                        $b_ManejaLote = false;
                    }
                    if( $b_ManejaLote )
                    {
                        if( $IdTransaccionOperacion == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
                        {
                            if( trim( $a_NumeroLote[ $i_Key ] ) == "" )
                            {
                                throw new Exception( "Debe de ingresar el numero de lote" );
                            }

                            if( trim( $a_FechaVencimiento[ $i_Key ] ) == "" )
                            {
                                throw new Exception( "Debe de ingresar la fecha de vencimiento" );
                            }

                            $o_ALM_TransaccionDetalleBN->setLote( strtoupper( trim( $a_NumeroLote[ $i_Key ] ) ) );
                            $o_ALM_TransaccionDetalleBN->setFechaVencimientoLote( trim( $a_FechaVencimiento[ $i_Key ] ) );
                            $o_ALM_TransaccionDetalleBN->setFechaVencimiento( trim( $a_FechaVencimiento[ $i_Key ] ) );
                        }
                        else
                        {
                            $o_ALM_TransaccionDetalleBN->setLote( strtoupper( trim( $a_IdLote[ $i_Key ] ) ) );
                        }
                    }

                    //se agrega procedimiento por cajachica 2019-11-30
                    //el costo que ingresa esta con IGV, se le tiene que sacar el igv
                    if( $IdTransaccionOperacion == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
                    {
                        if( isset( $a_PrecioUnitario[$i_Key] ) && floatval( $a_PrecioUnitario[$i_Key] ) > 0 )
                        {
                            $b_PrecioLog = true;
                            //se quita el igv
                            $f_PrecioUnitarioSibIGV = round( floatval( $a_PrecioUnitario[$i_Key] ) / 1.18, 2 );
                            $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $f_PrecioUnitarioSibIGV );
                            $o_ALM_TransaccionDetalleBN->setMontoTotal( floatval( $a_PrecioUnitario[$i_Key] ) );
                            
                            $f_MontoTotalIGV = $f_MontoTotalIGV + ( floatval( $a_PrecioUnitario[$i_Key] ) * floatval( $a_Cantidad[$i_Key] ) );
                        }
                        else
                        {
                            //se puede recuperar el ultimo costo para calcular en el registro de compras :: 2021-01-04
                            $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $s_Value, 1 );
                            if( !$o_MST_ListaPrecioDetalleBN )
                            {
                                //throw new Exception( "El Producto [$s_Value] no tiene Costo asignado." );
                                $o_MST_ListaPrecioDetalleBN = new MST_ListaPrecioDetalleBN();
                            }
                            
                            $f_MontoTotalIGV = $f_MontoTotalIGV + ( $o_MST_ListaPrecioDetalleBN->getPrecioCostoIGV() * floatval( $a_Cantidad[$i_Key] ) );
                        }
                    }
                    else
                    {
                        //salida
                        
                        //deberia de tener costo, por la devolucion de productos
                        if( $IdTransaccion == COM_OrdenCompraCabeceraBN::TRANSACCION_X_NC_PROV )
                        {
                            if( isset( $a_PrecioUnitario[$i_Key] ) && floatval( $a_PrecioUnitario[$i_Key] ) > 0 )
                            {
                                $f_MontoTotalIGV = $f_MontoTotalIGV + ( floatval( $a_PrecioUnitario[$i_Key] ) * floatval( $a_Cantidad[$i_Key] ) );
                            }
                            else
                            {
                                //throw new Exception( "El Producto [$s_Value] no tiene Costo registrado en los Detalles." );
                            }
                        }
                    }
                    
                    $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;
                }
            }
            
            $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );

            $o_MovimientoBL = new MovimientoBL();
            $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );
            
            $i_Id = $o_ALM_TransaccionCabeceraBN->getIdTransaccionCabeceraConcat();

            $f_TipoCambio  = GSS_TipoCambioFN::getStaticTipoCambioVenta( $ReferenciaFechaDocumento );
            if( !$f_TipoCambio )
            {
                $f_TipoCambio  = GSS_TipoCambioFN::getStaticTipoCambioVenta();
            }

            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //aqui se agrega otro procedimiento para registrar en ALM_OrdenGuiaFactura :: 2021-01-04    SERMAQUI
            if( $IdTransaccionOperacion == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
            {
                if( $IdTransaccion == COM_OrdenCompraCabeceraBN::TRANSACCION_X_NC_PROV || $IdTransaccion == COM_OrdenCompraCabeceraBN::TRANSACCION_X_DEFECTO || $IdTransaccion == COM_OrdenCompraCabeceraBN::TRANSACCION_X_COMPRA_NACIONAL )
                {
                    $f_IGV       = UtilIGV::getValorIGVActual();
                    $f_IGVMasUno = $f_IGV + 1;

                    $f_PrecioTotalFinal      = $f_MontoTotalIGV;
                    $f_PrecioSubTotal        = round( $f_PrecioTotalFinal / $f_IGVMasUno, 2 );
                    $f_MontoSubTotalImpuesto = round( $f_PrecioTotalFinal - $f_PrecioSubTotal, 2 );
                    //$f_MontoSubTotalImpuesto = round( $f_PrecioSubTotal * $f_IGV, 13 );
                    //$f_MontoSubTotalImpuesto = round( $f_MontoSubTotalImpuesto, 2 );
                    //$f_PrecioSubTotal        = round( $f_PrecioSubTotal, 2 );

                    $MontoAfecto                = $f_PrecioSubTotal;
                    $MontoAfectoMN              = $f_PrecioSubTotal;
                    $MontoNoAfecto              = 0;
                    $MontoNoAfectoMN            = 0;
                    $MontoIGV                   = $f_MontoSubTotalImpuesto;
                    $MontoIGVMN                 = $f_MontoSubTotalImpuesto;
                    $MontoTotal                 = $f_PrecioTotalFinal;
                    $MontoTotalMN               = $f_PrecioTotalFinal;

                    $ComprobanteRefId          = 'null';
                    $ComprobanteTipoRefId      = "";
                    $ComprobanteSerieNumeroRef = "";
                    $ComprobanteFechaEmisioRef = '';


                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $s_IdProveedor );

                    $s_TipoDocumento  = $o_MST_PersonaMastBN->getTipoDocumento();
                    $s_Documento      = $o_MST_PersonaMastBN->getDocumento();
                    $o_NombreCompleto = $o_MST_PersonaMastBN->getNombreCompleto();


                    $o_CP_ObligacionesBN = new CP_ObligacionesBN();
                    $o_CP_ObligacionesBN->setIdCompania( myUser::getUser()->getIdCompania() );
                    $o_CP_ObligacionesBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                    $o_CP_ObligacionesBN->setIdTipoDocumento( $ReferenciaTipoDocumento );
                    $o_CP_ObligacionesBN->setPeriodo( UtilDate::getFormatDate( $ReferenciaFechaDocumento, "Ym" ) );
                    $o_CP_ObligacionesBN->setFechaEmision( $ReferenciaFechaDocumento );
                    //$o_CP_ObligacionesBN->setFechaVencimiento( $FechaVencimiento );
                    //$o_CP_ObligacionesBN->setFechaProgramacion( $FechaProgramacion );
                    $o_CP_ObligacionesBN->setDocumentoSerie( $s_SerieDocumentoFiscal );
                    $o_CP_ObligacionesBN->setDocumentoNumero( $s_NumeroDocumentoFiscal );
                    $o_CP_ObligacionesBN->setDocumentoSerieNumero( $s_SerieDocumentoFiscal."-".$s_NumeroDocumentoFiscal );
                    //$o_CP_ObligacionesBN->setNumeroOC( $IdOrdenCompra );
                    $o_CP_ObligacionesBN->setProveedorId( ( int ) $s_IdProveedor );
                    $o_CP_ObligacionesBN->setProveedorDocTipo( $s_TipoDocumento );
                    $o_CP_ObligacionesBN->setProveedorDocNum( $s_Documento );
                    $o_CP_ObligacionesBN->setProveedorNombre( $o_NombreCompleto );
                    //$o_CP_ObligacionesBN->setIdProyecto( $IdProyecto );
                    //$o_CP_ObligacionesBN->setProyectoNombre( $NombreProyecto );
                    $o_CP_ObligacionesBN->setDescripcion( $Descripcion );
                    $o_CP_ObligacionesBN->setTerminoId( 1 );
                    $o_CP_ObligacionesBN->setMetodoPagoId( 3 );
                    $o_CP_ObligacionesBN->setIdMoneda( "LO" );
                    $o_CP_ObligacionesBN->setTipoCambio( $f_TipoCambio );
                    $o_CP_ObligacionesBN->setAfectoIGV( 1 );

                    $o_CP_ObligacionesBN->setMontoAfecto( $MontoAfecto );
                    $o_CP_ObligacionesBN->setMontoAfectoMN( $MontoAfectoMN );
                    $o_CP_ObligacionesBN->setMontoNoAfecto( $MontoNoAfecto );
                    $o_CP_ObligacionesBN->setMontoNoAfectoMN( $MontoNoAfectoMN );
                    $o_CP_ObligacionesBN->setMontoIGV( $MontoIGV );
                    $o_CP_ObligacionesBN->setMontoIGVMN( $MontoIGVMN );
                    $o_CP_ObligacionesBN->setMontoTotal( $MontoTotal );
                    $o_CP_ObligacionesBN->setMontoTotalMN( $MontoTotalMN );

                    $o_CP_ObligacionesBN->setComprobanteRefId( $ComprobanteRefId );
                    $o_CP_ObligacionesBN->setComprobanteTipoRefId( $ComprobanteTipoRefId );
                    $o_CP_ObligacionesBN->setComprobanteSerieNumeroRef( $ComprobanteSerieNumeroRef );
                    if( $ComprobanteFechaEmisioRef )
                    {
                        $o_CP_ObligacionesBN->setComprobanteFechaEmisionRef( $ComprobanteFechaEmisioRef );
                    }

                    $o_CP_ObligacionesBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_CP_ObligacionesBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );

                    //cuando es nuevo
                    $i_IdObli = CP_ObligacionesDP::recuperarId();

                    $o_CP_ObligacionesBN->setObligacionesId( $i_IdObli );

                    $o_CP_ObligacionesBN->setMontoPagado( 0 );
                    $o_CP_ObligacionesBN->setMontoPagadoMN( 0 );
                    $o_CP_ObligacionesBN->setMontoSaldo( $MontoTotal );
                    $o_CP_ObligacionesBN->setMontoSaldoMN( $MontoTotalMN );
                    $o_CP_ObligacionesBN->setEstado( CP_ObligacionesBN::ESTADO_VALIDADO );       //VA validado | AN anulado | PE pendiente
                    $o_CP_ObligacionesBN->setEstadoPagado( CP_ObligacionesBN::ESTADO_PAG_PENDIENTE ); //PE pendiente | CO pagado

                    if( $IdTipoDocumento == "NC" )
                    {
                        //se copia del modulo de obligaciones
                    }

                    $o_CP_ObligacionesBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_CP_ObligacionesBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );

                    $o_CP_ObligacionesDP = new CP_ObligacionesDP( $o_CP_ObligacionesBN );
                    $o_CP_ObligacionesDP->save();
                }
            }
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $a_Json['id'] = "";
            if( $IdTransaccionOperacion == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
            {
                //AQUI SE PREPARA PARA ASOCIAR SERIES SI ES NECESARIO
                $o_SR_MovimientoBN = new SR_MovimientoBN();
                $o_SR_MovimientoBN->setTipoMovimiento( $o_ALM_TransaccionCabeceraBN->getIdTransaccion() ); //referencia tabla ALM_TransaccionMast -> ROC, VTA
                $o_SR_MovimientoBN->setOperacion( ALM_TransaccionCabeceraBN::TIPO_INGRESO );
                $o_SR_MovimientoBN->setAlmacen( $o_ALM_TransaccionCabeceraBN->getIdAlmacen() );
                $o_SR_MovimientoBN->setReferenciaTipo( $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento() );
                $o_SR_MovimientoBN->setReferenciaNumero( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
                $o_SR_MovimientoBN->setReferenciaFecha( $o_ALM_TransaccionCabeceraBN->getFechaDocumento() );
                $o_SR_MovimientoBN->setEstado( "P" );
                $o_SR_MovimientoBN->setEstadoAprob( "P" );

                $b_ControSerie = false;
                $a_SR_MovimientoDetalle = array();
                foreach ( $a_MovientoDetalle as $o_ALM_TransaccionDetalleBN )
                {
                    $o_SR_MovimientoDetalleBN = new SR_MovimientoDetalleBN();
                    $o_SR_MovimientoDetalleBN->setProductoId( $o_ALM_TransaccionDetalleBN->getIdItem() );
                    $o_SR_MovimientoDetalleBN->setCantidad( intval( $o_ALM_TransaccionDetalleBN->getCantidad() ) );
                    $o_SR_MovimientoDetalleBN->setPorSerie( "CO" );
                    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    /// PREGUNTA SI UNO DE LOS PRODUCTOS MANEJA SERIE
                    $o_ALM_ItemMastBN = $o_ALM_TransaccionDetalleBN->getObjectItem();
                    if( $o_ALM_ItemMastBN->SiManejaSerie() )
                    {
                        $b_ControSerie = true;
                        $o_SR_MovimientoDetalleBN->setPorSerie( "PE" ); //PE | CO
                    }
                    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                    $a_SR_MovimientoDetalle[] = $o_SR_MovimientoDetalleBN;
                }

                $o_SR_MovimientoBN->setMovimientoDetalleArray( $a_SR_MovimientoDetalle );
                $o_SR_MovimientoBN->setControlEstadoSerie( SR_MovimientoBN::CTRL_ESTADO_SERIE_NOEXISTE );
                if( $b_ControSerie )
                {
                    $o_SR_MovimientoBN->setControlEstadoSerie( SR_MovimientoBN::CTRL_ESTADO_SERIE_PENDIENTE );

                    $o_SerieBL = new SerieBL();
                    $o_SerieBL->validarMovimientoH( $o_SR_MovimientoBN );
                }

                //AHORA SE AGREGA PROCEDIMIENTO POR CAJACHICA - SIEMPRE Y CUANDO SEA INGRESO
                //alistamos los detalles
                $f_SumaMontoTotal = 0;
                $f_SumaMontoIGV = 0;
                $f_SumaMontoSubTotal = 0;
                $a_Detalles = array();
                $a_IdItemDet = array();

                foreach ( $a_IdItem as $i_Key => $s_Value )
                {
                    $s_Value = trim( $s_Value );
                    if( $s_Value != "" )
                    {
                        $o_ALM_ItemMastBN = ALM_ItemMastFN::getObjectItem( $s_Value );

                        $a_IdItemDet[]   = $s_Value;
                        $a_Detalles[] = $o_ALM_ItemMastBN->getDescripcionCompleta();
                        $a_CantidadDet[] = $a_Cantidad[$i_Key];
                        $a_PrecioUnitIGV[] = floatval( $a_PrecioUnitario[$i_Key] );

                        $TotalNeto = floatval( $a_PrecioUnitario[$i_Key] ) * floatval( $a_Cantidad[$i_Key] );
                        $SubTotal  = round( $TotalNeto / 1.18, 13 );
                        $IGVTotal  = round( $SubTotal * 0.18, 13 );

                        $IGVTotal  = round( $IGVTotal, 2 );
                        $SubTotal  = round( $SubTotal, 2 );

                        $a_MontoTotal[]    = $TotalNeto;
                        $a_MontoSubTotal[] = $SubTotal;
                        $a_MontoIGV[]      = $IGVTotal;

                        $f_SumaMontoTotal    = $f_SumaMontoTotal    + $TotalNeto;
                        $f_SumaMontoIGV      = $f_SumaMontoIGV      + $IGVTotal;
                        $f_SumaMontoSubTotal = $f_SumaMontoSubTotal + $SubTotal;
                    }
                }

                if( $s_IdProveedor )
                {
                    if( GSS_ParametroMastFN::getValorParam( "CAJA_CHICA", "ACT_CJ_CHI" ) )
                    {
                        $o_MST_PersonaMastBN = MST_PersonaMastFN::buscarClientePorId( $s_IdProveedor );
    
                        ParameterWR::getInstance()->setVar( "FechaDocumento", date( "Y-m-d" ) );
                        ParameterWR::getInstance()->setVar( "TipoDocProv", $o_MST_PersonaMastBN->getTipoDocumento() );
                        ParameterWR::getInstance()->setVar( "NumDocProv", $o_MST_PersonaMastBN->getDocumento() );
                        ParameterWR::getInstance()->setVar( "NomProv", $o_MST_PersonaMastBN->getNombreCompletoLLeno() );
                        ParameterWR::getInstance()->setVar( "Comentario", $o_ALM_TransaccionCabeceraBN->getComentario() );
                        ParameterWR::getInstance()->setVar( "Estado", ALM_CajaChicaDetBN::ESTADO_APROBADO  );
                        ParameterWR::getInstance()->setVar( "ReferenciaIdTransaccion", $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
                        ParameterWR::getInstance()->setVar( "ReferenciaTipoDocumento", $o_ALM_TransaccionCabeceraBN->getTipoDocumentoFiscal() );
                        ParameterWR::getInstance()->setVar( "ReferenciaSerieDocumento", $o_ALM_TransaccionCabeceraBN->getSerieDocumentoFiscal() );
                        ParameterWR::getInstance()->setVar( "ReferenciaNumeroDocumento", $o_ALM_TransaccionCabeceraBN->getNumeroDocumentoFiscal() );
                        ParameterWR::getInstance()->setVar( "EsInventariableFlag", "S" );
                        ParameterWR::getInstance()->setVar( "IdItem", $a_IdItemDet );
                        ParameterWR::getInstance()->setVar( "Descripcion", $a_Detalles );
                        ParameterWR::getInstance()->setVar( "Cantidad", $a_CantidadDet );
                        ParameterWR::getInstance()->setVar( "MontoUnitarioConIGV", $a_PrecioUnitIGV );
                        ParameterWR::getInstance()->setVar( "MontoTotal", $a_MontoTotal );
                        ParameterWR::getInstance()->setVar( "MontoSubTotal", $a_MontoSubTotal );
                        ParameterWR::getInstance()->setVar( "MontoIGV", $a_MontoIGV );
                        ParameterWR::getInstance()->setVar( "SumaMontoSubTotal", $f_SumaMontoSubTotal );
                        ParameterWR::getInstance()->setVar( "SumaMontoIGV", $f_SumaMontoIGV );
                        ParameterWR::getInstance()->setVar( "SumaMontoTotal", $f_SumaMontoTotal );
                        ob_start();
                        $o_GuardarCajaChicaDetAction = new GuardarCajaChicaDetAction();
                        $o_GuardarCajaChicaDetAction->execute();
                        $s_Json = ob_get_contents();
                        ob_end_clean();
                        $a_Json = json_decode( $s_Json, true );
                        if( $a_Json['error'] )
                        {
                            throw new Exception( $a_Json['mensaje_error'] );
                        }
                    }
                }

                //luego se registra el log de requerimientos para recuperar el precio
                //if( $i_Id && $b_PrecioLog )
                //{
                    $f_TipoCambioLog = GSS_TipoCambioFN::getStaticTipoCambioVenta();

                    //AHORA SE GUARDA EL LOG PARA POSTERIORMENTE RECUPERAR EL PRECIO
                    foreach ( $o_ALM_TransaccionCabeceraBN->getArrayMovientoDetalle() as $i_Key => $o_ALM_TransaccionDetalleBN ) 
                    {
                        $i_IdRequerimientoLog = ALM_RequerimientoDetalleLogFN::recuperarId();
                        
                        $o_ALM_RequerimientoDetalleLogDP = new ALM_RequerimientoDetalleLogDP();
                        $o_ALM_RequerimientoDetalleLogDP->setIdRequerimientoLog( $i_IdRequerimientoLog );
                        $o_ALM_RequerimientoDetalleLogDP->setTipo( "TX" );
                        $o_ALM_RequerimientoDetalleLogDP->setIdRequerimiento( intval( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() ) );
                        $o_ALM_RequerimientoDetalleLogDP->setIdCompania( $o_ALM_TransaccionCabeceraBN->getIdCompania() );
                        $o_ALM_RequerimientoDetalleLogDP->setIdRequerimientoDetalle( $o_ALM_TransaccionDetalleBN->getIdSecuencia() );
                        $o_ALM_RequerimientoDetalleLogDP->setIdSucursal( $o_ALM_TransaccionCabeceraBN->getIdSucursal() );
                        $o_ALM_RequerimientoDetalleLogDP->setIdMoneda( "LO" );
                        $o_ALM_RequerimientoDetalleLogDP->setTipoCambio( $f_TipoCambioLog );
                        $o_ALM_RequerimientoDetalleLogDP->setIdPersona( ( int ) $o_ALM_TransaccionCabeceraBN->getCodigoProveedor() );
                        $o_ALM_RequerimientoDetalleLogDP->setIdItem( $o_ALM_TransaccionDetalleBN->getIdItem() );
                        $o_ALM_RequerimientoDetalleLogDP->setCantidad( $o_ALM_TransaccionDetalleBN->getCantidad() );
                        $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitario( $o_ALM_TransaccionDetalleBN->getPrecioUnitario() );
                        $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioMN( $o_ALM_TransaccionDetalleBN->getPrecioUnitario() );
                        $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioME( round( $o_ALM_TransaccionDetalleBN->getPrecioUnitario() / $f_TipoCambioLog, 2 ) );
                        $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioIGV( floatval( $a_PrecioUnitario[$i_Key] ) );
                        $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioIGVMN( floatval( $a_PrecioUnitario[$i_Key] ) );
                        $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioIGVME( round( floatval( $a_PrecioUnitario[$i_Key] ) / $f_TipoCambioLog, 2 ) );
                        $o_ALM_RequerimientoDetalleLogDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_ALM_RequerimientoDetalleLogDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_ALM_RequerimientoDetalleLogDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_ALM_RequerimientoDetalleLogDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $b_Result = $o_ALM_RequerimientoDetalleLogDP->save();
                    }
                //}
            }
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
            $a_Rs['id_chica'] = $a_Json['id'];
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            //pr( $o_Exception );
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $a_Ids = explode( "_", $i_Id );
        $IdCompania      = $a_Ids[0];
        $IdTipoDocumento = $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];
        
        $this->s_Topico = "Transacciones";
        $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
        $this->o_ObjectBN = $o_ALM_TransaccionCabeceraFN->selectByPK( $IdCompania, $IdTipoDocumento, $NumeroDocumento );
    }
    
    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        //$this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $this->TipoVista  = $this->getRequestParameter( 'TipoVista' );

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->a_GSS_Compania= $o_GSS_CompaniaFN->select();
        
        $this->a_TipoTransaccion = ALM_TransaccionCabeceraBN::getArrayTipoTransaccion();
        
        $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN(); //PARA DOCUMENTO DE REFERENCIA
        $o_ALM_TipoDocumentoFN->setEstado( "A" );
        $this->a_ALM_TipoDocumento = $o_ALM_TipoDocumentoFN->select();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $this->a_ALM_AlmacenMastOrg = $o_ALM_AlmacenMastFN->select();
        
        $this->a_ALM_AlmacenMastDst = $o_ALM_AlmacenMastFN->select();
        
        $a_Ids = explode( "_", $this->i_Id );
        $IdCompania      = $a_Ids[0];
        $IdTipoDocumento = $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];
        
        //procedimiento normal
        $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
        $this->o_ALM_TransaccionCabeceraBN = $o_ALM_TransaccionCabeceraFN->selectByPK( $IdCompania, $IdTipoDocumento, $NumeroDocumento );
        if( !$this->o_ALM_TransaccionCabeceraBN )
        {
            //NUEVO PROCEDIMIENTO POR TRANSFERENCIA ENTRE VARIAS COMPANIAS
            $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
            $o_ALM_TransaccionCabeceraFN->setIdTipoDocumento( $IdTipoDocumento );
            $o_ALM_TransaccionCabeceraFN->setIdNumeroDocumento( $NumeroDocumento );
            $a_ALM_TransaccionCabecera = $o_ALM_TransaccionCabeceraFN->select();
            if( $a_ALM_TransaccionCabecera )
            {
                $this->o_ALM_TransaccionCabeceraBN = $a_ALM_TransaccionCabecera[0];
            }
        }

        $this->noedit = "noedit=2";

        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastFN->setIngresoEgresoFlag( $this->o_ALM_TransaccionCabeceraBN->getIdTransaccionOperacion() );
        $this->a_ALM_TransaccionMast = $o_ALM_TransaccionMastFN->select();
        
        //DETALLES
        $o_ALM_TransaccionDetalleFN = new ALM_TransaccionDetalleFN();
        $o_ALM_TransaccionDetalleFN->setIdCompania( $IdCompania );
        $o_ALM_TransaccionDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
        $o_ALM_TransaccionDetalleFN->setIdNumeroDocumento( $NumeroDocumento );
        $this->a_ALM_TransaccionDetalle = $o_ALM_TransaccionDetalleFN->select();
        if( !$this->a_ALM_TransaccionDetalle )
        {
            $o_ALM_TransaccionDetalleFN = new ALM_TransaccionDetalleFN();
            //$o_ALM_TransaccionDetalleFN->setIdCompania( $IdCompania );
            $o_ALM_TransaccionDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
            $o_ALM_TransaccionDetalleFN->setIdNumeroDocumento( $NumeroDocumento );
            $this->a_ALM_TransaccionDetalle = $o_ALM_TransaccionDetalleFN->select();
        }

        $this->o_SR_MovimientoBN = null;
        switch( $this->o_ALM_TransaccionCabeceraBN->getIdTransaccion() )
        {
            case "ROC":

                $o_SR_MovimientoFN = new SR_MovimientoFN();
                $o_SR_MovimientoFN->setTipoMovimiento( $this->o_ALM_TransaccionCabeceraBN->getIdTransaccion() ); //ROC
                $o_SR_MovimientoFN->setOperacion( ALM_TransaccionCabeceraBN::TIPO_INGRESO );
                $o_SR_MovimientoFN->setAlmacen( $this->o_ALM_TransaccionCabeceraBN->getIdAlmacen() );
                $o_SR_MovimientoFN->setReferenciaTipo( $this->o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() ); //OC
                $o_SR_MovimientoFN->setReferenciaNumero( $this->o_ALM_TransaccionCabeceraBN->getReferenciaNumeroDocumento() );
                $a_SR_Movimiento = $o_SR_MovimientoFN->select();
                if( $a_SR_Movimiento )
                {
                    $o_SR_MovimientoBN = $a_SR_Movimiento[0];
                    $this->o_SR_MovimientoBN = $o_SR_MovimientoBN;
                }

            break;
            case "CPN":

                $o_SR_MovimientoFN = new SR_MovimientoFN();
                $o_SR_MovimientoFN->setTipoMovimiento( $this->o_ALM_TransaccionCabeceraBN->getIdTransaccion() ); //ROC
                $o_SR_MovimientoFN->setOperacion( ALM_TransaccionCabeceraBN::TIPO_INGRESO );
                $o_SR_MovimientoFN->setAlmacen( $this->o_ALM_TransaccionCabeceraBN->getIdAlmacen() );
                $o_SR_MovimientoFN->setReferenciaTipo( $this->o_ALM_TransaccionCabeceraBN->getIdTipoDocumento() ); //OC
                $o_SR_MovimientoFN->setReferenciaNumero( $this->o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
                $a_SR_Movimiento = $o_SR_MovimientoFN->select();
                if( $a_SR_Movimiento )
                {
                    $o_SR_MovimientoBN = $a_SR_Movimiento[0];
                    $this->o_SR_MovimientoBN = $o_SR_MovimientoBN;
                }

            break;
        }
    }
    
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        try 
        {
            $a_Ids = explode( "_", $i_Id );
            $IdCompania      = $a_Ids[0];
            $IdTipoDocumento = $a_Ids[1];
            $NumeroDocumento = $a_Ids[2];
                
            $o_ALM_TransaccionCabeceraDP = new ALM_TransaccionCabeceraDP();
            $o_ALM_TransaccionCabeceraDP->setIdCompania( ( int ) $IdCompania );
            $o_ALM_TransaccionCabeceraDP->setIdTipoDocumento( $IdTipoDocumento );
            $o_ALM_TransaccionCabeceraDP->setIdNumeroDocumento( $NumeroDocumento );
            $b_Result = $o_ALM_TransaccionCabeceraDP->delete();
            
            if( $b_Result )
            {
                $o_ALM_TransaccionDetalleDP = new ALM_TransaccionDetalleDP();
                $o_ALM_TransaccionDetalleDP->setIdCompania( ( int ) $IdCompania );
                $o_ALM_TransaccionDetalleDP->setIdTipoDocumento( $IdTipoDocumento );
                $o_ALM_TransaccionDetalleDP->setIdNumeroDocumento( $NumeroDocumento );
                $b_Result = $o_ALM_TransaccionDetalleDP->deleteDetail();
            }

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeFindItem()
    {
        $block      = $this->getRequestParameter( 'block' );
        $s_ItemId   = $this->getRequestParameter( 's_ItemId' );
        $IdAlmacen  = $this->getRequestParameter( 'IdAlmacen' );
        $IdCompania = $this->getRequestParameter( 'IdCompania' );
        $type       = $this->getRequestParameter( 'type' );
        
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_ItemId );
        
        $a_ResultJson['result'] = 0;
        $a_ResultJson['IdItem'] = "";
        $a_ResultJson['DescripcionCompleta'] = "";
        $a_ResultJson['NoAfectoImpuestoVentasFlag'] = "";
        //$a_ResultJson['StockActual'] = "0";
        $a_ResultJson['IdOrdenClasificacion'] = "";
        $a_ResultJson['ManejaLote'] = true;
        
        if( $o_ALM_ItemMastBN )
        {
            $a_ResultJson['result']                     = 1;
            $a_ResultJson['IdItem']                     = $o_ALM_ItemMastBN->getIdItem();
            $a_ResultJson['DescripcionCompleta']        = $o_ALM_ItemMastBN->getDescripcionCompleta();
            $a_ResultJson['UnidadCompra']               = $o_ALM_ItemMastBN->getUnidadCompra();
            $a_ResultJson['UnidadCompraDesc']           = $o_ALM_ItemMastBN->getObjectUnidadCompra()->getDescripcionCorta();

            //ahora se busca unidades equivalente
            $a_Unidad[] = array( "IdUnidad" => $a_ResultJson['UnidadCompra'], "UnidadDesc" => $a_ResultJson['UnidadCompraDesc'] );

            $a_MST_UnidadConversionMast = MST_UnidadMastFN::find_uni_eq( $a_ResultJson['UnidadCompra'] );
            if( $a_MST_UnidadConversionMast )
            {
                foreach ( $a_MST_UnidadConversionMast as $key => $o_MST_UnidadConversionMastBN ) 
                {
                    $o_MST_UnidadMastBN = $o_MST_UnidadConversionMastBN->getObjectUnidadMedidaEq();
                    $a_Unidad[] = array( "IdUnidad" => $o_MST_UnidadMastBN->getIdUnidad(), "UnidadDesc" => $o_MST_UnidadMastBN->getDescripcionCorta() );
                }
            }
            $a_ResultJson['a_Unidad'] = $a_Unidad;

            //$a_ResultJson['UnidadCompra']               = "58";
            //$a_ResultJson['UnidadCompraDesc']           = "UNIDAD";
            $a_ResultJson['NoAfectoImpuestoVentasFlag'] = $o_ALM_ItemMastBN->getNoAfectoImpuestoVentasFlag();
            
            $b_ManejaLote = $o_ALM_ItemMastBN->SiManejaLote();
            $a_ResultJson['ManejaLote'] = $b_ManejaLote;
            
            //$a_ResultJson['IdOrdenClasificacion'] = $o_ALM_ItemMastBN->getIdOrdenClasificacion();
            //SE BUSCA LOTES
            $a_Lst = array();
            $a_ALM_ItemAlmacenStock = ALM_ItemAlmacenStockFN::recuperarLotes( $IdCompania, $IdAlmacen, $s_ItemId );
            if( $a_ALM_ItemAlmacenStock )
            {
                foreach ( $a_ALM_ItemAlmacenStock as $i_Key => $o_ALM_ItemAlmacenStockBN )
                {
                    $a_Lst[] = array( "IdLote" => $o_ALM_ItemAlmacenStockBN->getIdLote(), "FechaVencimiento" => substr( $o_ALM_ItemAlmacenStockBN->getFechaVencimiento(), 0, 10 ) );
                }
                $a_ResultJson['a_Lotes'] = $a_Lst;
            }
        }
        
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }

    public function executeListItemRefe()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $this->IdProveedor = $this->getRequestParameter( 'IdProveedor' );

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->setEstado( "A" );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::Nombres );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();

        $o_MST_ReferenciaProductoFN = new MST_ReferenciaProductoFN();
        $o_MST_ReferenciaProductoFN->setEstado( MST_ReferenciaProductoFN::ESTADO_COMPLETO );
        if( $this->IdProveedor )
        {
            $o_MST_ReferenciaProductoFN->setIdProveedor( $this->IdProveedor );
        }
        $this->a_MST_ReferenciaProducto = $o_MST_ReferenciaProductoFN->select();

        $o_MST_ColorFN = new MST_ColorFN();
        $o_MST_ColorFN->setEstado( MST_ColorBN::ESTADO_ACTIVO );
        $o_MST_ColorFN->addOrderBy( "substr(Codigo,1,1)" );
        $o_MST_ColorFN->addOrderBy( "cast(substr(Codigo,2,10) as UNSIGNED)" );
        $this->a_MST_Color = $o_MST_ColorFN->select();

        $o_MST_CategoriaTallaFN = new MST_CategoriaTallaFN();
        if( $this->IdProveedor )
        {
            $o_MST_CategoriaTallaFN->setIdProveedor( $this->IdProveedor );
        }
        $o_MST_CategoriaTallaFN->setEstado( MST_CategoriaTallaBN::ESTADO_ACTIVO );
        $this->a_MST_CategoriaTalla = $o_MST_CategoriaTallaFN->select();

        $o_MST_TallaFN = new MST_TallaFN();
        $o_MST_TallaFN->setEstado( MST_TallaBN::ESTADO_ACTIVO );
        $this->a_MST_Talla = $o_MST_TallaFN->select();
    }

    public function executeItemGridRef()
    {
        $this->IdAlmacen = $this->getRequestParameter( 'IdAlmacen' );
        $this->IdProveedor = $this->getRequestParameter( 'IdProveedor' );

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_RelacionReferenciaProductoFN() );

        //$o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdProveedor" );
        $o_GridAction->addAssignFilter( "IdReferencia" );
        $o_GridAction->addAssignFilter( "IdColor" );
        $o_GridAction->addAssignFilter( "IdCatTalla" );
        //$o_GridAction->addAssignFilter( "IdTalla" );
        if( $this->getRequestParameter( 'IdTalla' ) )
        {
            $o_GridAction->addConditionFilter( "IdTalla", "IdTalla", "IN", "( SELECT IdTalla FROM MST_Talla where Descripcion='".$this->getRequestParameter( 'IdTalla' )."' )" );
            //$o_GridAction->addMethodDefault( MST_RelacionReferenciaProductoFN::IdTalla, array( 'Condition'=>'IN', 'Value' => "" ) );
        }

        $o_GridAction->addOrderDefault( MST_RelacionReferenciaProductoFN::IdReleacion, true );

        $o_GridAction->addRowsToShow( "IdReleacion", "DescripcionItem", "UnidadItem", "IdItem", "StockActual" );

        $o_GridAction->setNumberRecordsShow( 100 );

        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeListItem()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $this->block     = $this->getRequestParameter( 'block' );
        $this->type      = $this->getRequestParameter( 'type' );
        $this->IdAlmacen = $this->getRequestParameter( 'IdAlmacen' );
        
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $this->a_MST_ClaseLinea = $o_MST_ClaseLineaFN->select();
        
        $o_ALM_MarcaFN = new ALM_MarcaFN();
        $o_ALM_MarcaFN->setEstado( "A" );
        $o_ALM_MarcaFN->addOrderBy( ALM_MarcaFN::DescripcionLocal );
        $this->a_ALM_Marca = $o_ALM_MarcaFN->select();
    }
    
    public function executeItemGrid()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $type      = $this->getRequestParameter( 'type' );
        $IdAlmacen = $this->getRequestParameter( 'IdAlmacen' );
        $ConStock  = $this->getRequestParameter( 'ConStock' );
        $moneda_cod  = "LO";
        
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_ItemMastFN() );
        
        //$o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        
        //$o_GridAction->addAssignFilter( "IdItem" );
        $o_GridAction->addAssignFilter( "IdLinea" );
        $o_GridAction->addAssignFilter( "IdItemTipo" );
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        
        if( $this->getRequestParameter( 'IdItemTipo' ) != "02" )
        {
            $o_GridAction->addAssignFilter( "ConStock" );
            $o_GridAction->addMethodDefault( "ALM_ItemTipo.TransacciondelSistemaFlag", array( 'Condition'=>'=', 'Value'=>"1" ) );
        }
        
        //$o_GridAction->addAssignFilter( "IdAlmacen" );
        //$o_GridAction->addMethodDefault( "IdAlmacen", GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() ) );
        if( $IdAlmacen )
        {
            $o_GridAction->addMethodDefault( "IdAlmacen", $IdAlmacen );
        }
        
        $o_GridAction->addAssignFilter( "IdLinea" );
        $o_GridAction->addAssignFilter( "IdFamilia" );
        $o_GridAction->addAssignFilter( "IdMarca" );
        
        $o_GridAction->addConditionFilter( "IdItem", ALM_ItemMastFN::IdItem, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "CodigoBarras", ALM_ItemMastFN::CodigoBarras, "LIKE", "%%s%" );
        //$o_GridAction->addConditionFilter( "IdItem", ALM_ItemMastFN::CodigoInterno, "LIKE", "%%s%" );
        
        $o_GridAction->addConditionFilter( "DescripcionCompleta", ALM_ItemMastFN::DescripcionCompleta, "LIKE", "%%s%" );

        if( $this->getRequestParameter( 'IdItem' ) )
        {
            ALM_ItemMastFN::setBuscarPorTermino( $this->getRequestParameter( 'IdItem' ) );
        }

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //cambios por los hoteles 2019-12-04
        //condicion especial para no mostrar los hoteles
        //solo se muestran todos los registros que se pueden registrar en transacciones
        //es parametro es para cuando se usa -> selectdos
         
        //$o_GridAction->addMethodDefault( "ALM_ItemTipo.IdItemTipo", array( 'Condition'=>'NOT IN', 'Value'=>"('03')" ) ); 
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        //$o_GridAction->addOrderDefault( ALM_ItemMastFN::IdItem, true );
        $o_GridAction->addOrderDefault( ALM_ItemMastFN::DescripcionCompleta, true );
        $o_GridAction->addMethodDefault( ALM_ItemMastFN::Estado, "A" );
        
        $o_GridAction->addRowsToShow( "IdItem", "CodigoBarras","DescripcionCompleta", "StockDisponible", "IdMarca" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->setMethodSelectCustomRs( "selectdos" );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $s_IdSucursal = ALM_AlmacenMastFN::recuperarIdSucursal( $IdAlmacen );
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        //$a_ResultJson['rows']    = $o_GridAction->getResultArray();
        $a_ResultSelect    = $o_GridAction->getResultSelect();
        $a_Rs = array();
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
        $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
        if( !$o_MST_ListaPrecioCabeceraBN )
        {
            $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
        }
        //////////////////////////////////////////////////////////////////////////////////////////
        //SE RECUPERA VALOR DE IGV ACTUAL
        $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
        $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18
        //////////////////////////////////////////////////////////////////////////////////////////

        $f_TipoCob      = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        foreach ( $a_ResultSelect as $iKey => $o_ObjClassBN )
        {
            $o_ObjClassBN->setIdCompania( myUser::getUser()->getIdBusiness() );
            //$o_ObjClassBN->setIdAlmacen( $IdAlmacen );
            //$o_ObjClassBN->setIdSucursal( $s_IdSucursal );
            
            /*$PrecioFinal = 0;
            if( myUser::getUser()->getIdSucursal() )
            {
                $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                $o_MST_ListaPrecioDetalleFN->addOrderBy( MST_ListaPrecioDetalleFN::PorcentajeUtilidad, false );
                $o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal(), $o_ObjClassBN->getIdItem(), "1" );

                if( !$o_MST_ListaPrecioDetalleBN )
                {
                    $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $o_ObjClassBN->getIdItem() );
                }

                if( $o_MST_ListaPrecioDetalleBN )
                {
                    $f_PrecioUnidad = $o_MST_ListaPrecioDetalleBN->getPrecioVenta();
                    
                    if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
                    {
                        if( $moneda_cod == "LO" )
                        {
                            $PrecioFinal = floatval( $f_PrecioUnidad ) * $f_ValorIGVMasUno;
                        }
                        if( $moneda_cod == "EX" )
                        {
                            $PrecioUnitarioME = utilMath::fnround( $f_PrecioUnidad / $f_TipoCob, 2 );
                            $PrecioFinal = $PrecioUnitarioME * $f_ValorIGVMasUno;
                        }
                    }
                    
                    if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "EX" ) //MONEDA DE LA LISTA DE PRECIOS ES DOLARES
                    {
                        if( $moneda_cod == "LO" )
                        {
                            $PrecioUnitarioSoles = utilMath::fnround( floatval( $f_PrecioUnidad ) * $f_TipoCob, 2 );
                            $PrecioFinal = $PrecioUnitarioSoles * $f_ValorIGVMasUno;
                        }
                        if( $moneda_cod == "EX" )
                        {
                            $PrecioFinal = floatval( $f_PrecioUnidad ) * $f_ValorIGVMasUno;
                        }
                    }
                }
            }*/
            
            $a_Rs[] = array
            (
                "IdItem"              => utf8_encode( $o_ObjClassBN->getIdItem() ),
                "IdLote"              => $o_ObjClassBN->getIdLote(),
                //"ConcatLoteFecV"      => $o_ObjClassBN->getConcatLoteFecV(),
                "DescripcionCompleta" => ( $o_ObjClassBN->getDescripcionCompleta() ),
                "Stock"               => number_format( $o_ObjClassBN->getStockDisponible(), 0 ),

                //"PrecioFinal"         => utilMath::fnround( $PrecioFinal, 2 ),
                //"PrecioxCaja"         => $o_ObjClassBN->getCantidadUnidad()>1 ? utilMath::fnround( $PrecioFinal, 2 ) : "",
                //"PrecioxUni"          => $o_ObjClassBN->getCantidadUnidad()>1 ? round( $PrecioFinal/$o_ObjClassBN->getCantidadUnidad(), 2) : utilMath::fnround( $PrecioFinal, 2 ),

                "UniMedVentaDesc"     => $o_ObjClassBN->getUniMedVentaDesc(),
                "IdUniMedVenta"       => $o_ObjClassBN->getIdUniMedVenta(),
                "CantUniMedVenta"     => round( $o_ObjClassBN->getCantUniMedVenta(), 2 ),

                //"CantidadxCaja"       => $o_ObjClassBN->getCantidadxCaja(),
                //"CantidadxUnidad"     => $o_ObjClassBN->getCantidadxUnidad(),
                //"CantUniMedVentaTexto" => !$o_ObjClassBN->getCantUniMedVentaTexto()?'0':$o_ObjClassBN->getCantUniMedVentaTexto(),

                "Marca"               => $o_ObjClassBN->getIdMarca(),
            );
        }
        
        $a_ResultJson['rows'] = $a_Rs;
        
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeReporte()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $this->noedit     = $this->getRequestParameter( 'noedit' );
        $this->action     = is_null( $this->getRequestParameter( 'action' ) ) ? "transacciones/addedit" : str_replace( "_", "/", $this->getRequestParameter( 'action' ) );
        $this->action2    = is_null( $this->getRequestParameter( 'action' ) ) ? "transacciones/addedit" : $this->getRequestParameter( 'action' );
        
        $a_Ids = explode( "_", $this->i_Id );
        $IdCompania      = $a_Ids[0];
        $IdTipoDocumento = $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];
        
        $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
        $this->o_ALM_TransaccionCabeceraBN = $o_ALM_TransaccionCabeceraFN->selectByPK( $IdCompania, $IdTipoDocumento, $NumeroDocumento );
        if( !$this->o_ALM_TransaccionCabeceraBN )
        {
            pr( "La Transaccion no existe." );
            exit;
        }
        
        //EMPRESA
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $IdCompania );
        
        //ALMACEN DE ORIGEN
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $this->o_ALM_AlmacenMastOrgBN = $o_ALM_AlmacenMastFN->selectByPK( $this->o_ALM_TransaccionCabeceraBN->getIdAlmacen() );
        
        //ALMACEN DESTINO
        $this->o_ALM_AlmacenMastDstBN = $o_ALM_AlmacenMastFN->selectByPK( $this->o_ALM_TransaccionCabeceraBN->getAlmacenTraslado() );
        if( !$this->o_ALM_AlmacenMastDstBN )
        {
            $this->o_ALM_AlmacenMastDstBN = new ALM_AlmacenMastBN();
        }
        
        //TRANSACCION
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $this->o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $this->o_ALM_TransaccionCabeceraBN->getIdTransaccion() );
        
        //DOCUMENTO A GENERAR
        $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN();
        $this->o_ALM_TipoDocumentoBN = $o_ALM_TipoDocumentoFN->selectByPK( $this->o_ALM_TransaccionCabeceraBN->getIdTipoDocumento() );
        
        //DOCUMENTO REFERENCIA
        //$o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN();
        $this->o_ALM_TipoDocumentoDocRefBN = ALM_TipoDocumentoFN::buscarDocumentoReferencia( $this->o_ALM_TransaccionCabeceraBN->getReferenciaTipoDocumento() );
        
        //UNIDAD DE MEDIDA
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $this->a_MST_UnidadMast = $o_MST_UnidadMastFN->select();
        
        //DETALLES
        $o_ALM_TransaccionDetalleFN = new ALM_TransaccionDetalleFN();
        $o_ALM_TransaccionDetalleFN->setIdCompania( $IdCompania );
        $o_ALM_TransaccionDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
        $o_ALM_TransaccionDetalleFN->setIdNumeroDocumento( $NumeroDocumento );
        $this->a_ALM_TransaccionDetalle = $o_ALM_TransaccionDetalleFN->select();
    }
}