<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;

class osActions extends wtActions
{
    public function executePrintPDF()
    {
        $i_Id          = $this->getRequestParameter( 'Id' );
        
        $a_Ids         = explode( "_", $i_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        //pr( $o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );
        
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $o_COM_OrdenItemClasificacionBN = $o_COM_OrdenItemClasificacionFN->selectByPK( $o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $o_COM_OrdenCompraCabeceraBN->getIdProveedor() );
        
        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
        $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( $IdOrdenCompra );
        $o_COM_OrdenCompraDetalleFN->setIdCompania( $IdCompania );
        $a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraDetalleFN->select();
        
        //$o_GSS_CompaniaBN = GSS_CompaniaFN::buscarCompania();
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPk( $IdCompania );
        
        $s_Moneda = GSS_MonedaMastFN::getDescripcionxId( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() );
        
        $u_usuario_name = $this->getRequestParameter( 'u_usuario_name' );
        
        //////////////////////////////////////////////////////////////////////////////////////
        
        $s_Class  = Parameter::getInstance()->getModule();
        $s_Module = strtolower( $s_Class );
        $s_Action = Parameter::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        
        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();
        
        //echo $html; exit;
        
        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();
        $dompdf->stream( 'Orden_Compra_'.str_pad( $IdOrdenCompra, 10, "0", STR_PAD_LEFT ), array("Attachment"=>0) );
        //////////////////////////////////////////////////////////////////////////////////////
        
        exit;
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }
    
    public function executeGrid()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new COM_OrdenCompraCabeceraFN() );
        
        $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        $o_GridAction->addMethodDefault( COM_OrdenCompraCabeceraFN::IdOrdenClasificacion, "CA00002" );
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdAlmacenEntrega" );
        $o_GridAction->addAssignFilter( "TipoOrden" );
        $o_GridAction->addAssignFilter( "Estado" );
        $o_GridAction->addAssignFilter( "IdProveedor" );
        
        $o_GridAction->addConditionFilter( "IdOrdenCompra", COM_OrdenCompraCabeceraFN::IdOrdenCompra, "LIKE", "%%s%" );
        //$o_GridAction->addConditionFilter( "NombreProveedor", COM_OrdenCompraCabeceraFN::NombreProveedor, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", "LEFT(".COM_OrdenCompraCabeceraFN::FechaCreacion.",10)", ">=" );
        $o_GridAction->addConditionFilter( "FechaDocumento2", "LEFT(".COM_OrdenCompraCabeceraFN::FechaCreacion.",10)", "<=" );
        
        $o_GridAction->addOrderDefault( COM_OrdenCompraCabeceraFN::IdOrdenCompra, false );
        
        $o_GridAction->addRowsToShow
        (
                "IdOrdenCompraConcat", "IdOrdenCompra", "TipoOrden", "IdOrdenClasificacion", "FechaCreacion", "NumeroInterno", "MonedaDesc",
                "NombreProveedor", "Estado", "FormatMontoBruto", "FormatMontoDolares", "FechaEntrega", "AlmacenDesc", "EstadoDesc", "TipoOCDesc"
                );
        
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $o_COM_OrdenItemClasificacionFN->setEstado( "A" );
        $o_COM_OrdenItemClasificacionFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_COM_OrdenItemClasificacionFN->addCondition( COM_OrdenItemClasificacionFN::IdItemTipo, "IN", "('02')", false );
        $this->a_COM_OrdenItemClasificacion = $o_COM_OrdenItemClasificacionFN->select();
        
        $this->o_ALM_AlmacenMastBN = null;
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::Estado ,"<>", "I" );
        //$o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::IdAlmacen , "IN", "( SELECT IdAlmacen FROM ALM_ItemAlmacenStock S LEFT JOIN ALM_ItemMast I ON I.IdItem=S.IdItem WHERE I.IdItemTipo=\"02\" AND S.StockActual>0 )", false );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::IdCompania );
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastFN->setEstado( "A" );
        $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();
        //pr( $this->a_GSS_MonedaMast );
        $this->s_Titulo = "Nuevo O/S";
        $this->noedit = "";
        $this->o_COM_OrdenCompraCabeceraBN = new COM_OrdenCompraCabeceraBN();
        $this->o_COM_OrdenCompraCabeceraBN->setFechaEntrega( date( "Y-m-d" ) );
        //$this->o_COM_OrdenCompraCabeceraBN->setIdOrdenClasificacion( "TOC005" );
        $this->o_COM_OrdenCompraCabeceraBN->setTipoCambio( GSS_TipoCambioFN::getStaticTipoCambioVenta() );
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar O/S";
            
            $a_Ids = explode( "_", $this->i_Id );
            $IdCompania    = $a_Ids[0];
            $IdOrdenCompra = $a_Ids[1];
            
            $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
            $this->o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
            //pr( $this->o_COM_OrdenCompraCabeceraBN->getIdProveedor() );
            if( $this->o_COM_OrdenCompraCabeceraBN->getEstado() != COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_PREPARACION )
            {
                $this->noedit = "noedit=2";
            }
            //pr( $this->o_COM_OrdenCompraCabeceraBN );
            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $this->o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
            //pr( $this->o_ALM_AlmacenMastBN );
        }
    }
    
    public function executeSaveAddEdit()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $IdCompania           = $this->getRequestParameter( 'IdCompania' );
        $IdProveedor          = $this->getRequestParameter( 'IdProveedor' );
        $NombreProveedor      = $this->getRequestParameter( 'NombreProveedor' );
        $NumeroInterno        = $this->getRequestParameter( 'NumeroInterno' );
        $IdOrdenClasificacion = $this->getRequestParameter( 'IdOrdenClasificacion' ); //
        $IdMoneda             = $this->getRequestParameter( 'IdMoneda' );
        $Observacion          = $this->getRequestParameter( 'Observacion' );
        $IdAlmacenEntrega     = $this->getRequestParameter( 'IdAlmacenEntrega' );
        $FechaEntrega         = $this->getRequestParameter( 'FechaEntrega' ); //
        
        $IdMonedaPago         = $this->getRequestParameter( 'IdMonedaPago' ); //
        $ObservacionEntrega   = $this->getRequestParameter( 'ObservacionEntrega' ); //
        $Descripcion          = $this->getRequestParameter( 'Descripcion' ); //
        
        //$f_TipoCambio         = GSS_TipoCambioFN::getTipoCambioValor();
        $f_TipoCambio         = floatval( $this->getRequestParameter( 'TipoCambio' ) ); //
        
        $TipoOrden            = $this->getRequestParameter( 'TipoOrden' );

        $s_IdProyecto         = $this->getRequestParameter( 'IdProyecto' );
        $s_ProyectoNombre     = $this->getRequestParameter( 'ProyectoNombre' );
        
        try
        {
            myUser::getUser()->validar_session();
            
            if( $IdMoneda == "LO" )
            {
                //$f_TipoCambio = 1;
            }
            
            if( !$f_TipoCambio )
            {
                throw new Exception( "Debe de registrar el Tipo de Cambio de hoy." );
            }
            
            if( !$IdProveedor )
            {
                throw new Exception( "Se necesita el Proveedor." );
            }
            
            $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
            $o_COM_OrdenCompraCabeceraDP->setIdProveedor( ( int ) $IdProveedor );
            $o_COM_OrdenCompraCabeceraDP->setIdOrdenClasificacion( $IdOrdenClasificacion );
            $o_COM_OrdenCompraCabeceraDP->setNombreProveedor( $NombreProveedor );
            $o_COM_OrdenCompraCabeceraDP->setNumeroInterno( $NumeroInterno );
            $o_COM_OrdenCompraCabeceraDP->setIdMoneda( $IdMoneda );
            $o_COM_OrdenCompraCabeceraDP->setObservacion( $Observacion );
            $o_COM_OrdenCompraCabeceraDP->setIdAlmacenEntrega( $IdAlmacenEntrega );
            $o_COM_OrdenCompraCabeceraDP->setIdAlmacenIngreso( $IdAlmacenEntrega );
            $o_COM_OrdenCompraCabeceraDP->setFechaEntrega( $FechaEntrega );
            $o_COM_OrdenCompraCabeceraDP->setTipoOrden( $TipoOrden );
            $o_COM_OrdenCompraCabeceraDP->setAfectoIGV( 1 );
            $o_COM_OrdenCompraCabeceraDP->setTerminoId( 1 );
            $o_COM_OrdenCompraCabeceraDP->setIdProyecto( ( int ) $s_IdProyecto );
            $o_COM_OrdenCompraCabeceraDP->setProyectoNombre( $s_ProyectoNombre );
            $o_COM_OrdenCompraCabeceraDP->setDescripcion( $Descripcion );
            
            $o_COM_OrdenCompraCabeceraDP->setIdMonedaPago( $IdMonedaPago );
            $o_COM_OrdenCompraCabeceraDP->setObservacionEntrega( $ObservacionEntrega );
            
            $o_COM_OrdenCompraCabeceraDP->setTipoCambio( $f_TipoCambio );
            
            if( $s_TipoProc == "nvo" )
            {
                //INSERT
                $o_COM_OrdenCompraCabeceraDP->setObservacionRechazo( "S" );
                $o_COM_OrdenCompraCabeceraDP->setMontoAfecto( 0.00 );
                $o_COM_OrdenCompraCabeceraDP->setMontoNoAfecto( 0.00 );
                $o_COM_OrdenCompraCabeceraDP->setMontoIGV( 0.00 );
                $o_COM_OrdenCompraCabeceraDP->setMontoBruto( 0.00 );
                
                $o_COM_OrdenCompraCabeceraDP->setIdCompania( ( int ) $IdCompania );
                $o_COM_OrdenCompraCabeceraDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $i_Id = COM_OrdenCompraCabeceraDP::recuperarId();
                $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( ( int ) $i_Id );
                $o_COM_OrdenCompraCabeceraDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraCabeceraDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_COM_OrdenCompraCabeceraDP->setFechaPreparacion( date( "Y-m-d H:i:s" ) );
                $o_COM_OrdenCompraCabeceraDP->setPreparadoPor( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraCabeceraDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_PREPARACION ); //por defecto
                $b_Result = $o_COM_OrdenCompraCabeceraDP->save();
                $i_Id = $IdCompania."_".$i_Id;
            }
            else
            {
                //UPDATE
                $i_Id = $this->getRequestParameter( 'i_Id' );
                
                $a_Ids = explode( "_", $i_Id );
                $IdCompania    = $a_Ids[0];
                $IdOrdenCompra = $a_Ids[1];
                
                $o_COM_OrdenCompraCabeceraDP->setIdCompania( ( int ) $IdCompania );
                $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( ( int ) $IdOrdenCompra );
                $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_COM_OrdenCompraCabeceraDP->update();
            }
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeDetail()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_externo = $this->getRequestParameter( 'externo' );
        //$this->noedit     = is_null( $this->getRequestParameter( 'noedit' ) ) ? "2" : $this->getRequestParameter( 'noedit' );
        //$this->action     = is_null( $this->getRequestParameter( 'action' ) ) ? "oc/addedit" : str_replace( "_", "/", $this->getRequestParameter( 'action' ) );
        //$this->action2    = is_null( $this->getRequestParameter( 'action' ) ) ? "oc_addedit" : $this->getRequestParameter( 'action' );
        
        $this->s_Titulo = "Editar O/S";
        
        $a_Ids = explode( "_", $this->i_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $this->o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdCompania() );
        
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $this->o_COM_OrdenItemClasificacionBN = $o_COM_OrdenItemClasificacionFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );
        
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $o_MST_UnidadMastFN->setEstado( "A" );
        $this->a_MST_UnidadMast = $o_MST_UnidadMastFN->select();
        //pr( $this->a_MST_UnidadMast );
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $this->o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdMoneda() );
    }
    
    public function executeConfirmacion()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->a_EstadosOC = array( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_APROBADO => "APROBADO" );
    }
    
    public function executeProcess()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $this->IdTrans    = $this->getRequestParameter( 'IdTrans' );
        
        $a_Ids = explode( "_", $this->i_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $this->o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdCompania() );
        
        $o_ALM_ItemTipoFN = new ALM_ItemTipoFN();
        $this->o_ALM_ItemTipoBN = $o_ALM_ItemTipoFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $this->o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdMoneda() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $this->o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
        
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $this->o_COM_OrdenItemClasificacionBN = $o_COM_OrdenItemClasificacionFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );
        
        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
        $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( $IdOrdenCompra );
        $o_COM_OrdenCompraDetalleFN->setIdCompania( $IdCompania );
        $o_COM_OrdenCompraDetalleFN->addOrderBy( COM_OrdenCompraDetalleFN::IdItem );
        $a_Result = $o_COM_OrdenCompraDetalleFN->select();
        $this->a_COM_OrdenCompraDetalle = array();
        if( $a_Result )
        {
            $this->a_COM_OrdenCompraDetalle = $a_Result;
        }
        
        $this->s_IdConcat = $this->o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega()."_".$this->o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra()."_".$this->o_COM_OrdenCompraCabeceraBN->getIdProveedor();
    }
}