<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;

class PrintPDFAction extends wtActions
{
    public function execute()
    {
        $i_Id          = $this->getRequestParameter( 'Id' );
        
        $a_Ids         = explode( "_", $i_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        //pr( $o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );
        
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $o_COM_OrdenItemClasificacionBN = $o_COM_OrdenItemClasificacionFN->selectByPK( $o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $o_COM_OrdenCompraCabeceraBN->getIdProveedor() );
        
        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
        $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( $IdOrdenCompra );
        $o_COM_OrdenCompraDetalleFN->setIdCompania( $IdCompania );
        $a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraDetalleFN->select();
        
        //$o_GSS_CompaniaBN = GSS_CompaniaFN::buscarCompania();
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPk( $IdCompania );
        
        $s_Moneda = GSS_MonedaMastFN::getDescripcionxId( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() );
        
        $u_usuario_name = $this->getRequestParameter( 'u_usuario_name' );
        
        //////////////////////////////////////////////////////////////////////////////////////
        
        $s_Class  = ParameterWR::getInstance()->getModule();
        $s_Module = strtolower( $s_Class );
        $s_Action = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        
        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html; exit;
        
        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();
        $dompdf->stream( 'Orden_Compra_'.str_pad( $IdOrdenCompra, 10, "0", STR_PAD_LEFT ), array("Attachment"=>0) );
        //////////////////////////////////////////////////////////////////////////////////////
        
        exit;
    }
}