<?php
class RequestFactAlmAction extends wtActions
{
    public function execute()
    {
        $s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        $a_Result   = array();
        $b_Control  = true;

        try
        {
            switch ( $s_TipoProc )
            {
                case "BuscarTipoCambio":

                    $s_Fecha = $this->getRequestParameter( 'Fecha' );
                    $f_TipoCambio = GSS_TipoCambioFN::getStaticTipoCambioVenta( $s_Fecha );
                    $a_lst['TipoCambio'] = $f_TipoCambio;

                    echo json_encode( $a_lst );
                    exit;

                break;
                case "BuscarComprobantesProv":

                    $s_Id       = $this->getRequestParameter( 'Id' );
                    $s_IdMoneda = $this->getRequestParameter( 'IdMoneda' );

                    $s_ProveedorId = $this->getRequestParameter( 'ProveedorId' );

                    $o_CP_ObligacionesFN = new CP_ObligacionesFN();
                    $o_CP_ObligacionesFN->setIdMoneda( $s_IdMoneda );
                    $o_CP_ObligacionesFN->setProveedorId( $s_ProveedorId );
                    $o_CP_ObligacionesFN->setEstado( CP_ObligacionesBN::ESTADO_VALIDADO );
                    //$o_CP_ObligacionesFN->setEstadoPagado( CP_ObligacionesBN::ESTADO_PAG_PENDIENTE );
                    $o_CP_ObligacionesFN->addCondition( CP_ObligacionesFN::IdTipoDocumento, "NOT IN", "('NC','LC','LB')", false );
                    $a_CP_Obligaciones = $o_CP_ObligacionesFN->select();
                    if( $a_CP_Obligaciones )
                    {
                        foreach( $a_CP_Obligaciones as $i_Key => $o_CP_ObligacionesBN )
                        {
                            $a_Result['data'][ $i_Key ]                        = $o_CP_ObligacionesBN->toArray();
                            $a_Result['data'][ $i_Key ]['TipoComprobanteDesc'] = $o_CP_ObligacionesBN->getObjectTipoDocumento()->getDescripcionLocal();
                            $a_Result['data'][ $i_Key ]['MonedaDesc']          = $o_CP_ObligacionesBN->getObjectMoneda()->getDescripcion();
                            $a_Result['data'][ $i_Key ]['MontoTotalFormat']    = number_format( $o_CP_ObligacionesBN->getMontoTotal(), 2 );
                            $a_Result['data'][ $i_Key ]['MontoSaldoFormat']    = number_format( $o_CP_ObligacionesBN->getMontoSaldo(), 2 );
                        }
                    }
                    else
                    {
                        $a_Result['data'][] = array( "i_ObligacionesId" => "", "TipoComprobanteDesc" => "", "s_DocumentoSerieNumero" => "", "MonedaDesc" => "", "MontoTotalFormat" => "", "MontoSaldoFormat" => "" );
                    }

                break;
                case "getOrdenCompraInfo":

                    $s_IdOrdenCompra = $this->getRequestParameter( 'IdOrdenCompra' );

                    $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                    $o_COM_OrdenCompraCabeceraFN->setIdOrdenCompra( $s_IdOrdenCompra );
                    $a_COM_OrdenCompraCabecera = $o_COM_OrdenCompraCabeceraFN->select();
                    if( $a_COM_OrdenCompraCabecera )
                    {
                        $o_COM_OrdenCompraCabeceraBN = $a_COM_OrdenCompraCabecera[0];
                        $a_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraBN->toArray();
                        $a_Result = $a_COM_OrdenCompraCabeceraBN;
                        //pr( $a_COM_OrdenCompraCabeceraBN );
                    }

                break;
                case "BuscarOrdenCompra":

                    /*$a_Result['data'][] = array( "Tiger Nixon", "System Architect", "Edinburgh", "5421", "2011/04/25", "" );
                    $a_Result['data'][] = array( "William", "System Architect", "Edinburgh", "5421", "2011/04/25", "" );
                    $a_Result['data'][] = array( "rosa liz", "System Architect", "Edinburgh", "5421", "2011/04/25", "" );*/

                    $s_ProveedorId = $this->getRequestParameter( 'ProveedorId' );

                    $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                    $o_COM_OrdenCompraCabeceraFN->setIdProveedor( $s_ProveedorId );
                    $o_COM_OrdenCompraCabeceraFN->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_COMPLETADO );
                    $o_COM_OrdenCompraCabeceraFN->addOrderBy( COM_OrdenCompraCabeceraFN::IdOrdenCompra, false );
                    $a_COM_OrdenCompraCabecera = $o_COM_OrdenCompraCabeceraFN->select();

                    foreach( $a_COM_OrdenCompraCabecera as $o_COM_OrdenCompraCabeceraBN )
                    {
                        $a_Result['data'][] = array
                        (
                            "IdOrdenCompra"     => $o_COM_OrdenCompraCabeceraBN->getIdOrdenCompra(),
                            "NombreProveedor"   => $o_COM_OrdenCompraCabeceraBN->getNombreProveedor(),
                            "Descripcion"       => $o_COM_OrdenCompraCabeceraBN->getDescripcion(),
                            "FechaEntrega"      => substr( $o_COM_OrdenCompraCabeceraBN->getFechaEntrega(), 0, 10 ),
                            "MonedaDesc"        => $o_COM_OrdenCompraCabeceraBN->getMonedaDesc(),
                            "UsuarioCreacion"   => $o_COM_OrdenCompraCabeceraBN->getUsuarioCreacion(),
                            "TipoOCDesc"        => $o_COM_OrdenCompraCabeceraBN->getTipoOCDesc(),
                            //"TipoOrden"         => $o_COM_OrdenCompraCabeceraBN->getTipoOrden(),
                            "ClasificacionDesc" => $o_COM_OrdenCompraCabeceraBN->getOrdenClasificacionDesc(),
                            "MontoBruto"        => number_format( $o_COM_OrdenCompraCabeceraBN->getMontoBruto(), 2 ),
                            "MontoSaldo"        => number_format( $o_COM_OrdenCompraCabeceraBN->getMontoPendientePago(), 2 ),
                            //"option" => ""
                        );
                    }

                break;
                case "AutocompleteDocProv":

                    $s_Termino = $this->getRequestParameter( 'term' );

                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    //$o_MST_PersonaMastFN->setDebug( true );
                    $o_MST_PersonaMastFN->setEstado( "A" );
                    //$o_MST_PersonaMastFN->setEsCliente( "SI" );
                    $o_MST_PersonaMastFN->setEsProveedor( "SI" );
                    $o_MST_PersonaMastFN->addCondition( MST_PersonaMastFN::Documento, "LIKE", "%$s_Termino%" );
                    $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
                    $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
                    foreach ( $a_MST_PersonaMast as $i_Key => $o_MST_PersonaMastBN )
                    {
                        $a_Result[] = array( "value" => $o_MST_PersonaMastBN->getDocumento(), "label" => $o_MST_PersonaMastBN->getDocumento()." - ".$o_MST_PersonaMastBN->getNombreCompletoLLeno(), "id" => $o_MST_PersonaMastBN->getIdPersona() );
                    }

                break;
                case "AutocompleteProv":

                    $s_Termino = $this->getRequestParameter( 'term' );

                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    //$o_MST_PersonaMastFN->setDebug( true );
                    $o_MST_PersonaMastFN->setEstado( "A" );
                    $o_MST_PersonaMastFN->setEsProveedor( "SI" );
                    $o_MST_PersonaMastFN->addCondition( MST_PersonaMastFN::NombreCompleto, "LIKE", "%$s_Termino%" );
                    $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
                    $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
                    foreach ( $a_MST_PersonaMast as $i_Key => $o_MST_PersonaMastBN )
                    {
                        $a_Result[] = array( "value" => trim( $o_MST_PersonaMastBN->getNombreCompletoLLeno() ), "label" => trim( $o_MST_PersonaMastBN->getNombreCompletoLLeno() ), "id" => $o_MST_PersonaMastBN->getIdPersona() );
                    }

                break;

                case "getProveedorInfo":

                    $i_IdTipoDocumento = $this->getRequestParameter( 'IdTipoDocumento' );
                    $i_IdPersona       = $this->getRequestParameter( 'IdPersona' );

                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $i_IdPersona );

                    $s_NombreCompleto = $o_MST_PersonaMastBN->getNombreCompleto();
                    $s_TipoDocumento  = $o_MST_PersonaMastBN->getTipoDocumento();
                    $s_Documento      = $o_MST_PersonaMastBN->getDocumento();

                    $a_Result['Nombre']            = $s_NombreCompleto;
                    $a_Result['TipoDocumento']     = $s_TipoDocumento;
                    $a_Result['Documento']         = $s_Documento;
                    $a_Result['DepartamentoDesc']  = $o_MST_PersonaMastBN->getDepartamentoDesc();
                    $a_Result['ProvinciaDesc']     = $o_MST_PersonaMastBN->getProvinciaDesc();
                    $a_Result['DistritoDesc']      = $o_MST_PersonaMastBN->getDistritoDesc();
                    $a_Result['IdUbigeo']          = $o_MST_PersonaMastBN->getDistrito();
                    $a_Result['Direccion']         = $o_MST_PersonaMastBN->getDireccion();

                break;

                default:
                    $a_Result   = array( "Result" => false, "error" => false );
                break;
            }

            //$a_Result['status'] = "success";
            //$a_Result['error'] = false;
            //$a_Result['code'] = 200;
        }
        catch ( Exception $o_Exception )
        {
            $a_Result['error']         = true;
            $a_Result['mensaje_error'] = $o_Exception->getMessage();
        }

        header( 'Content-Type: application/json' );
        echo json_encode( $a_Result );
        return ViewResponse::NONE;
    }
}

