<?php
class GuardarCajaChicaDetAction extends wtActions
{
    public function execute()
    {
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        //$TypeSub    = $this->getRequestParameter( 'TypeSub' );

        $s_FechaDocumento = $this->getRequestParameter( 'FechaDocumento' );
        $s_TipoDocProv    = $this->getRequestParameter( 'TipoDocProv' );
        $s_NumDocProv     = $this->getRequestParameter( 'NumDocProv' );
        $s_NomProv        = $this->getRequestParameter( 'NomProv' );
        $s_Comentario     = htmlentities( $this->getRequestParameter( 'Comentario' ) );
        $s_Estado         = $this->getRequestParameter( 'Estado' );

        $s_ReferenciaIdTransaccion    = $this->getRequestParameter( 'ReferenciaIdTransaccion' );
        $s_ReferenciaTipoDocumento    = $this->getRequestParameter( 'ReferenciaTipoDocumento' );
        $s_ReferenciaSerieDocumento   = $this->getRequestParameter( 'ReferenciaSerieDocumento' ); //
        $s_ReferenciaNumeroDocumento  = $this->getRequestParameter( 'ReferenciaNumeroDocumento' ); //

        $s_EsInventariableFlag        = $this->getRequestParameter( 'EsInventariableFlag' ); //
        
        $s_SerieDocumento     = str_pad( $s_ReferenciaSerieDocumento, 4, "0", STR_PAD_LEFT );
        $s_NumeroDocumento    = str_pad( $s_ReferenciaNumeroDocumento, 8, "0", STR_PAD_LEFT );

        $a_Descripcion         = $this->getRequestParameter( 'Descripcion' );
        $a_IdItem              = $this->getRequestParameter( 'IdItem' );
        $a_Cantidad            = $this->getRequestParameter( 'Cantidad' );
        $a_MontoUnitarioConIGV = $this->getRequestParameter( 'MontoUnitarioConIGV' );
        $a_MontoTotal          = $this->getRequestParameter( 'MontoTotal' );
        $a_MontoSubTotal       = $this->getRequestParameter( 'MontoSubTotal' );
        $a_MontoIGV            = $this->getRequestParameter( 'MontoIGV' );

        $s_SumaMontoSubTotal = floatval( $this->getRequestParameter( 'SumaMontoSubTotal' ) );
        $s_SumaMontoIGV      = floatval( $this->getRequestParameter( 'SumaMontoIGV' ) );
        $s_SumaMontoTotal    = floatval( $this->getRequestParameter( 'SumaMontoTotal' ) );

        try 
        {
            myUser::getUser()->validar_session();
            
            $o_TMP_ALM_CajaChicaCabBN = ALM_CajaChicaCabFN::getActivoActual();
            if( !$o_TMP_ALM_CajaChicaCabBN )
            {
                throw new Exception( "No se encontro Abierto la Caja Chica." );
            }

            $o_ALM_CajaChicaDetDP = new ALM_CajaChicaDetDP();
            $o_ALM_CajaChicaDetDP->setFechaDocumento( $s_FechaDocumento." ".date( "H:i:s" ) );
            $o_ALM_CajaChicaDetDP->setTipoDocProv( $s_TipoDocProv );
            $o_ALM_CajaChicaDetDP->setNumDocProv( $s_NumDocProv );
            $o_ALM_CajaChicaDetDP->setNomProv( $s_NomProv );
            $o_ALM_CajaChicaDetDP->setEsInventariableFlag( $s_EsInventariableFlag ); //-- S si  //  N no
            if( $s_ReferenciaIdTransaccion )
            {
                $o_ALM_CajaChicaDetDP->setReferenciaIdTransaccion( $s_ReferenciaIdTransaccion );
            }
            $o_ALM_CajaChicaDetDP->setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento );
            $o_ALM_CajaChicaDetDP->setReferenciaSerieDocumento( $s_SerieDocumento );
            $o_ALM_CajaChicaDetDP->setReferenciaNumeroDocumento( $s_NumeroDocumento );
            $o_ALM_CajaChicaDetDP->setEstado( ALM_CajaChicaDetBN::ESTADO_APROBADO ); // A aprobado // C cancelado
            $o_ALM_CajaChicaDetDP->setMontoTotal( $s_SumaMontoTotal );
            $o_ALM_CajaChicaDetDP->setMontoSubTotal( $s_SumaMontoSubTotal );
            $o_ALM_CajaChicaDetDP->setMontoIGV( $s_SumaMontoIGV );
            $o_ALM_CajaChicaDetDP->setComentario( $s_Comentario );

            if( $s_TipoProc == "nvo" )
            {
                $i_IdTabla = ALM_CajaChicaDetDP::recuperarId();
                $o_ALM_CajaChicaDetDP->setIdCajaDet( $i_IdTabla );
                $o_ALM_CajaChicaDetDP->setIdCaja( $o_TMP_ALM_CajaChicaCabBN->getIdCaja() );
                $o_ALM_CajaChicaDetDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_CajaChicaDetDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ALM_CajaChicaDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_CajaChicaDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_CajaChicaDetDP->save();
                //pr( $o_ALM_CajaChicaDetDP );
                $i_Id = $i_IdTabla;
            }
            else
            {
                //en teoria no deberia haber update
                //actualizar
                $o_ALM_CajaChicaDetDP->setIdCaja( intval( $i_Id ) );
                $o_ALM_CajaChicaDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_CajaChicaDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_CajaChicaDetDP->update();
            }

            //ahora se guarda los detalles
            foreach ( $a_Descripcion as $i_Key => $s_Value ) 
            {
                $o_ALM_CajaChicaItemDP = new ALM_CajaChicaItemDP();
                $o_ALM_CajaChicaItemDP->setIdCajaDet( $i_Id );
                $o_ALM_CajaChicaItemDP->setIdSecuencia( ( $i_Key + 1 ) );
                if( $this->getRequestParameter( 'IdItem' ) )
                {
                    $o_ALM_CajaChicaItemDP->setIdItem( $a_IdItem[$i_Key] );
                }
                $o_ALM_CajaChicaItemDP->setDescripcion( $s_Value );
                $o_ALM_CajaChicaItemDP->setCantidad( floatval( $a_Cantidad[$i_Key] ) );
                $o_ALM_CajaChicaItemDP->setMontoUnitarioConIGV( floatval( $a_MontoUnitarioConIGV[$i_Key] ) );
                $o_ALM_CajaChicaItemDP->setMontoSubTotal( floatval( $a_MontoSubTotal[$i_Key] ) );
                $o_ALM_CajaChicaItemDP->setMontoIGV( floatval( $a_MontoIGV[$i_Key] ) );
                $o_ALM_CajaChicaItemDP->setMontoTotal( floatval( $a_MontoTotal[$i_Key] ) );
                $o_ALM_CajaChicaItemDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_CajaChicaItemDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ALM_CajaChicaItemDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_CajaChicaItemDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_CajaChicaItemDP->save();
                //pr( $o_ALM_CajaChicaItemDP );
            }

            //ahora actualizamos la cabecera de caja chica
            //$o_ALM_CajaChicaCabDP = new ALM_CajaChicaCabDP();

            //$a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}